/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASCIIInputStream
extends FilterInputStream {
    private static final Logger logger = LoggerFactory.getLogger(ASCIIInputStream.class);

    public ASCIIInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        StringBuffer sbuf = new StringBuffer(2);
        int ch = this.in.read();
        if (ch == -1) {
            return -1;
        }
        sbuf.append((char)ch);
        if (sbuf.charAt(0) == ':') {
            return 1000;
        }
        if (sbuf.charAt(0) == '\r') {
            if (this.in.read() == 10) {
                return 2000;
            }
            throw new IOException("Malformed Stream No Frame Delims");
        }
        try {
            sbuf.append((char)this.in.read());
            logger.trace("Read byte: {}", (Object)sbuf.toString().toLowerCase());
            return Integer.parseInt(sbuf.toString().toLowerCase(), 16);
        }
        catch (NumberFormatException ex) {
            String errMsg = "Malformed Stream - Wrong Characters";
            logger.debug("{}: {}", (Object)"Malformed Stream - Wrong Characters", (Object)sbuf.toString());
            throw new IOException("Malformed Stream - Wrong Characters");
        }
    }
}

