/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationRole;

public final class ConfigurationRolesForMigration {
    @Deprecated
    public static final ConfigurationRole RESOLVABLE_DEPENDENCY_SCOPE_TO_RESOLVABLE = ConfigurationRolesForMigration.difference(ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE, ConfigurationRoles.RESOLVABLE);
    @Deprecated
    public static final ConfigurationRole RESOLVABLE_DEPENDENCY_SCOPE_TO_DEPENDENCY_SCOPE = ConfigurationRolesForMigration.difference(ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE, ConfigurationRoles.DEPENDENCY_SCOPE);
    @Deprecated
    public static final ConfigurationRole LEGACY_TO_RESOLVABLE_DEPENDENCY_SCOPE = ConfigurationRolesForMigration.difference(ConfigurationRoles.ALL, ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE);
    public static final Set<ConfigurationRole> ALL = ImmutableSet.of((Object)RESOLVABLE_DEPENDENCY_SCOPE_TO_RESOLVABLE, (Object)RESOLVABLE_DEPENDENCY_SCOPE_TO_DEPENDENCY_SCOPE, (Object)LEGACY_TO_RESOLVABLE_DEPENDENCY_SCOPE);

    private ConfigurationRolesForMigration() {
    }

    private static ConfigurationRole difference(ConfigurationRole initialRole, ConfigurationRole eventualRole) {
        Preconditions.checkArgument((!initialRole.isConsumptionDeprecated() && !initialRole.isResolutionDeprecated() && !initialRole.isDeclarationAgainstDeprecated() ? 1 : 0) != 0, (Object)"The initial role must not contain deprecated usages.");
        Preconditions.checkArgument((!eventualRole.isConsumptionDeprecated() && !eventualRole.isResolutionDeprecated() && !eventualRole.isDeclarationAgainstDeprecated() ? 1 : 0) != 0, (Object)"The eventual role must not contain deprecated usages.");
        boolean consumptionDeprecated = initialRole.isConsumable() && !eventualRole.isConsumable();
        boolean resolutionDeprecated = initialRole.isResolvable() && !eventualRole.isResolvable();
        boolean declarationAgainstDeprecated = initialRole.isDeclarable() && !eventualRole.isDeclarable();
        return new DefaultConfigurationRole(initialRole.getName(), initialRole.isConsumable(), initialRole.isResolvable(), initialRole.isDeclarable(), consumptionDeprecated, resolutionDeprecated, declarationAgainstDeprecated);
    }
}

