package mp4

import "github.com/wader/fq/pkg/scalar"

// from:
// https://cconcolato.github.io/mp4ra/filetype.html
// https://exiftool.org/TagNames/QuickTime.html
var brandDescriptions = scalar.StrMapDescription{
	"3g2a": "3GPP2",
	"3g2b": "3GPP2 Media (.3G2) compliant with 3GPP2 C.S0050-A V1.0.0",
	"3g2c": "3GPP2 Media (.3G2) compliant with 3GPP2 C.S0050-B v1.0",
	"3ge6": "3GPP Release 6 extended-presentation Profile",
	"3ge7": "3GPP Release 7 extended-presentation Profile",
	"3ge9": "3GPP Release 9 Extended Presentation Profile",
	"3gf9": "3GPP Release 9 File-delivery Server Profile",
	"3gg6": "3GPP Release 6 General Profile",
	"3gg9": "3GPP Release 9 General Profile",
	"3gh9": "3GPP Release 9 Adaptive Streaming Profile",
	"3gm9": "3GPP Release 9 Media Segment Profile",
	"3gp1": "3GPP Media (.3GP) Release 1 (probably non-existent)",
	"3gp2": "3GPP Media (.3GP) Release 2 (probably non-existent)",
	"3gp3": "3GPP Media (.3GP) Release 3 (probably non-existent)",
	"3gp4": "3GPP Release 4",
	"3gp5": "3GPP Release 5",
	"3gp6": "3GPP Release 6 basic Profile",
	"3gp7": "3GPP Release 7",
	"3gp8": "3GPP Release 8",
	"3gp9": "3GPP Release 9 Basic Profile",
	"3gr6": "3GPP Release 6 progressive-download Profile",
	"3gr9": "3GPP Release 9 Progressive DownloadProfile",
	"3gs6": "3GPP Release 6 streaming-server Profile",
	"3gs7": "3GPP Media (.3GP) Release 7 Streaming Servers",
	"3gs9": "3GPP Release 9 Streaming ServerProfile",
	"3gt8": "3GPP Release 8 Media Stream Recording Profile",
	"3gt9": "3GPP Release 9 Media Stream Recording Profile",
	"aax":  "Audible Enhanced Audiobook (.AAX)",
	"ARRI": "ARRI Digital Camera",
	"avc1": "Advanced Video Coding extensions",
	"avif": "AV1 Image File Format (.AVIF)",
	"bbxm": "Blinkbox Master File: H.264 video and 16-bit little-endian LPCM audio",
	"caaa": "CMAF Media Profile - AAC Adaptive Audio",
	"caac": "CMAF Media Profile - AAC Core",
	"CAEP": "Canon Digital Camera",
	"caqv": "Casio Digital Camera",
	"ccea": "CMAF Supplemental Data - CEA-608/708",
	"ccff": "Common container file format",
	"CDes": "Convergent Designs",
	"cfhd": "CMAF Media Profile - AVC HD",
	"cfsd": "CMAF Media Profile - AVC SD",
	"chd1": "CMAF Media Profile - HEVC HDR10",
	"chdf": "CMAF Media Profile - AVC HDHF",
	"chh1": "CMAF Media Profile - HEVC HHD10",
	"chhd": "CMAF Media Profile - HEVC HHD8",
	"clg1": "CMAF Media Profile - HEVC HLG10",
	"cmfc": "CMAF Track Format",
	"cmff": "CMAF Fragment Format",
	"cmfl": "CMAF Chunk Format",
	"cmfs": "CMAF Segment Format",
	"crx":  "Canon Raw (.CRX)",
	"cud1": "CMAF Media Profile - HEVC UHD10",
	"cud8": "CMAF Media Profile - HEVC UHD8",
	"cwvt": "CMAF Media Profile - WebVTT",
	"da0a": "DMB AF audio with MPEG Layer II audio, MOT slide show, DLS, JPG/PNG/MNG images",
	"da0b": "DMB AF, extending da0a , with 3GPP timed text, DID, TVA, REL, IPMP",
	"da1a": "DMB AF audio with ER-BSAC audio, JPG/PNG/MNG images",
	"da1b": "DMB AF, extending da1a, with 3GPP timed text, DID, TVA, REL, IPMP",
	"da2a": "DMB AF audio with HE-AAC v2 audio, MOT slide show, DLS, JPG/PNG/MNG images",
	"da2b": "DMB AF extending da2a, with 3GPP timed text, DID, TVA, REL, IPMP",
	"da3a": "DMB AF audio with HE-AAC, JPG/PNG/MNG images",
	"da3b": "DMB AF extending da3a with BIFS, 3GPP timed text, DID, TVA, REL, IPMP",
	"dash": "ISO base media file format file specifically designed for DASH including movie fragments and Segment Index",
	"dby1": "MP4 files with Dolby content (e.g. Dolby AC-4, Dolby Digital Plus, Dolby TrueHD (Dolby MLP))",
	"dmb1": "DMB AF supporting all the components defined in the specification",
	"dmpf": "Digital Media Project",
	"drc1": "Dirac (wavelet compression), encapsulated in ISO base media (MP4)",
	"dsms": "Media Segment conforming to the DASH Self-Initializing Media Segment format type for ISO base media file format",
	"dts1": "MP4 track file with audio codecs dtsc dtsh or dtse",
	"dts2": "MP4 track file with audio codec dtsx",
	"dts3": "MP4 track file with audio codec dtsy",
	"dv1a": "DMB AF video with AVC video, ER-BSAC audio, BIFS, JPG/PNG/MNG images, TS",
	"dv1b": "DMB AF, extending dv1a, with 3GPP timed text, DID, TVA, REL, IPMP",
	"dv2a": "DMB AF video with AVC video, HE-AACv2 audio, BIFS, JPG/PNG/MNG images, TS",
	"dv2b": "DMB AF extending dv2a, with 3GPP timed text, DID, TVA, REL, IPMP",
	"dv3a": "DMB AF video with AVC video, HE-AAC audio, BIFS, JPG/PNG/MNG images, TS",
	"dv3b": "DMB AF extending dv3a with 3GPP timed text, DID, TVA, REL, IPMP",
	"dvr1": "DVB RTP",
	"dvt1": "DVB Transport Stream",
	"dxo":  "DxO ONE camera",
	"emsg": "Event message box present",
	"F4A":  "Audio for Adobe Flash Player 9+ (.F4A)",
	"F4B":  "Audio Book for Adobe Flash Player 9+ (.F4B)",
	"F4P":  "Protected Video for Adobe Flash Player 9+ (.F4P)",
	"F4V":  "Video for Adobe Flash Player 9+ (.F4V)",
	"heic": "High Efficiency Image Format HEVC still image (.HEIC)",
	"heix": "High Efficiency Image Format still image (.HEIF)",
	"hevc": "High Efficiency Image Format HEVC sequence (.HEICS)",
	"ifrm": "Apple iFrame Specification, Version 8.1 Jan 2013",
	"im1i": "CMAF Media Profile - IMSC1 Image",
	"im1t": "CMAF Media Profile - IMSC1 Text",
	"isc2": "Files encrypted according to ISMACryp 2.0",
	"iso2": "All files based on the 2004 edition of the ISO file format",
	"iso3": "Version of the ISO file format",
	"iso4": "Version of the ISO file format",
	"iso5": "Version of the ISO file format",
	"iso6": "Version of the ISO file format",
	"iso7": "MP4 Base Media v7",
	"iso8": "MP4 Base Media v8",
	"iso9": "MP4 Base Media v9",
	"isom": "All files based on the ISO Base Media File Format",
	"J2P0": "JPEG2000 Profile 0",
	"J2P1": "JPEG2000 Profile 1",
	"JP2":  "JPEG 2000 Image (.JP2) [ISO 15444-1 ?]",
	"jp2":  "JPEG2000 Part 1",
	"JP20": "Unknown, from GPAC samples (prob non-existent)",
	"jpm":  "JPEG 2000 Part 6 Compound Images",
	"jpsi": "The JPSearch data interchange format, for the exchange of image collections and respective metadata",
	"jpx":  "JPEG2000 Part 2",
	"jpxb": "JPEG XR",
	"KDDI": "3GPP2 EZmovie for KDDI 3G cellphones",
	"LCAG": "Leica digital camera",
	"lmsg": "last Media Segment indicator for ISO base media file format",
	"M4A":  "iTunes MPEG-4 audio protected or not",
	"M4B":  "iTunes AudioBook protected or not",
	"M4P":  "MPEG-4 protected audio",
	"M4V":  "MPEG-4 protected audio+video",
	"M4VH": "Apple TV (.M4V)",
	"M4VP": "Apple iPhone (.M4V)",
	"MFSM": "Media File for Samsung video Metadata",
	"MGSV": "Home and Mobile Multimedia Platform (HMMP)",
	"mif1": "High Efficiency Image Format still image (.HEIF)",
	"mj2s": "Motion JPEG 2000 simple profile",
	"mjp2": "Motion JPEG 2000, general profile",
	"mmp4": "MPEG-4/3GPP Mobile Profile (.MP4/3GP) (for NTT)",
	"mp21": "MPEG-21",
	"mp41": "MP4 version 1",
	"mp42": "MP4 version 2",
	"mp71": "MPEG-7 file-level metadata",
	"MPPI": "Photo Player Multimedia Application Format",
	"mpuf": "Compliance with the MMT Processing Unit format",
	"mqt":  "Sony / Mobile QuickTime (.MQV) US Patent 7,477,830 (Sony Corp)",
	"msdh": "Media Segment conforming to the general format type for ISO base media file format",
	"msf1": "High Efficiency Image Format sequence (.HEIFS)",
	"msix": "Media Segment conforming to the Indexed Media Segment format type for ISO base media file format",
	"MSNV": "Portable multimedia CE products using MP4 file format with AVC video codec and AAC audio codec",
	"NDAS": "MP4 v2 [ISO 14496-14] Nero Digital AAC Audio",
	"NDSC": "MPEG-4 (.MP4) Nero Cinema Profile",
	"NDSH": "MPEG-4 (.MP4) Nero HDTV Profile",
	"NDSM": "MPEG-4 (.MP4) Nero Mobile Profile",
	"NDSP": "MPEG-4 (.MP4) Nero Portable Profile",
	"NDSS": "MPEG-4 (.MP4) Nero Standard Profile",
	"NDXC": "H.264/MPEG-4 AVC (.MP4) Nero Cinema Profile",
	"NDXH": "H.264/MPEG-4 AVC (.MP4) Nero HDTV Profile",
	"NDXM": "H.264/MPEG-4 AVC (.MP4) Nero Mobile Profile",
	"NDXP": "H.264/MPEG-4 AVC (.MP4) Nero Portable Profile",
	"NDXS": "H.264/MPEG-4 AVC (.MP4) Nero Standard Profile",
	"niko": "Nikon Digital Camera",
	"odcf": "OMA DCF (DRM Content Format)",
	"opf2": "OMA PDCF (DRM Content Format)",
	"opx2": "OMA Adapted PDCF",
	"pana": "Panasonic Digital Camera",
	"piff": "Protected Interoperable File Format",
	"pnvi": "Panasonic Video Intercom Video Intercom",
	"qt":   "QuickTime",
	"risx": "Representation Index Segment used to index MPEG-2 TS based Media Segments",
	"ROSS": "Ross Video	Ross",
	"sdv":  "SD Video",
	"SEAU": "Home and Mobile Multimedia Platform (HMMP)",
	"SEBK": "Home and Mobile Multimedia Platform (HMMP)",
	"senv": "Video contents Sony Entertainment Network provides by using MP4 file format",
	"sims": "Media Segment conforming to the Sub-Indexed Media Segment format type for ISO base media file format",
	"sisx": "Single Index Segment used to index MPEG-2 TS based Media Segments",
	"ssc1": "Samsung stereoscopic, single stream",
	"ssc2": "Samsung stereoscopic, dual stream",
	"ssss": "Subsegment Index Segment used to index MPEG-2 TS based Media Segments",
	"uvvu": "UltraViolet file brand – conforming to the DECE Common File Format spec, Annex E",
	"XAVC": "XAVC File Format",
}
