/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.MimeEnabledImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class ImageConverterPDF2AFP
extends AbstractImageConverter {
    public Image convert(Image src, Map hints) throws IOException {
        if (!(src instanceof ImagePDF)) {
            return null;
        }
        ImagePDF imgPDF = (ImagePDF)src;
        int selectedPage = ImageUtil.needPageIndexFromURI((String)src.getInfo().getOriginalURI());
        PDDocument pdDocument = imgPDF.getPDDocument();
        Splitter splitter = new Splitter();
        splitter.setStartPage(selectedPage + 1);
        splitter.setEndPage(selectedPage + 1);
        pdDocument = (PDDocument)splitter.split(pdDocument).get(0);
        ByteArrayOutputStream pdf = new ByteArrayOutputStream();
        pdDocument.save((OutputStream)pdf);
        pdDocument.close();
        MimeEnabledImageFlavor imageFlavor = new MimeEnabledImageFlavor(src.getFlavor(), "application/pdf");
        return new ImageRawStream(src.getInfo(), (ImageFlavor)imageFlavor, (InputStream)new ByteArrayInputStream(pdf.toByteArray()));
    }

    public ImageFlavor getSourceFlavor() {
        return ImagePDF.PDFBOX_IMAGE;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_PDF;
    }

    public int getConversionPenalty() {
        return 100;
    }
}

