package afs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCaptchaMin invokes the afs.DescribeCaptchaMin API synchronously
// api document: https://help.aliyun.com/api/afs/describecaptchamin.html
func (client *Client) DescribeCaptchaMin(request *DescribeCaptchaMinRequest) (response *DescribeCaptchaMinResponse, err error) {
	response = CreateDescribeCaptchaMinResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCaptchaMinWithChan invokes the afs.DescribeCaptchaMin API asynchronously
// api document: https://help.aliyun.com/api/afs/describecaptchamin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCaptchaMinWithChan(request *DescribeCaptchaMinRequest) (<-chan *DescribeCaptchaMinResponse, <-chan error) {
	responseChan := make(chan *DescribeCaptchaMinResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCaptchaMin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCaptchaMinWithCallback invokes the afs.DescribeCaptchaMin API asynchronously
// api document: https://help.aliyun.com/api/afs/describecaptchamin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCaptchaMinWithCallback(request *DescribeCaptchaMinRequest, callback func(response *DescribeCaptchaMinResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCaptchaMinResponse
		var err error
		defer close(result)
		response, err = client.DescribeCaptchaMin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCaptchaMinRequest is the request struct for api DescribeCaptchaMin
type DescribeCaptchaMinRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	ConfigName string `position:"Query" name:"ConfigName"`
	RefExtId   string `position:"Query" name:"RefExtId"`
	Time       string `position:"Query" name:"Time"`
	Type       string `position:"Query" name:"Type"`
}

// DescribeCaptchaMinResponse is the response struct for api DescribeCaptchaMin
type DescribeCaptchaMinResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	BizCode     string       `json:"BizCode" xml:"BizCode"`
	HasData     bool         `json:"HasData" xml:"HasData"`
	CaptchaMins []CaptchaMin `json:"CaptchaMins" xml:"CaptchaMins"`
}

// CreateDescribeCaptchaMinRequest creates a request to invoke DescribeCaptchaMin API
func CreateDescribeCaptchaMinRequest() (request *DescribeCaptchaMinRequest) {
	request = &DescribeCaptchaMinRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("afs", "2018-01-12", "DescribeCaptchaMin", "afs", "openAPI")
	return
}

// CreateDescribeCaptchaMinResponse creates a response to parse from DescribeCaptchaMin response
func CreateDescribeCaptchaMinResponse() (response *DescribeCaptchaMinResponse) {
	response = &DescribeCaptchaMinResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
