package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDomainBlackWhiteList invokes the ddospro.ModifyDomainBlackWhiteList API synchronously
// api document: https://help.aliyun.com/api/ddospro/modifydomainblackwhitelist.html
func (client *Client) ModifyDomainBlackWhiteList(request *ModifyDomainBlackWhiteListRequest) (response *ModifyDomainBlackWhiteListResponse, err error) {
	response = CreateModifyDomainBlackWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDomainBlackWhiteListWithChan invokes the ddospro.ModifyDomainBlackWhiteList API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifydomainblackwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDomainBlackWhiteListWithChan(request *ModifyDomainBlackWhiteListRequest) (<-chan *ModifyDomainBlackWhiteListResponse, <-chan error) {
	responseChan := make(chan *ModifyDomainBlackWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDomainBlackWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDomainBlackWhiteListWithCallback invokes the ddospro.ModifyDomainBlackWhiteList API asynchronously
// api document: https://help.aliyun.com/api/ddospro/modifydomainblackwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDomainBlackWhiteListWithCallback(request *ModifyDomainBlackWhiteListRequest, callback func(response *ModifyDomainBlackWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDomainBlackWhiteListResponse
		var err error
		defer close(result)
		response, err = client.ModifyDomainBlackWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDomainBlackWhiteListRequest is the request struct for api ModifyDomainBlackWhiteList
type ModifyDomainBlackWhiteListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Domain          string           `position:"Query" name:"Domain"`
	Black           *[]string        `position:"Query" name:"Black"  type:"Repeated"`
	White           *[]string        `position:"Query" name:"White"  type:"Repeated"`
}

// ModifyDomainBlackWhiteListResponse is the response struct for api ModifyDomainBlackWhiteList
type ModifyDomainBlackWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDomainBlackWhiteListRequest creates a request to invoke ModifyDomainBlackWhiteList API
func CreateModifyDomainBlackWhiteListRequest() (request *ModifyDomainBlackWhiteListRequest) {
	request = &ModifyDomainBlackWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "ModifyDomainBlackWhiteList", "", "")
	return
}

// CreateModifyDomainBlackWhiteListResponse creates a response to parse from ModifyDomainBlackWhiteList response
func CreateModifyDomainBlackWhiteListResponse() (response *ModifyDomainBlackWhiteListResponse) {
	response = &ModifyDomainBlackWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
