package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEndpointGroup invokes the ga.UpdateEndpointGroup API synchronously
func (client *Client) UpdateEndpointGroup(request *UpdateEndpointGroupRequest) (response *UpdateEndpointGroupResponse, err error) {
	response = CreateUpdateEndpointGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEndpointGroupWithChan invokes the ga.UpdateEndpointGroup API asynchronously
func (client *Client) UpdateEndpointGroupWithChan(request *UpdateEndpointGroupRequest) (<-chan *UpdateEndpointGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateEndpointGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEndpointGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEndpointGroupWithCallback invokes the ga.UpdateEndpointGroup API asynchronously
func (client *Client) UpdateEndpointGroupWithCallback(request *UpdateEndpointGroupRequest, callback func(response *UpdateEndpointGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEndpointGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateEndpointGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEndpointGroupRequest is the request struct for api UpdateEndpointGroup
type UpdateEndpointGroupRequest struct {
	*requests.RpcRequest
	PortOverrides              *[]UpdateEndpointGroupPortOverrides          `position:"Query" name:"PortOverrides"  type:"Repeated"`
	ClientToken                string                                       `position:"Query" name:"ClientToken"`
	HealthCheckIntervalSeconds requests.Integer                             `position:"Query" name:"HealthCheckIntervalSeconds"`
	Description                string                                       `position:"Query" name:"Description"`
	HealthCheckProtocol        string                                       `position:"Query" name:"HealthCheckProtocol"`
	EndpointRequestProtocol    string                                       `position:"Query" name:"EndpointRequestProtocol"`
	HealthCheckPath            string                                       `position:"Query" name:"HealthCheckPath"`
	EndpointConfigurations     *[]UpdateEndpointGroupEndpointConfigurations `position:"Query" name:"EndpointConfigurations"  type:"Repeated"`
	EndpointGroupId            string                                       `position:"Query" name:"EndpointGroupId"`
	TrafficPercentage          requests.Integer                             `position:"Query" name:"TrafficPercentage"`
	HealthCheckPort            requests.Integer                             `position:"Query" name:"HealthCheckPort"`
	ThresholdCount             requests.Integer                             `position:"Query" name:"ThresholdCount"`
	EndpointGroupRegion        string                                       `position:"Query" name:"EndpointGroupRegion"`
	Name                       string                                       `position:"Query" name:"Name"`
}

// UpdateEndpointGroupPortOverrides is a repeated param struct in UpdateEndpointGroupRequest
type UpdateEndpointGroupPortOverrides struct {
	ListenerPort string `name:"ListenerPort"`
	EndpointPort string `name:"EndpointPort"`
}

// UpdateEndpointGroupEndpointConfigurations is a repeated param struct in UpdateEndpointGroupRequest
type UpdateEndpointGroupEndpointConfigurations struct {
	Type                       string `name:"Type"`
	EnableClientIPPreservation string `name:"EnableClientIPPreservation"`
	Weight                     string `name:"Weight"`
	EnableProxyProtocol        string `name:"EnableProxyProtocol"`
	Endpoint                   string `name:"Endpoint"`
}

// UpdateEndpointGroupResponse is the response struct for api UpdateEndpointGroup
type UpdateEndpointGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateEndpointGroupRequest creates a request to invoke UpdateEndpointGroup API
func CreateUpdateEndpointGroupRequest() (request *UpdateEndpointGroupRequest) {
	request = &UpdateEndpointGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "UpdateEndpointGroup", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEndpointGroupResponse creates a response to parse from UpdateEndpointGroup response
func CreateUpdateEndpointGroupResponse() (response *UpdateEndpointGroupResponse) {
	response = &UpdateEndpointGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
