package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeQoses invokes the smartag.DescribeQoses API synchronously
func (client *Client) DescribeQoses(request *DescribeQosesRequest) (response *DescribeQosesResponse, err error) {
	response = CreateDescribeQosesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeQosesWithChan invokes the smartag.DescribeQoses API asynchronously
func (client *Client) DescribeQosesWithChan(request *DescribeQosesRequest) (<-chan *DescribeQosesResponse, <-chan error) {
	responseChan := make(chan *DescribeQosesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeQoses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeQosesWithCallback invokes the smartag.DescribeQoses API asynchronously
func (client *Client) DescribeQosesWithCallback(request *DescribeQosesRequest, callback func(response *DescribeQosesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeQosesResponse
		var err error
		defer close(result)
		response, err = client.DescribeQoses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeQosesRequest is the request struct for api DescribeQoses
type DescribeQosesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	QosIds               string           `position:"Query" name:"QosIds"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	QosName              string           `position:"Query" name:"QosName"`
}

// DescribeQosesResponse is the response struct for api DescribeQoses
type DescribeQosesResponse struct {
	*responses.BaseResponse
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	Qoses      Qoses  `json:"Qoses" xml:"Qoses"`
}

// CreateDescribeQosesRequest creates a request to invoke DescribeQoses API
func CreateDescribeQosesRequest() (request *DescribeQosesRequest) {
	request = &DescribeQosesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeQoses", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeQosesResponse creates a response to parse from DescribeQoses response
func CreateDescribeQosesResponse() (response *DescribeQosesResponse) {
	response = &DescribeQosesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
