/***************************************************************************
                          cauldron.c  -  For interface
                             -------------------
    begin                : Wed Jul 25 2001
    copyright            : (C) 2001 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "wand.h"


void gtkdestroy(GtkWidget *widg, GtkWidget *windo)
{ gtk_widget_destroy(windo); }

void prterr(char *message)
{
  GtkWidget *windo, *errlbl, *okbutt = NULL, *fixe;

  windo = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(windo, 250, 150);
  gtk_window_set_title(GTK_WINDOW(windo), "An Error Has Occured");
  gtk_window_set_position(GTK_WINDOW(windo), GTK_WIN_POS_CENTER);
  /* use fixed positioning so I can place stuff wherever */
  fixe = gtk_fixed_new();
  gtk_container_add(GTK_CONTAINER(windo), fixe);
  gtk_widget_show(fixe);
  /* Our button to send packets*/
  okbutt = make_button(fixe,
                       okbutt,
                       "  OK  ",
                       70, 25,
                       100, 100,
                       1
                      );
   gtk_signal_connect(GTK_OBJECT(okbutt),
                     "pressed",
                     GTK_SIGNAL_FUNC(gtkdestroy),
                     windo
                    );

  errlbl = gtk_label_new(message);
  /* position label */
  gtk_fixed_put(GTK_FIXED(fixe), errlbl, 10, 20);
  gtk_widget_show(errlbl);
  gtk_widget_show(windo);



}


int main(int argc, char **argv)
{


  GtkWidget *window, *tab1_lbl = NULL;
  GtkWidget *send_pack = NULL, *def_fields = NULL;
  GtkWidget *menu_bar = NULL;
  GtkItemFactory *item_cauldron = NULL;
  GtkAccelGroup *ag = NULL;
  static GtkItemFactoryEntry menu[] =
  {
    { "/_Menu",            "<control>M", NULL, 0, "<Branch>" },
    { "/Menu/_Open Sniffer" , "<control>O", NULL, 0, NULL },
    { "/Menu/_Save",       "<control>S", NULL, 0, NULL },
    { "/Menu/Save _As",    "<control>A", NULL, 0, NULL },
    { "/Menu/_Exit",       "<control>E", gtk_main_quit, 0, NULL },
  };
  gint mitems = (sizeof(menu) / sizeof(menu[0]));


  gtk_init(&argc, &argv);

  tab = fixed_pos = snoop_check = NULL;

  /* intialize window */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(window, 600, 500);
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  /* connect the destroy signal to close the window */
  gtk_signal_connect(GTK_OBJECT(window),
                     "destroy",
                     GTK_SIGNAL_FUNC(gtk_main_quit),
                     NULL
                    );

  /* set window title */
  gtk_window_set_title(GTK_WINDOW(window), "                 IP Sorcery");

  /* gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, TRUE);  */
  tab = gtk_notebook_new();
  gtk_container_add(GTK_CONTAINER(window), tab);


  /* use fixed positioning so I can place stuff wherever */
  fixed_pos = gtk_fixed_new();
  gtk_widget_show(fixed_pos);
  tab1_lbl = gtk_label_new(" IP ");

  gtk_notebook_append_page(GTK_NOTEBOOK(tab),
                           fixed_pos,
                           tab1_lbl);


  gtk_widget_show(tab1_lbl);
  gtk_widget_show(tab);


/* create accelerator group for Menu shortcuts */
  ag = gtk_accel_group_new();
  /* use item factory to help us make our menu */
  item_cauldron = gtk_item_factory_new(GTK_TYPE_MENU_BAR,
                                       "<main>",
                                       ag
                                      );
  gtk_item_factory_create_items(item_cauldron, mitems, menu, NULL);
  /* add accelerator */
  gtk_window_add_accel_group(GTK_WINDOW(window), ag);
  /* make a menu bar */
  menu_bar = gtk_item_factory_get_widget(item_cauldron, "<main>");
  gtk_fixed_put(GTK_FIXED(fixed_pos), menu_bar, 0, 0);
 /* Not show yet we still have too much to do! */
 /* gtk_widget_show(menu_bar); */


  snoop_check = make_button(fixed_pos,
                            snoop_check,
                            "Turn on Snoop",
                            0, 0,
                            250, 410,
                            0
                           );         


  /* Our button to send packets*/
  send_pack = make_button(fixed_pos,
                          send_pack,
                         "Send Packet",
                          90, 30,
                          40, 410,
                          1
                         );

  /* if we click on button send the packet*/
  gtk_signal_connect(GTK_OBJECT(send_pack),
                     "pressed",
                     GTK_SIGNAL_FUNC(send_packet),
                     NULL
                    );

  /* Our button to set defaults*/
  def_fields = make_button(fixed_pos,
                           def_fields,
                           "Default Values",
                           90, 30,
                           480, 410,
                           1
                          );

  /* if we click on button to set the defaults*/
  gtk_signal_connect(GTK_OBJECT(def_fields),
                     "clicked",
                     GTK_SIGNAL_FUNC(ip_defaults),
                     NULL
                    );

  if(getuid()) { prterr("Only root can use this program."); exit(-1); }
  ip_cauldron();


  gtk_widget_show(window);
  gtk_main();
  return 0;
}


