# Contributing to ChemEx

We welcome contributions to the ChemEx project! Whether you're interested in fixing bugs, adding new features, or improving documentation, your help is appreciated. This document provides guidelines for contributing to ChemEx.

## Getting Started

1. **Fork the Repository**: Start by forking the ChemEx repository on GitHub.
2. **Clone Your Fork**: Clone the fork to your local machine.
3. **Set Up Your Environment**: Make sure you have Python and other necessary tools installed.
4. **Create a Branch**: Create a new branch for your work.

## Making Contributions

### Reporting Bugs

-   **Use the GitHub Issue Tracker**: Report bugs by creating a new issue.
-   **Describe the Bug**: Include detailed information about the bug and steps to reproduce it.
-   **Screenshots and Logs**: If applicable, add screenshots and log files to help explain your problem.

### Suggesting Enhancements

-   **Use the GitHub Issue Tracker**: Suggest enhancements by opening a new issue.
-   **Provide a Clear Description**: Explain why this enhancement would be useful, and propose a possible implementation if you can.

### Pull Requests

-   **Small and Focused**: Keep your pull requests small and focused on a single issue or feature.
-   **Code Standards**: Follow the coding style of the project (PEP 8 for Python, for example).
-   **Documentation**: Update the documentation accordingly.
-   **Testing**: Add tests for new features or bug fixes.
-   **Describe Your Changes**: In your pull request, clearly describe what you have done.

## Code Review Process

1. **Review by Maintainers**: The project maintainers will review your pull request.
2. **Feedback**: Be open to feedback and make necessary changes.
3. **Approval and Merge**: Once approved, your changes will be merged into the main branch.

## Community Guidelines

-   **Be Respectful**: Treat others as you would like to be treated.
-   **Collaboration Over Competition**: We are all working towards the same goal.

## Questions?

If you have any questions, please don't hesitate to open a discussion in the GitHub repository.

Thank you for considering contributing to ChemEx. Your efforts help make ChemEx a better tool for everyone!
