/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextContentImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface TextContent
extends CharSequence,
UserDataHolderEx {
    public TextDomain getDomain();

    @Override
    public String toString();

    public int textOffsetToFile(int var1);

    public int textOffsetToFile(int var1, boolean var2);

    @Nullable
    public Integer fileOffsetToText(int var1);

    @Nullable
    public TextRange fileRangeToText(TextRange var1);

    @NotNull
    default public TextRange textRangeToFile(TextRange textRange) {
        return new TextRange(this.textOffsetToFile(textRange.getStartOffset()), this.textOffsetToFile(textRange.getEndOffset()));
    }

    @NotNull
    public PsiElement getCommonParent();

    @NotNull
    public PsiFile getContainingFile();

    @NotNull
    public PsiElement findPsiElementAt(int var1);

    @NotNull
    public List<TextRange> getRangesInFile();

    public boolean hasUnknownFragmentsIn(TextRange var1);

    @Contract(pure=true)
    public TextContent excludeRange(TextRange var1);

    @Contract(pure=true)
    public TextContent markUnknown(TextRange var1);

    @Contract(pure=true)
    public TextContent excludeRanges(List<Exclusion> var1);

    @Nullable
    default public TextContent subText(TextRange range) {
        if (range.isEmpty()) {
            return null;
        }
        return this.excludeRange(new TextRange(range.getEndOffset(), this.length())).excludeRange(new TextRange(0, range.getStartOffset()));
    }

    @Contract(pure=true)
    public boolean intersectsRange(TextRange var1);

    @Contract(pure=true)
    default public List<TextRange> intersection(TextRange rangeInFile) {
        return ContainerUtil.mapNotNull(this.getRangesInFile(), r -> r.intersection(rangeInFile));
    }

    @Contract(pure=true)
    @Nullable
    public TextContent trimWhitespace();

    @Contract(pure=true)
    public TextContent removeIndents(Set<Character> var1);

    @Contract(pure=true)
    public TextContent removeLineSuffixes(Set<Character> var1);

    public int[] markupOffsets();

    public WithMarkup replaceMarkupWith(char var1);

    public static TextContent psiFragment(TextDomain domain, PsiElement psi, TextRange rangeInPsi) {
        return new TextContentImpl(domain, Collections.singletonList(new TextContentImpl.PsiToken(rangeInPsi.substring(psi.getText()), psi, rangeInPsi, TextContentImpl.TokenKind.text)));
    }

    public static TextContent psiFragment(TextDomain domain, PsiElement psi) {
        return TextContent.psiFragment(domain, psi, TextRange.from((int)0, (int)psi.getTextLength()));
    }

    public static TextContentBuilder builder() {
        return TextContentBuilder.FromPsi;
    }

    @Nullable
    public static TextContent join(List<? extends @NotNull TextContent> components) {
        if (components.isEmpty()) {
            return null;
        }
        if (components.size() == 1) {
            return components.get(0);
        }
        return new TextContentImpl(TextContent.commonDomain(components), ContainerUtil.flatMap(components, c -> ((TextContentImpl)c).tokens));
    }

    @Nullable
    public static TextContent joinWithWhitespace(char whitespace, List<? extends @NotNull TextContent> components) {
        if (!Character.isWhitespace(whitespace) && Character.getType(whitespace) != 12) {
            throw new IllegalArgumentException("Whitespace expected, got " + StringUtil.escapeStringCharacters((String)String.valueOf(whitespace)));
        }
        if (components.isEmpty()) {
            return null;
        }
        if (components.size() == 1) {
            return components.get(0);
        }
        TextContentImpl.WSTokenInfo wsToken = new TextContentImpl.WSTokenInfo(whitespace);
        return new TextContentImpl(TextContent.commonDomain(components), ((StreamEx)StreamEx.of(components).map(c -> ((TextContentImpl)c).tokens).intersperse(Collections.singletonList(wsToken))).toFlatList(Function.identity()));
    }

    private static TextDomain commonDomain(List<? extends TextContent> components) {
        TextDomain domain = components.get(0).getDomain();
        if (components.stream().anyMatch(c -> c.getDomain() != domain)) {
            throw new IllegalArgumentException("Joined TextContents should share the same domain");
        }
        return domain;
    }

    public static enum TextDomain {
        LITERALS,
        COMMENTS,
        DOCUMENTATION,
        PLAIN_TEXT;

        public static final Set<TextDomain> ALL;

        static {
            ALL = Collections.unmodifiableSet(EnumSet.allOf(TextDomain.class));
        }
    }

    public static interface WithMarkup
    extends CharSequence {
        public int offsetToOriginal(int var1);
    }

    public static class Exclusion {
        public final int start;
        public final int end;
        public final ExclusionKind kind;

        public Exclusion(int start, int end, ExclusionKind kind) {
            if (start > end) {
                throw new IllegalArgumentException(start + ">" + end);
            }
            this.start = start;
            this.end = end;
            this.kind = kind;
        }

        public Exclusion(int start, int end, boolean markUnknown) {
            this(start, end, markUnknown ? ExclusionKind.unknown : ExclusionKind.exclude);
        }

        public String toString() {
            return "(" + (this.kind == ExclusionKind.markup ? "*" : (this.kind == ExclusionKind.unknown ? "?" : "")) + this.start + "," + this.end + ")";
        }

        public static Exclusion markUnknown(TextRange range) {
            return new Exclusion(range.getStartOffset(), range.getEndOffset(), true);
        }

        public static Exclusion exclude(TextRange range) {
            return new Exclusion(range.getStartOffset(), range.getEndOffset(), false);
        }
    }

    public static enum ExclusionKind {
        exclude,
        markup,
        unknown;

    }
}

