/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.SubstitutedExpressionEvaluationHelper;
import org.jetbrains.annotations.NotNull;

public final class ContextComputationProcessor {
    private final SubstitutedExpressionEvaluationHelper myEvaluationHelper;

    private ContextComputationProcessor(Project project) {
        this.myEvaluationHelper = new SubstitutedExpressionEvaluationHelper(project);
    }

    @NotNull
    public static List<Object> collectOperands(@NotNull String prefix, String suffix, Ref<? super Boolean> unparsable, PsiElement[] operands) {
        if (prefix == null) {
            ContextComputationProcessor.$$$reportNull$$$0(0);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ContextComputationProcessor processor = new ContextComputationProcessor(operands[0].getProject());
        ContextComputationProcessor.addStringFragment(prefix, result);
        PsiElement topParent = Objects.requireNonNull(PsiTreeUtil.findCommonParent((PsiElement[])operands));
        processor.collectOperands(ContextComputationProcessor.getTopLevelInjectionTarget(topParent), result, unparsable);
        ContextComputationProcessor.addStringFragment(suffix, result);
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            ContextComputationProcessor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void addStringFragment(String string, List<Object> result) {
        Object last;
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        int size = result.size();
        Object object = last = size > 0 ? result.get(size - 1) : null;
        if (last instanceof String) {
            result.set(size - 1, last + string);
        } else {
            result.add(string);
        }
    }

    public void collectOperands(PsiElement expression, List<Object> result, Ref<? super Boolean> unparsable) {
        PsiAssignmentExpression assignmentExpression;
        PsiPolyadicExpression binaryExpression;
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)expression;
            this.collectOperands((PsiElement)parenthesized.getExpression(), result, unparsable);
        } else if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)expression;
            this.collectOperands((PsiElement)cast.getOperand(), result, unparsable);
        } else if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            unparsable.set((Object)Boolean.TRUE);
            this.collectOperands((PsiElement)conditional.getThenExpression(), result, unparsable);
            ContextComputationProcessor.addStringFragment(" ", result);
            this.collectOperands((PsiElement)conditional.getElseExpression(), result, unparsable);
        } else if (expression instanceof PsiPolyadicExpression && (binaryExpression = (PsiPolyadicExpression)expression).getOperationTokenType() == JavaTokenType.PLUS) {
            for (PsiExpression operand : binaryExpression.getOperands()) {
                this.collectOperands((PsiElement)operand, result, unparsable);
            }
        } else if (expression instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)expression).getOperationTokenType() == JavaTokenType.PLUSEQ) {
            unparsable.set((Object)Boolean.TRUE);
            this.collectOperands((PsiElement)assignmentExpression.getLExpression(), result, unparsable);
            this.collectOperands((PsiElement)assignmentExpression.getRExpression(), result, unparsable);
        } else if (expression instanceof PsiTemplate) {
            PsiTemplate template = (PsiTemplate)expression;
            for (PsiElement child : template.getChildren()) {
                this.collectOperands(child, result, unparsable);
            }
        } else if (PsiUtilEx.isStringOrCharacterLiteral(expression) || expression instanceof PsiFragment) {
            result.add(expression);
        } else if (expression instanceof PsiExpression) {
            SmartList uncomputables = new SmartList();
            Object o = this.myEvaluationHelper.computeExpression((PsiExpression)expression, (List<? super PsiExpression>)uncomputables);
            ContextComputationProcessor.addStringFragment(o == null ? "missingValue" : String.valueOf(o), result);
            if (!uncomputables.isEmpty()) {
                unparsable.set((Object)Boolean.TRUE);
            }
        } else {
            unparsable.set((Object)Boolean.TRUE);
            result.add(expression);
        }
    }

    @NotNull
    public static PsiElement getTopLevelInjectionTarget(@NotNull PsiElement host) {
        if (host == null) {
            ContextComputationProcessor.$$$reportNull$$$0(2);
        }
        PsiElement target = host;
        PsiElement parent = target.getParent();
        while (parent != null && (parent instanceof PsiTemplate || parent instanceof PsiPolyadicExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != target)) {
            target = parent;
            parent = target.getParent();
        }
        PsiElement psiElement = target;
        if (psiElement == null) {
            ContextComputationProcessor.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/util/ContextComputationProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/util/ContextComputationProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOperands";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelInjectionTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectOperands";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelInjectionTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

