/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.platform.hash.ArchiveData;
import com.intellij.indexing.shared.platform.hash.ArchiveDataCache;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexCrcArchiveHash;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.IntegrityCheckCapableFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexCrcArchiveHashProvider;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "<init>", "()V", "info", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "getInfo", "()Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "computeHash", "", "content", "Lcom/intellij/util/indexing/IndexedFile;", "getArchiveFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "archiveEntry", "fs", "Lcom/intellij/openapi/vfs/newvfs/ArchiveFileSystem;", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexCrcArchiveHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexCrcArchiveHash.kt\ncom/intellij/indexing/shared/platform/hash/SharedIndexCrcArchiveHashProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,96:1\n40#2,3:97\n*S KotlinDebug\n*F\n+ 1 SharedIndexCrcArchiveHash.kt\ncom/intellij/indexing/shared/platform/hash/SharedIndexCrcArchiveHashProvider\n*L\n42#1:97,3\n*E\n"})
public final class SharedIndexCrcArchiveHashProvider
implements SharedIndexContentHashProvider {
    @Override
    @NotNull
    public SharedIndexContentHash getInfo() {
        return SharedIndexCrcArchiveHash.INSTANCE;
    }

    @Override
    @Nullable
    public byte[] computeHash(@NotNull IndexedFile content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        VirtualFileSystem virtualFileSystem = file.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem fs = virtualFileSystem;
        if (!(fs instanceof ArchiveFileSystem) || !(fs instanceof IntegrityCheckCapableFileSystem)) {
            return null;
        }
        VirtualFile virtualFile2 = this.getArchiveFile(file, (ArchiveFileSystem)fs);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile archiveFile = virtualFile2;
        long crc = 0L;
        ArchiveData archiveData = null;
        try {
            boolean $i$f$service = false;
            Class<ArchiveDataCache> serviceClass$iv = ArchiveDataCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ArchiveData archiveData2 = (ArchiveData)((ArchiveDataCache)object).getOrComputeValue(archiveFile);
            if (archiveData2 == null) {
                return null;
            }
            archiveData = archiveData2;
            if (ZipHandlerBase.getUseCrcInsteadOfTimestampPropertyValue()) {
                crc = ((ArchiveFileSystem)fs).getTimeStamp(file);
            } else {
                Long l = (Long)((Map)archiveData.getCrcs().getValue()).get(VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)archiveFile));
                if (l == null) {
                    return null;
                }
                crc = l;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (crc == 0L) {
            return null;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        String string2 = archiveData.getName() + ":" + fileName + ":" + crc;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] message = byArray;
        return IndexedHashesSupport.calculateIndexedHash((IndexedFile)content, (byte[])message);
    }

    private final VirtualFile getArchiveFile(VirtualFile archiveEntry, ArchiveFileSystem fs) {
        VirtualFile virtualFile = fs.getRootByEntry(archiveEntry);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile localFile = virtualFile;
        if (!Intrinsics.areEqual((Object)localFile.getFileSystem(), (Object)fs)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return localFile;
    }
}

