/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentEnumerators;
import com.intellij.util.hash.ContentHashEnumerator;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterHashEnumerator;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "chunkRoot", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "hashEnumerator", "Lcom/intellij/util/hash/ContentHashEnumerator;", "kotlin.jvm.PlatformType", "Lcom/intellij/util/hash/ContentHashEnumerator;", "close", "", "enumerateHash", "", "hash", "Lcom/intellij/indexing/shared/generator/IndexedFileHash;", "intellij.indexing.shared.generator"})
public final class IndexesExporterHashEnumerator
implements AutoCloseable {
    private final ContentHashEnumerator hashEnumerator;

    public IndexesExporterHashEnumerator(@NotNull Path chunkRoot) {
        Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
        this.hashEnumerator = SharedIndexContentEnumerators.INSTANCE.newEnumeratorForGenerator(chunkRoot);
    }

    @Override
    public void close() throws Exception {
        this.hashEnumerator.close();
    }

    public final int enumerateHash(@NotNull IndexedFileHash hash) {
        int n;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        try {
            n = Math.abs(this.hashEnumerator.enumerate(hash.getHash()));
        }
        catch (Exception e) {
            throw new RuntimeException("Hash enumerator is corrupted", e);
        }
        return n;
    }
}

