/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.IndexedFilesHashingTaskParameters;
import com.intellij.indexing.shared.generator.IndexesExporterHasher;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashExporter;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashExporterContext;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "resolveGeneratorsForExporter", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "Lcom/intellij/indexing/shared/generator/IndexedFilesHashingTaskParameters;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporterHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporterHasher.kt\ncom/intellij/indexing/shared/generator/IndexesExporterHasherKt\n+ 2 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,97:1\n13#2,4:98\n13#2,8:102\n19#2,2:110\n14#3:112\n*S KotlinDebug\n*F\n+ 1 IndexesExporterHasher.kt\ncom/intellij/indexing/shared/generator/IndexesExporterHasherKt\n*L\n62#1:98,4\n81#1:102,8\n62#1:110,2\n18#1:112\n*E\n"})
public final class IndexesExporterHasherKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<SharedIndexContentHashProvider> resolveGeneratorsForExporter(@NotNull Project project, @NotNull IndexedFilesHashingTaskParameters parameters, @NotNull Set<? extends VirtualFile> allFiles, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(true);
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.resolving.hash.generators.for.export", (Object[])new Object[0]));
            SharedIndexContentHashExporterContext context2 = new SharedIndexContentHashExporterContext(project, allFiles){
                private final Project project;
                private final Set<VirtualFile> allFiles;
                {
                    this.project = $project;
                    this.allFiles = $allFiles;
                }

                public Project getProject() {
                    return this.project;
                }

                public Set<VirtualFile> getAllFiles() {
                    return this.allFiles;
                }
            };
            HashSet<String> usedNames = new HashSet<String>();
            List result = new ArrayList();
            for (SharedIndexContentHashExporter factory : SharedIndexHashProviders.getSharedIndexHashingGenerators()) {
                if (!parameters.isIncludedHashProvider(factory.getInfo())) {
                    LOG.info("Shared Index Hash: " + factory.getInfo().getProviderId() + " is not enabled in parameters");
                    continue;
                }
                String providerId = factory.getInfo().getProviderId();
                try {
                    SharedIndexContentHashProvider generator;
                    SharedIndexContentHashProvider sharedIndexContentHashProvider;
                    ProgressIndicator $this$withPushPop$iv2 = indicator;
                    boolean $i$f$withPushPop2 = false;
                    boolean wasIndeterminate$iv2 = $this$withPushPop$iv2.isIndeterminate();
                    $this$withPushPop$iv2.pushState();
                    try {
                        boolean bl2 = false;
                        sharedIndexContentHashProvider = factory.createHashProvider(context2, indicator);
                    }
                    finally {
                        $this$withPushPop$iv2.setIndeterminate(wasIndeterminate$iv2);
                        $this$withPushPop$iv2.popState();
                    }
                    if (sharedIndexContentHashProvider == null) continue;
                    if (!usedNames.add(providerId)) {
                        LOG.warn("An attempt to use SharedIndexContentHashExporter with non-unique name: " + providerId + ". It will ignore " + generator);
                        continue;
                    }
                    ((Collection)result).add(generator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    LOG.warn("Failed to create HashProvider from " + providerId + ". " + t.getMessage(), t);
                }
            }
            List list = CollectionsKt.toList((Iterable)result);
            return list;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexesExporterHasher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

