/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.execution.runConfiguration;

import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.jupyter.core.jupyter.execution.runConfiguration.AbstractJupyterServerRunConfigurationOptions;
import com.intellij.jupyter.core.jupyter.execution.runConfiguration.JupyterServerRunConfiguration;
import com.intellij.jupyter.core.jupyter.execution.runConfiguration.JupyterServerRunConfigurationExtensionsManager;
import com.intellij.jupyter.py.connections.execution.runConfiguration.PythonJupyterServerRunConfigurationOptions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.util.text.StringKt;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.run.TargetedPythonPaths;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.conda.CondaPathFixKt;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/py/connections/execution/runConfiguration/PythonJupyterServerRunConfigurationExtension;", "Lcom/intellij/jupyter/core/jupyter/execution/runConfiguration/JupyterServerRunConfigurationExtensionsManager$Extension;", "<init>", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/jupyter/core/jupyter/execution/runConfiguration/JupyterServerRunConfiguration;", "isEnabledFor", "applicableConfiguration", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "getSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createTargetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "prepareTargetEnvironmentRequest", "", "request", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "handleCreatedTargetEnvironment", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "patchCommandLine", "cmdLine", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "runnerId", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nPythonJupyterServerRunConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonJupyterServerRunConfigurationExtension.kt\ncom/intellij/jupyter/py/connections/execution/runConfiguration/PythonJupyterServerRunConfigurationExtension\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n126#2:233\n153#2,3:234\n216#2,2:241\n1557#3:237\n1628#3,3:238\n*S KotlinDebug\n*F\n+ 1 PythonJupyterServerRunConfigurationExtension.kt\ncom/intellij/jupyter/py/connections/execution/runConfiguration/PythonJupyterServerRunConfigurationExtension\n*L\n124#1:233\n124#1:234,3\n131#1:241,2\n124#1:237\n124#1:238,3\n*E\n"})
public final class PythonJupyterServerRunConfigurationExtension
extends JupyterServerRunConfigurationExtensionsManager.Extension {
    public boolean isApplicableFor(@NotNull JupyterServerRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return true;
    }

    public boolean isEnabledFor(@NotNull JupyterServerRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter((Object)applicableConfiguration, (String)"applicableConfiguration");
        return true;
    }

    private final Sdk getSdk(JupyterServerRunConfiguration configuration) {
        Module module;
        AbstractJupyterServerRunConfigurationOptions abstractJupyterServerRunConfigurationOptions = configuration.getJupyterOptions();
        Intrinsics.checkNotNull((Object)abstractJupyterServerRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.jupyter.py.connections.execution.runConfiguration.PythonJupyterServerRunConfigurationOptions");
        PythonJupyterServerRunConfigurationOptions options = (PythonJupyterServerRunConfigurationOptions)abstractJupyterServerRunConfigurationOptions;
        if (!options.getUseSdk()) {
            return null;
        }
        String sdkName = StringKt.nullize$default((String)options.getSdkName(), (boolean)false, (int)1, null);
        if (sdkName != null) {
            module = ProjectJdkTable.getInstance().findJdk(sdkName, PythonSdkType.getInstance().getName());
            if (module == null) {
                String string = "No sdk " + sdkName;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        } else {
            Module module2;
            module = configuration.getConfigurationModule().getModule();
            if ((module == null || (module = PySdkExtKt.getPythonSdk((Module)module)) == null) && ((module2 = configuration.getConfigurationModule().getModule()) != null && (module2 = module2.getProject()) != null ? PySdkExtKt.getPythonSdk((Project)module2) : (module = null)) == null) {
                String string = "No module sdk";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        Module sdk = module;
        return sdk;
    }

    @Nullable
    public TargetEnvironmentRequest createTargetEnvironmentRequest(@NotNull JupyterServerRunConfiguration configuration) {
        TargetEnvironmentConfiguration targetEnvironmentConfiguration;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Sdk sdk = this.getSdk(configuration);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        SdkAdditionalData data = sdk2.getSdkAdditionalData();
        if (data instanceof PyTargetAwareAdditionalData) {
            targetEnvironmentConfiguration = ((PyTargetAwareAdditionalData)data).getTargetEnvironmentConfiguration();
            if (targetEnvironmentConfiguration == null || (targetEnvironmentConfiguration = targetEnvironmentConfiguration.createEnvironmentRequest(configuration.getProject())) == null) {
                targetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
            }
        } else {
            if (data instanceof PyRemoteSdkAdditionalData) {
                String string = ((PyRemoteSdkAdditionalData)data).toString();
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            targetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
        }
        return targetEnvironmentConfiguration;
    }

    public void prepareTargetEnvironmentRequest(@NotNull JupyterServerRunConfiguration configuration, @NotNull TargetEnvironmentRequest request2, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Integer n;
        block7: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
            PythonJupyterServerRunConfigurationExtension $this$prepareTargetEnvironmentRequest_u24lambda_u240 = this;
            boolean bl = false;
            String string = configuration.getJupyterOptions().getCommandLineArguments();
            if (string == null) {
                string = "";
            }
            Iterator iter = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)string).iterator();
            while (iter.hasNext()) {
                String arg = (String)iter.next();
                Object[] objectArray = new String[]{"--port", "--NotebookApp.port"};
                for (String pattern : CollectionsKt.listOf((Object[])objectArray)) {
                    Intrinsics.checkNotNull((Object)arg);
                    if (!StringsKt.startsWith$default((String)arg, (String)pattern, (boolean)false, (int)2, null)) continue;
                    if (arg.length() > pattern.length() + 1 && arg.charAt(pattern.length()) == '=') {
                        String string2 = arg.substring(pattern.length() + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        n = StringsKt.toIntOrNull((String)string2);
                    } else if (iter.hasNext()) {
                        Object e = iter.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        n = StringsKt.toIntOrNull((String)((String)e));
                    } else {
                        n = null;
                    }
                    break block7;
                }
            }
            n = null;
        }
        int port = n != null ? n : 8888;
        ((Collection)request2.getTargetPortBindings()).add(new TargetEnvironment.TargetPortBinding(null, port));
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment targetEnvironment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
    }

    /*
     * WARNING - void declaration
     */
    public void patchCommandLine(@NotNull JupyterServerRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLineBuilder cmdLine, @NotNull String runnerId) {
        Object object;
        Map envs;
        Sdk sdk;
        block11: {
            block10: {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
                Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
                Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
                Sdk sdk2 = this.getSdk(configuration);
                if (sdk2 == null) {
                    return;
                }
                sdk = sdk2;
                String string = sdk.getHomePath();
                if (string == null) {
                    String string2 = "No sdk home path";
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }
                String homePath = string;
                Object[] objectArray = sdk.getSdkAdditionalData();
                if (!(objectArray instanceof PyTargetAwareAdditionalData) && objectArray instanceof PyRemoteSdkAdditionalData) {
                    throw new NotImplementedError(null, 1, null);
                }
                cmdLine.setExePath(TargetValue.fixed((Object)homePath));
                objectArray = new String[]{"-m", "jupyter"};
                cmdLine.addFixedParametersAt(0, CollectionsKt.listOf((Object[])objectArray));
                envs = new LinkedHashMap();
                PySdkExtKt.configureBuilderToRunPythonOnTarget((Sdk)sdk, (TargetedCommandLineBuilder)cmdLine);
                object = PySdkExtKt.getTargetAdditionalData((Sdk)sdk);
                if (object == null || (object = PyTargetAwareAdditionalData.Companion.getPathsAddedByUser((PyTargetAwareAdditionalData)object)) == null) break block10;
                Object $this$map$iv = object;
                boolean $i$f$map = false;
                Object object2 = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getValue());
                }
                Iterable $this$map$iv2 = (List)destination$iv$iv;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String bl = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(TargetEnvironmentFunctions.constant((Object)it));
                }
                object = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                if (object != null) break block11;
            }
            object = new ArrayList();
        }
        Object userPathList = object;
        TargetedPythonPaths.initPythonPath((Map)envs, (boolean)true, (Collection)((Collection)userPathList), (TargetEnvironmentRequest)targetEnvironment.getRequest(), (boolean)false);
        for (Map.Entry entry : envs.entrySet()) {
            String name = (String)entry.getKey();
            Function value = (Function)entry.getValue();
            cmdLine.addEnvironmentVariable(name, (String)value.apply(targetEnvironment));
        }
        Map environmentVariablesForVirtualenv = new LinkedHashMap();
        PythonSdkType.patchEnvironmentVariablesForVirtualenv((Map)environmentVariablesForVirtualenv, (Sdk)sdk);
        Map $this$forEach$iv = environmentVariablesForVirtualenv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            cmdLine.addEnvironmentVariable(name, value);
        }
        CondaPathFixKt.fixCondaPathEnvIfNeeded((TargetedCommandLineBuilder)cmdLine, (Sdk)sdk);
    }
}

