/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteFileNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteLoadingNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.providers.FileExistsHandler;
import com.intellij.jupyter.py.ui.remote.providers.PasteCommand;
import com.intellij.jupyter.py.ui.remote.providers.RemoteToRemoteCopyStrategyBase;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/SingleRemoteFileToRemoteDirCommandBase;", "Lcom/intellij/jupyter/py/ui/remote/providers/PasteCommand;", "project", "Lcom/intellij/openapi/project/Project;", "newName", "", "remoteNode", "Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "targetDirectory", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;)V", "getNewName", "()Ljava/lang/String;", "getRemoteNode", "()Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "getTargetDirectory", "()Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "strategy", "Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToRemoteCopyStrategyBase;", "getStrategy", "()Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToRemoteCopyStrategyBase;", "doExecute", "", "Lcom/intellij/jupyter/py/ui/remote/providers/SingleRemoteFileToOtherRemoteDirCommand;", "Lcom/intellij/jupyter/py/ui/remote/providers/SingleRemoteFileToSameRemoteDirCommand;", "intellij.jupyter.py"})
abstract class SingleRemoteFileToRemoteDirCommandBase
extends PasteCommand {
    @NotNull
    private final String newName;
    @NotNull
    private final JupyterRemoteNode remoteNode;
    @NotNull
    private final JupyterRemotePath targetDirectory;

    private SingleRemoteFileToRemoteDirCommandBase(Project project, String newName, JupyterRemoteNode remoteNode, JupyterRemotePath targetDirectory) {
        super(project, null);
        this.newName = newName;
        this.remoteNode = remoteNode;
        this.targetDirectory = targetDirectory;
    }

    @NotNull
    protected final String getNewName() {
        return this.newName;
    }

    @NotNull
    protected final JupyterRemoteNode getRemoteNode() {
        return this.remoteNode;
    }

    @NotNull
    protected final JupyterRemotePath getTargetDirectory() {
        return this.targetDirectory;
    }

    @NotNull
    protected abstract RemoteToRemoteCopyStrategyBase getStrategy();

    @Override
    protected void doExecute() {
        block5: {
            try {
                JupyterRemoteNode jupyterRemoteNode = this.remoteNode;
                if (jupyterRemoteNode instanceof JupyterRemoteFileNode) {
                    this.getStrategy().copyFile(this.remoteNode.getRemotePath(), this.newName, this.targetDirectory);
                    break block5;
                }
                if (jupyterRemoteNode instanceof JupyterRemoteCompositeNode) {
                    this.getStrategy().copyDirectory(this.remoteNode.getRemotePath(), this.newName, this.targetDirectory);
                    break block5;
                }
                if (jupyterRemoteNode instanceof JupyterRemoteLoadingNode) {
                    return;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (FileExistsHandler.CopyingCancelException copyingCancelException) {
                // empty catch block
            }
        }
    }

    public /* synthetic */ SingleRemoteFileToRemoteDirCommandBase(Project project, String newName, JupyterRemoteNode remoteNode, JupyterRemotePath targetDirectory, DefaultConstructorMarker $constructor_marker) {
        this(project, newName, remoteNode, targetDirectory);
    }
}

