/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.core.jupyter.JupyterErrorHandlingUtilKt;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameterSettingsUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteFileNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteLoadingNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.jupyter.py.ui.remote.providers.JupyterRemoteCopyPasteLog;
import com.intellij.jupyter.py.ui.remote.providers.PasteCommand;
import com.intellij.jupyter.py.ui.remote.providers.RemoteToLocalCopyStrategy;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/py/ui/remote/providers/SingleRemoteItemToLocalDirCommand;", "Lcom/intellij/jupyter/py/ui/remote/providers/PasteCommand;", "project", "Lcom/intellij/openapi/project/Project;", "newName", "", "remoteNode", "Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "localPasteDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;Lcom/intellij/psi/PsiDirectory;)V", "targetDir", "Ljava/io/File;", "kotlin.jvm.PlatformType", "Ljava/io/File;", "sourcePath", "getSourcePath", "()Ljava/lang/String;", "targetPath", "getTargetPath", "taskTitle", "getTaskTitle", "strategy", "Lcom/intellij/jupyter/py/ui/remote/providers/RemoteToLocalCopyStrategy;", "doExecute", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\npasteCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/SingleRemoteItemToLocalDirCommand\n+ 2 JupyterErrorHandlingUtil.kt\ncom/intellij/jupyter/core/jupyter/JupyterErrorHandlingUtilKt\n*L\n1#1,394:1\n41#2:395\n73#2,6:396\n43#2:402\n79#2:403\n77#2,7:404\n47#2:411\n*S KotlinDebug\n*F\n+ 1 pasteCommands.kt\ncom/intellij/jupyter/py/ui/remote/providers/SingleRemoteItemToLocalDirCommand\n*L\n273#1:395\n273#1:396,6\n273#1:402\n273#1:403\n273#1:404,7\n273#1:411\n*E\n"})
final class SingleRemoteItemToLocalDirCommand
extends PasteCommand {
    @NotNull
    private final String newName;
    @NotNull
    private final JupyterRemoteNode remoteNode;
    @NotNull
    private final PsiDirectory localPasteDirectory;
    private final File targetDir;
    @NotNull
    private final String sourcePath;
    @NotNull
    private final String targetPath;
    @NotNull
    private final String taskTitle;
    @NotNull
    private final RemoteToLocalCopyStrategy strategy;

    public SingleRemoteItemToLocalDirCommand(@NotNull Project project, @NotNull String newName, @NotNull JupyterRemoteNode remoteNode, @NotNull PsiDirectory localPasteDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)((Object)remoteNode), (String)"remoteNode");
        Intrinsics.checkNotNullParameter((Object)localPasteDirectory, (String)"localPasteDirectory");
        super(project, null);
        this.newName = newName;
        this.remoteNode = remoteNode;
        this.localPasteDirectory = localPasteDirectory;
        this.targetDir = this.localPasteDirectory.getVirtualFile().toNioPath().toFile();
        this.sourcePath = this.remoteNode.getRemotePath().getFullPath();
        Object[] objectArray = new String[]{this.newName};
        this.targetPath = ((Object)Paths.get(this.targetDir.getAbsolutePath(), (String[])objectArray)).toString();
        objectArray = new Object[]{this.sourcePath, this.targetPath};
        this.taskTitle = JupyterRemoteBundle.message("Jupyter.remote.copying", objectArray);
        this.strategy = new RemoteToLocalCopyStrategy(this);
    }

    @NotNull
    public final String getSourcePath() {
        return this.sourcePath;
    }

    @NotNull
    public final String getTargetPath() {
        return this.targetPath;
    }

    @Override
    @NotNull
    protected String getTaskTitle() {
        return this.taskTitle;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doExecute() {
        void $this$runHandlingConnectionErrors$iv;
        File localPasteDirectoryFile = this.localPasteDirectory.getVirtualFile().toNioPath().toFile();
        VirtualFile[] virtualFileArray = JupyterRemoteCopyPasteLog.INSTANCE.getLOG();
        JupyterRemotePath jupyterRemotePath = this.remoteNode.getRemotePath();
        boolean suggestRemovingConnection$iv = false;
        boolean $i$f$runHandlingConnectionErrors = false;
        void $this$runHandlingConnectionErrors$iv$iv = $this$runHandlingConnectionErrors$iv;
        boolean $i$f$runHandlingConnectionErrors2 = false;
        try {
            boolean bl = false;
            JupyterRemoteNode jupyterRemoteNode = this.remoteNode;
            if (jupyterRemoteNode instanceof JupyterRemoteFileNode) {
                JupyterRemotePath jupyterRemotePath2 = this.remoteNode.getRemotePath();
                Intrinsics.checkNotNull((Object)localPasteDirectoryFile);
                this.strategy.copyFile(jupyterRemotePath2, this.newName, localPasteDirectoryFile);
            } else if (jupyterRemoteNode instanceof JupyterRemoteCompositeNode) {
                JupyterRemotePath jupyterRemotePath3 = this.remoteNode.getRemotePath();
                Intrinsics.checkNotNull((Object)localPasteDirectoryFile);
                this.strategy.copyDirectory(jupyterRemotePath3, this.newName, localPasteDirectoryFile);
            } else {
                if (jupyterRemoteNode instanceof JupyterRemoteLoadingNode) {
                    return;
                }
                throw new NoWhenBranchMatchedException();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (IOException e$iv$iv) {
            void remotePath$iv;
            boolean bl = false;
            ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings = JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority());
            if (configuredServerJupyterModuleConnectionSettings == null) {
                throw e$iv$iv;
            }
            JupyterErrorHandlingUtilKt.suggestRemovingConnection((ConfiguredServerJupyterModuleConnectionSettings)configuredServerJupyterModuleConnectionSettings, (boolean)suggestRemovingConnection$iv);
            void var13_14 = $this$runHandlingConnectionErrors$iv$iv;
            bl = false;
            var13_14.warn("Unexpected exception for " + JupyterConnectionParameterSettingsUtilsKt.getAnyConnectionSettingsForAuthority((String)remotePath$iv.getAuthority()), (Throwable)e$iv$iv);
            Object var10_11 = null;
        }
        virtualFileArray = new VirtualFile[]{this.localPasteDirectory.getVirtualFile()};
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
    }
}

