/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template;

import com.google.common.base.Predicate;
import com.intellij.jinja.model.JinjaClosingTagTools;
import com.intellij.jinja.model.TagLibrary;
import com.intellij.jinja.template.DjangoTemplateRecursiveVisitor;
import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.jinja.template.psi.impl.Jinja2TagNameImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateCloseTagHandlingVisitor
extends DjangoTemplateRecursiveVisitor {
    private final OpenedTags<Jinja2TagNameImpl> myOpenedTags = new OpenedTags();
    private boolean myStopped = false;

    @Override
    public void visitDjangoTagName(Jinja2TagNameImpl curTag) {
        block19: {
            TagLibrary lib;
            String name;
            block17: {
                block18: {
                    if (this.myStopped) {
                        return;
                    }
                    name = curTag.getTagName();
                    lib = TagLibrary.getInstance(curTag.getProject());
                    if (TagLibrary.startsWithEndPrefix(name) || TagLibrary.isMiddle(name)) break block17;
                    if (!lib.requiresCloseTag(curTag)) break block18;
                    this.myOpenedTags.add(Expectation.mandatory(curTag));
                    break block19;
                }
                if (TagLibrary.isDefaultTag(curTag)) break block19;
                this.myOpenedTags.add(Expectation.optional(curTag));
                break block19;
            }
            if (this.myOpenedTags.isEmpty()) {
                if (TagLibrary.isMiddle(name)) {
                    this.handleMiddleWithoutOpened(curTag);
                } else {
                    this.handleCloseTagWithoutOpened(curTag);
                }
            } else if (TagLibrary.isElif(name)) {
                Expectation<Jinja2TagNameImpl> lastOpened = this.myOpenedTags.popLastMandatory();
                if (lastOpened != null && TagLibrary.isIf(lastOpened.getValue().getTagName())) {
                    this.handleElseWithIf(lastOpened.getValue(), curTag);
                    this.myOpenedTags.add(lastOpened);
                } else {
                    this.handleMiddleWithoutOpened(curTag);
                }
            } else if (TagLibrary.isMiddle(name)) {
                String tagName = name;
                Expectation<Jinja2TagNameImpl> lastOpened = this.myOpenedTags.findLastMandatoryWhichFits((Predicate<Jinja2TagNameImpl>)((Predicate)input -> lib.isContainerFor(tagName, (DjangoTagName)input)));
                if (lastOpened != null && lib.isContainerFor(tagName, lastOpened.getValue())) {
                    this.handleElseWithIf(lastOpened.getValue(), curTag);
                    this.myOpenedTags.add(lastOpened);
                } else {
                    this.handleMiddleWithoutOpened(curTag);
                }
            } else {
                name = JinjaClosingTagTools.getOpeningByClosingIfPossible(name);
                while (!this.myOpenedTags.isEmpty()) {
                    Expectation<Jinja2TagNameImpl> expectation;
                    int index;
                    for (index = this.myOpenedTags.getLastIndex(); index >= 0 && !(expectation = this.myOpenedTags.get(index)).isMandatory() && !name.equals(expectation.getValue().getTagName()); --index) {
                    }
                    if (index < 0) {
                        this.handleCloseTagWithoutOpened(curTag);
                        break;
                    }
                    Expectation<Jinja2TagNameImpl> lastOpened = this.myOpenedTags.get(index);
                    if (lastOpened.getValue().getTagName().equals(name)) {
                        this.handleTagClosed(lastOpened.getValue(), curTag);
                        this.myOpenedTags.skipTo(index);
                        break;
                    }
                    this.handleOpenedTagWithoutClosed(lastOpened.getValue());
                    this.myOpenedTags.skipTo(index);
                }
            }
        }
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(0);
        }
        if (this.myStopped) {
            return;
        }
        super.visitElement(element);
    }

    protected void stopVisitor() {
        this.myStopped = true;
    }

    @NotNull
    protected static DjangoTagElementImpl getTagElement(@NotNull DjangoTagName openTag) {
        if (openTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(1);
        }
        DjangoTagElementImpl djangoTagElementImpl = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)openTag, DjangoTagElementImpl.class);
        if (djangoTagElementImpl == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(2);
        }
        return djangoTagElementImpl;
    }

    protected void handleTagClosed(@NotNull DjangoTagName openTag, @NotNull DjangoTagName closeTag) {
        if (openTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(3);
        }
        if (closeTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(4);
        }
    }

    protected void handleOpenedTagWithoutClosed(@NotNull DjangoTagName openedTag) {
        if (openedTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(5);
        }
    }

    protected void handleCloseTagWithoutOpened(@NotNull DjangoTagName closeTag) {
        if (closeTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(6);
        }
    }

    protected void handleMiddleWithoutOpened(@NotNull DjangoTagName middleTag) {
        if (middleTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(7);
        }
    }

    protected void handleElseWithIf(@NotNull DjangoTagName ifTag, @NotNull DjangoTagName elseTag) {
        if (ifTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(8);
        }
        if (elseTag == null) {
            DjangoTemplateCloseTagHandlingVisitor.$$$reportNull$$$0(9);
        }
    }

    protected List<DjangoTagName> getOpenedTags() {
        ArrayList<DjangoTagName> res = new ArrayList<DjangoTagName>();
        while (!this.myOpenedTags.isEmpty()) {
            Expectation<Jinja2TagNameImpl> expectation = this.myOpenedTags.popLast();
            assert (expectation != null);
            if (!expectation.isMandatory()) continue;
            res.add(0, expectation.getValue());
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/DjangoTemplateCloseTagHandlingVisitor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeTag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openedTag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleTag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifTag";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/DjangoTemplateCloseTagHandlingVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTagElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleTagClosed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleOpenedTagWithoutClosed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleCloseTagWithoutOpened";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleMiddleWithoutOpened";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElseWithIf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class OpenedTags<T> {
        private List<Expectation<T>> myOpenedTags = new ArrayList<Expectation<T>>();

        private OpenedTags() {
        }

        public boolean add(@NotNull Expectation<T> expectation) {
            if (expectation == null) {
                OpenedTags.$$$reportNull$$$0(0);
            }
            return this.myOpenedTags.add(expectation);
        }

        @Nullable
        public Expectation<T> remove(int index) {
            return this.myOpenedTags.remove(index);
        }

        @Nullable
        public Expectation<T> findLastMandatoryWhichFits(@NotNull Predicate<? super T> predicate) {
            int i;
            if (predicate == null) {
                OpenedTags.$$$reportNull$$$0(1);
            }
            Expectation<T> last2 = null;
            for (i = this.myOpenedTags.size() - 1; i >= 0 && !predicate.apply((last2 = this.myOpenedTags.get(i)).getValue()); --i) {
            }
            if (last2 != null && i >= 0) {
                this.myOpenedTags = this.myOpenedTags.subList(0, i);
            }
            return last2;
        }

        @Nullable
        public Expectation<T> popLastMandatory() {
            Expectation<T> last2;
            while ((last2 = this.popLast()) != null && last2.isOptional()) {
            }
            return last2;
        }

        @Nullable
        public Expectation<T> popLast() {
            if (this.isEmpty()) {
                return null;
            }
            return this.myOpenedTags.remove(this.getLastIndex());
        }

        private boolean isEmpty() {
            return this.myOpenedTags.isEmpty();
        }

        public int getLastIndex() {
            return this.myOpenedTags.size() - 1;
        }

        public void skipTo(int index) {
            this.myOpenedTags = this.myOpenedTags.subList(0, index);
        }

        public Expectation<T> get(int index) {
            return this.myOpenedTags.get(index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jinja/template/DjangoTemplateCloseTagHandlingVisitor$OpenedTags";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLastMandatoryWhichFits";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Expectation<T> {
        private final T value;
        private final boolean myOptional;

        private Expectation(T value2, boolean optional) {
            this.myOptional = optional;
            this.value = value2;
        }

        public static <T> Expectation<T> optional(T expected) {
            return new Expectation<T>(expected, true);
        }

        public static <T> Expectation<T> mandatory(T expected) {
            return new Expectation<T>(expected, false);
        }

        public boolean isOptional() {
            return this.myOptional;
        }

        public boolean isMandatory() {
            return !this.isOptional();
        }

        public T getValue() {
            return this.value;
        }
    }
}

