/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.formatter;

import com.google.common.collect.ImmutableList;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.jinja.template.formatter.DjangoTemplateFormatterUtil;
import com.intellij.jinja.template.formatter.DjangoTemplateInsideTagBlock;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.psi.DjangoTemplatePsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.template.lang.core.templateLanguages.PyTemplatesCoreUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateBlock
extends AbstractBlock
implements BlockEx {
    private static final Logger LOG = Logger.getInstance(DjangoTemplateBlock.class);
    private final XmlFormattingPolicy myPolicy;

    protected DjangoTemplateBlock(@NotNull ASTNode node, @Nullable Wrap wrap2, @Nullable Alignment alignment, @NotNull XmlFormattingPolicy policy) {
        if (node == null) {
            DjangoTemplateBlock.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            DjangoTemplateBlock.$$$reportNull$$$0(1);
        }
        super(node, wrap2, alignment);
        this.myPolicy = policy;
    }

    protected List<Block> buildChildren() {
        if (this.myNode.getFirstChildNode() != null) {
            ArrayList<Block> result2 = new ArrayList<Block>();
            for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) && child.getTextLength() > 0) {
                    this.processDjangoChild(result2, child);
                }
                LOG.assertTrue(child.getTreeParent() == this.myNode);
            }
            return ImmutableList.copyOf(result2);
        }
        return EMPTY;
    }

    private void processDjangoChild(List<Block> result2, ASTNode child) {
        if (!DjangoTemplatePsiUtil.isTemplateCharacters(child)) {
            if (DjangoTemplateFormatterUtil.isComplexElement(child)) {
                result2.add((Block)new DjangoTemplateBlock(child, null, null, this.myPolicy));
            } else {
                result2.add((Block)new DjangoTemplateInsideTagBlock(child, null, this.myPolicy));
            }
        }
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            DjangoTemplateBlock.$$$reportNull$$$0(2);
        }
        ASTBlock astChild1 = (ASTBlock)child1;
        ASTBlock astChild2 = (ASTBlock)child2;
        if (DjangoTemplateBlock.isInjectionsStartOrEnd(astChild1) || DjangoTemplateBlock.isInjectionsStartOrEnd(astChild2)) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)this.myPolicy.getKeepBlankLines());
        }
        return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)this.myPolicy.getKeepBlankLines());
    }

    private static boolean isInjectionsStartOrEnd(ASTBlock ast) {
        if (ast == null) {
            return false;
        }
        return ast.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_EXPRESSION_START || ast.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_EXPRESSION_END || ast.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_TAG_START || ast.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_TAG_END;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    @Nullable
    public Language getLanguage() {
        return PyTemplatesCoreUtil.getTemplateDataLanguage(this.getNode().getPsi(), DjangoTemplateFileViewProvider.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jinja/template/formatter/DjangoTemplateBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

