/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.cacheManager.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.python.huggingFace.HuggingFaceProBundle;
import com.intellij.python.huggingFace.cacheManager.service.HfCacheEntryData;
import com.intellij.python.huggingFace.cacheManager.service.HfCacheScanner;
import com.intellij.python.huggingFace.cacheManager.ui.HfCacheToolbarFactory;
import com.intellij.python.huggingFace.cacheManager.ui.core.HfCacheMaterialTable;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0002J\u0018\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r\u0012\u0002\b\u00030\u001b0\u0019H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/ui/HfCacheViewPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "table", "Lcom/intellij/python/huggingFace/cacheManager/ui/core/HfCacheMaterialTable;", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/python/huggingFace/cacheManager/service/HfCacheEntryData;", "tablePanel", "Lcom/intellij/ui/components/JBScrollPane;", "scanner", "Lcom/intellij/python/huggingFace/cacheManager/service/HfCacheScanner;", "dispose", "", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "updateData", "updateTableContent", "getSelectedItems", "", "createColumns", "Lcom/intellij/util/ui/ColumnInfo;", "intellij.python.huggingFace"})
@SourceDebugExtension(value={"SMAP\nHfCacheViewPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HfCacheViewPanel.kt\ncom/intellij/python/huggingFace/cacheManager/ui/HfCacheViewPanel\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n37#2,2:93\n11195#3:95\n11530#3,3:96\n*S KotlinDebug\n*F\n+ 1 HfCacheViewPanel.kt\ncom/intellij/python/huggingFace/cacheManager/ui/HfCacheViewPanel\n*L\n25#1:93,2\n62#1:95\n62#1:96,3\n*E\n"})
public final class HfCacheViewPanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final HfCacheMaterialTable table;
    @NotNull
    private final ListTableModel<HfCacheEntryData> tableModel;
    @NotNull
    private final JBScrollPane tablePanel;
    @NotNull
    private final HfCacheScanner scanner;

    public HfCacheViewPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false, true);
        this.project = project;
        this.scanner = HfCacheScanner.Companion.getInstance();
        List<ColumnInfo<HfCacheEntryData, ?>> columns = this.createColumns();
        Collection $this$toTypedArray$iv = columns;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ColumnInfo[] columnInfoArray = thisCollection$iv.toArray(new ColumnInfo[0]);
        this.tableModel = new ListTableModel(Arrays.copyOf(columnInfoArray, columnInfoArray.length));
        this.table = new HfCacheMaterialTable((TableModel)this.tableModel, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((HfCacheViewPanel)((Object)this.receiver)).updateTableContent();
            }
        }));
        ActionToolbar actionToolbar = this.createToolbar();
        this.setToolbar(actionToolbar.getComponent());
        this.tablePanel = new JBScrollPane((Component)((Object)this.table));
        this.setContent((JComponent)this.tablePanel);
        Disposer.register((Disposable)this, (Disposable)this.table);
        this.updateData();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void dispose() {
    }

    private final ActionToolbar createToolbar() {
        ActionToolbar actionToolbar;
        HfCacheToolbarFactory toolbarFactory2 = new HfCacheToolbarFactory(this.project, (Function0<? extends List<HfCacheEntryData>>)((Function0)new Function0<List<? extends HfCacheEntryData>>((Object)this){

            public final List<HfCacheEntryData> invoke() {
                return HfCacheViewPanel.access$getSelectedItems((HfCacheViewPanel)((Object)this.receiver));
            }
        }), (Function0<Unit>)((Function0)() -> HfCacheViewPanel.createToolbar$lambda$0(this)));
        ActionToolbar $this$createToolbar_u24lambda_u241 = actionToolbar = toolbarFactory2.createToolbar();
        boolean bl = false;
        $this$createToolbar_u24lambda_u241.setTargetComponent((JComponent)((Object)this));
        return actionToolbar;
    }

    private final void updateData() {
        this.scanner.updateCachedData((Function0<Unit>)((Function0)() -> HfCacheViewPanel.updateData$lambda$2(this)));
        if (!Intrinsics.areEqual((Object)this.getContent(), (Object)this.tablePanel)) {
            this.setContent((JComponent)this.tablePanel);
        }
    }

    private final void updateTableContent() {
        List<HfCacheEntryData> customData = this.scanner.getCachedData();
        while (this.tableModel.getRowCount() != 0) {
            this.tableModel.removeRow(this.tableModel.getRowCount() - 1);
        }
        this.tableModel.addRows((Collection)customData);
    }

    /*
     * WARNING - void declaration
     */
    private final List<HfCacheEntryData> getSelectedItems() {
        void $this$mapTo$iv$iv;
        int[] selectedRow = this.table.getSelectedRows();
        Intrinsics.checkNotNull((Object)selectedRow);
        int[] $this$map$iv = selectedRow;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((HfCacheEntryData)this.tableModel.getItem((int)it));
        }
        return (List)destination$iv$iv;
    }

    private final List<ColumnInfo<HfCacheEntryData, ?>> createColumns() {
        Object[] objectArray = new ColumnInfo[7];
        String string = HuggingFaceProBundle.INSTANCE.message("cache.table.column.repoId", new Object[0]);
        objectArray[0] = new ColumnInfo<HfCacheEntryData, String>(string){

            public String valueOf(HfCacheEntryData item) {
                HfCacheEntryData hfCacheEntryData = item;
                return hfCacheEntryData != null ? hfCacheEntryData.getRepoId() : null;
            }
        };
        string = HuggingFaceProBundle.INSTANCE.message("cache.table.column.repo.type", new Object[0]);
        objectArray[1] = new ColumnInfo<HfCacheEntryData, String>(string){

            public String valueOf(HfCacheEntryData item) {
                HfCacheEntryData hfCacheEntryData = item;
                return hfCacheEntryData != null && (hfCacheEntryData = hfCacheEntryData.getRepoType()) != null ? hfCacheEntryData.getPrintName() : null;
            }
        };
        string = HuggingFaceProBundle.INSTANCE.message("cache.table.column.size.on.disk", new Object[0]);
        objectArray[2] = new ColumnInfo<HfCacheEntryData, Number>(string){

            public Double valueOf(HfCacheEntryData item) {
                HfCacheEntryData hfCacheEntryData = item;
                return hfCacheEntryData != null ? Double.valueOf(hfCacheEntryData.getSizeOnDisk()) : null;
            }
        };
        string = HuggingFaceProBundle.INSTANCE.message("cache.table.column.num.files", new Object[0]);
        objectArray[3] = new ColumnInfo<HfCacheEntryData, Integer>(string){

            public Integer valueOf(HfCacheEntryData item) {
                HfCacheEntryData hfCacheEntryData = item;
                return hfCacheEntryData != null ? Integer.valueOf(hfCacheEntryData.getNumFiles()) : null;
            }
        };
        string = HuggingFaceProBundle.INSTANCE.message("cache.table.column.last.accessed", new Object[0]);
        objectArray[4] = new ColumnInfo<HfCacheEntryData, Date>(string){

            public Date valueOf(HfCacheEntryData item) {
                HfCacheEntryData hfCacheEntryData = item;
                return hfCacheEntryData != null ? hfCacheEntryData.getLastAccessed() : null;
            }
        };
        string = HuggingFaceProBundle.INSTANCE.message("cache.table.column.last.modified", new Object[0]);
        objectArray[5] = new ColumnInfo<HfCacheEntryData, Date>(string){

            public Date valueOf(HfCacheEntryData item) {
                HfCacheEntryData hfCacheEntryData = item;
                return hfCacheEntryData != null ? hfCacheEntryData.getLastModified() : null;
            }
        };
        string = HuggingFaceProBundle.INSTANCE.message("cache.table.column.local.path", new Object[0]);
        objectArray[6] = new ColumnInfo<HfCacheEntryData, String>(string){

            public String valueOf(HfCacheEntryData item) {
                HfCacheEntryData hfCacheEntryData = item;
                return String.valueOf(hfCacheEntryData != null ? hfCacheEntryData.getPath() : null);
            }
        };
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit createToolbar$lambda$0(HfCacheViewPanel this$0) {
        this$0.updateData();
        return Unit.INSTANCE;
    }

    private static final Unit updateData$lambda$2(HfCacheViewPanel this$0) {
        this$0.updateTableContent();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getSelectedItems(HfCacheViewPanel $this) {
        return $this.getSelectedItems();
    }
}

