/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.callgraph;

import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiManager;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.ProfileDataKt;
import com.intellij.python.profiler.PythonProfilerBundle;
import com.intellij.python.profiler.UtilsKt;
import com.intellij.python.profiler.callgraph.CallGraphBuilder;
import com.intellij.python.profiler.callgraph.CallGraphNode;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J*\u0010\u001d\u001a\u00020\u00152\b\b\u0001\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/python/profiler/callgraph/CallGraphNodeRenderer;", "Lcom/intellij/openapi/graph/builder/renderer/AbstractColoredNodeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "builder", "Lcom/intellij/python/profiler/callgraph/CallGraphBuilder;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/profiler/callgraph/CallGraphBuilder;)V", "MULTIPLE_SIGN", "", "createNodeRealizerComponent", "Ljavax/swing/JComponent;", "view", "Lcom/intellij/openapi/graph/view/Graph2DView;", "realizer", "Lcom/intellij/openapi/graph/view/NodeRealizer;", "obj", "", "sel", "", "tuneNode", "", "wrapper", "Ljavax/swing/JPanel;", "colorIntensity", "Ljava/awt/Color;", "totalTimeMs", "", "baseTotalTime", "addTime", "labelName", "time", "totalTime", "propertiesPanel", "getSelectionBorderWidth", "intellij.python.profiler"})
public final class CallGraphNodeRenderer
extends AbstractColoredNodeCellRenderer {
    @NotNull
    private final CallGraphBuilder builder;
    @NlsSafe
    @NotNull
    private final String MULTIPLE_SIGN;

    public CallGraphNodeRenderer(@NotNull Project project, @NotNull CallGraphBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        super((ModificationTracker)PsiManager.getInstance((Project)project).getModificationTracker());
        this.builder = builder;
        this.MULTIPLE_SIGN = "\u00d7";
    }

    @NotNull
    protected JComponent createNodeRealizerComponent(@NotNull Graph2DView view, @NotNull NodeRealizer realizer, @Nullable Object obj, boolean sel) {
        Border border2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)realizer, (String)"realizer");
        CellRendererPanel panel = new CellRendererPanel((LayoutManager)new BorderLayout());
        Color color = this.getBorderColor(realizer, obj, true);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBorderColor(...)");
        Color selectionBorderColor = color;
        if (GraphExportService.getInstance().isPrintMode()) {
            border2 = new LineBorder((Color)Gray._168, 2);
        } else if (!JBColor.isBright()) {
            AbstractBorder abstractBorder;
            if (sel) {
                abstractBorder = new LineBorder(selectionBorderColor, this.getSelectionBorderWidth(), false);
            } else {
                JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
                abstractBorder = (AbstractBorder)jBEmptyBorder;
            }
            border2 = abstractBorder;
        } else {
            AbstractBorder abstractBorder;
            if (sel) {
                abstractBorder = new LineBorder(selectionBorderColor);
            } else {
                JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
                abstractBorder = (AbstractBorder)jBEmptyBorder;
            }
            border2 = abstractBorder;
        }
        panel.setBorder(border2);
        panel.setFocusable(false);
        this.tuneNode(realizer, (JPanel)panel);
        return (JComponent)panel;
    }

    public void tuneNode(@NotNull NodeRealizer realizer, @NotNull JPanel wrapper) {
        Intrinsics.checkNotNullParameter((Object)realizer, (String)"realizer");
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Node node = realizer.getNode();
        DiagramNode beansNode = (DiagramNode)this.builder.getNodeObject(node);
        if (beansNode != null) {
            FunctionStat callStat = ((CallGraphNode)beansNode).getCallStat();
            JLabel nameLabel = new JLabel(ProfileDataKt.functionPresentableName(callStat.getName(), callStat.getFile()), ((CallGraphNode)beansNode).getIcon(), 0);
            nameLabel.setFont(nameLabel.getFont().deriveFont(1, (float)((double)nameLabel.getFont().getSize() * 1.2)));
            nameLabel.setBorder(JBUI.Borders.empty((int)3));
            nameLabel.setHorizontalAlignment(2);
            nameLabel.setForeground((Color)JBColor.BLACK);
            Color colorIntensity = this.colorIntensity(callStat.getTotalTimeMs(), callStat.getBaseTotalTime());
            CellRendererPanel namePanel = new CellRendererPanel((LayoutManager)new BorderLayout());
            namePanel.add((Component)nameLabel, (Object)"Center");
            namePanel.setForcedBackground(colorIntensity);
            wrapper.add((Component)namePanel, "North");
            CellRendererPanel propertiesPanel = new CellRendererPanel((LayoutManager)new GridBagLayout());
            propertiesPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
            propertiesPanel.setForcedBackground(colorIntensity);
            wrapper.add((Component)propertiesPanel, "Center");
            String string = PythonProfilerBundle.message("profiler.time.total", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.addTime(string, callStat.getTotalTimeMs(), callStat.getBaseTotalTime(), (JPanel)propertiesPanel);
            String string2 = PythonProfilerBundle.message("profiler.time.own", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.addTime(string2, callStat.getOwnTimeMs(), callStat.getBaseTotalTime(), (JPanel)propertiesPanel);
            HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.text((String)this.MULTIPLE_SIGN), HtmlChunk.text((String)String.valueOf(callStat.getCallCount()))};
            JLabel callCountVal = new JLabel(HtmlChunk.html().children(htmlChunkArray).toString());
            callCountVal.setForeground((Color)JBColor.BLACK);
            callCountVal.setFont(callCountVal.getFont().deriveFont(1));
            callCountVal.setHorizontalAlignment(4);
            callCountVal.setBorder((Border)JBUI.Borders.empty((int)1, (int)2, (int)1, (int)3));
            namePanel.add((Component)callCountVal, (Object)"East");
            GridBagConstraints horizontalFill = new GridBagConstraints();
            horizontalFill.gridx = 3;
            horizontalFill.gridy = 0;
            horizontalFill.anchor = 17;
            horizontalFill.fill = 2;
            horizontalFill.weightx = 1.0;
            propertiesPanel.add(Box.createHorizontalGlue(), (Object)horizontalFill);
        }
    }

    private final Color colorIntensity(int totalTimeMs, int baseTotalTime) {
        float power = 1.0f - (float)totalTimeMs / (float)baseTotalTime;
        double hue = (double)power * 0.4;
        double saturation = 0.5;
        double brightness = JBColor.isBright() ? 0.9 : 0.5;
        Color color = Color.getHSBColor((float)hue, (float)saturation, (float)brightness);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getHSBColor(...)");
        return color;
    }

    private final void addTime(@NlsContexts.Label String labelName, int time, int totalTime, JPanel propertiesPanel) {
        JLabel timeLabel = new JLabel(labelName);
        timeLabel.setForeground((Color)JBColor.BLACK);
        Object[] objectArray = new Object[]{String.valueOf(time)};
        JLabel timeVal = new JLabel(PythonProfilerBundle.message("call.graph.add.time.milliseconds.label.text", objectArray));
        timeVal.setForeground((Color)JBColor.BLACK);
        JLabel timePc = new JLabel(UtilsKt.percent(time, totalTime));
        timePc.setForeground((Color)JBColor.DARK_GRAY);
        timeVal.setFont(timeVal.getFont().deriveFont(1));
        propertiesPanel.add((Component)timeLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 21, 0, (Insets)JBUI.insets((int)2), 0, 0));
        propertiesPanel.add((Component)timeVal, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 22, 0, (Insets)JBUI.insets((int)2), 0, 0));
        propertiesPanel.add((Component)timePc, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 22, 0, (Insets)JBUI.insets((int)2), 0, 0));
    }

    protected int getSelectionBorderWidth() {
        return 2;
    }
}

