/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Pair;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PySshInterpreterUtil {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    @NotNull
    private static final String FIND_FREE_PORT_COMMAND = "from __future__ import print_function; import socket; s = socket.socket(socket.AF_INET, socket.SOCK_STREAM); s.bind(('localhost', 0)); print(s.getsockname()); s.close()";

    @NotNull
    public static Pair<String, Integer> obtainRemoteSocket(@NotNull ConnectionBuilder connectionBuilder, @NotNull String interpreterPath) throws RemoteSdkException {
        ProcessOutput output;
        block7: {
            if (connectionBuilder == null) {
                PySshInterpreterUtil.$$$reportNull$$$0(0);
            }
            if (interpreterPath == null) {
                PySshInterpreterUtil.$$$reportNull$$$0(1);
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreterPath, "-c", FIND_FREE_PORT_COMMAND});
            SshExecProcess process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(false).start();
            CapturingSshProcessHandler processHandler = new CapturingSshProcessHandler((SshProcess)process, null, commandLine.getCommandLineString());
            output = processHandler.runProcess();
            Pair<String, Integer> socketName = PySshInterpreterUtil.getSocketName(output.getStdout().trim());
            if (socketName == null) break block7;
            Pair<String, Integer> pair2 = socketName;
            if (pair2 == null) {
                PySshInterpreterUtil.$$$reportNull$$$0(2);
            }
            return pair2;
        }
        try {
            throw new RemoteSdkException(PythonRemoteInterpreterBundle.message("python.ssh.interpreter.couldn.t.obtain.remote.socket.from.output.stderr", output.getStdout(), output.getStderr()));
        }
        catch (RemoteSdkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteSdkException(PythonRemoteInterpreterBundle.message("python.ssh.interpreter.error.obtaining.remote.socket", e.getMessage()), (Throwable)e);
        }
    }

    @Nullable
    static Pair<String, Integer> getSocketName(@NotNull String str) {
        if (str == null) {
            PySshInterpreterUtil.$$$reportNull$$$0(3);
        }
        if (str.length() > 1) {
            String[] parts = (str = str.substring(1, str.length() - 1)).split(",");
            return parts.length == 2 ? Pair.create((Object)PySshInterpreterUtil.unquote(parts[0].trim()), (Object)Integer.parseInt(parts[1].trim())) : null;
        }
        return null;
    }

    @NotNull
    private static String unquote(@NotNull String s) {
        if (s == null) {
            PySshInterpreterUtil.$$$reportNull$$$0(4);
        }
        if (s.length() > 2) {
            if (s.startsWith(SINGLE_QUOTE) && s.endsWith(SINGLE_QUOTE)) {
                String string = s.substring(1, s.length() - 1);
                if (string == null) {
                    PySshInterpreterUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (s.startsWith(DOUBLE_QUOTE) && s.endsWith(DOUBLE_QUOTE)) {
                String string = s.substring(1, s.length() - 1);
                if (string == null) {
                    PySshInterpreterUtil.$$$reportNull$$$0(6);
                }
                return string;
            }
        }
        String string = s;
        if (string == null) {
            PySshInterpreterUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PySshInterpreterUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PySshInterpreterUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainRemoteSocket";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainRemoteSocket";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSocketName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

