/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.display;

import com.google.gson.JsonObject;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.python.scientific.DisplayMessageHandler;
import com.intellij.python.scientific.PySciProjectComponent;
import com.intellij.python.scientific.PyScientificBundle;
import com.intellij.python.scientific.figures.DisplayMessageKt;
import com.intellij.python.scientific.figures.MatplotlibDisplayObject;
import com.intellij.python.scientific.figures.base.FigureBase;
import com.intellij.python.scientific.figures.base.FigureUtil;
import com.intellij.python.scientific.figures.display.PlotsType;
import com.intellij.python.scientific.figures.image.ImageFigure;
import com.intellij.python.scientific.figures.interactive.InteractiveFigure;
import com.intellij.python.scientific.utils.PlotsCoroutinesService;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Base64;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/scientific/figures/display/MatplotlibMessageHandler;", "Lcom/intellij/python/scientific/DisplayMessageHandler;", "<init>", "()V", "getApplicableMessageType", "", "createFigure", "Lcom/intellij/python/scientific/figures/base/FigureBase;", "dataObject", "Lcom/google/gson/JsonObject;", "project", "Lcom/intellij/openapi/project/Project;", "Util", "Companion", "intellij.python.scientific"})
@SourceDebugExtension(value={"SMAP\nMatplotlibMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatplotlibMessageHandler.kt\ncom/intellij/python/scientific/figures/display/MatplotlibMessageHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n24#2:97\n24#2:98\n24#2:99\n*S KotlinDebug\n*F\n+ 1 MatplotlibMessageHandler.kt\ncom/intellij/python/scientific/figures/display/MatplotlibMessageHandler\n*L\n35#1:97\n40#1:98\n65#1:99\n*E\n"})
public final class MatplotlibMessageHandler
implements DisplayMessageHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String STRING_3D = "3D";

    @Override
    @NotNull
    public String getApplicableMessageType() {
        return PlotsType.MATPLOTLIB.getId();
    }

    @Override
    @NotNull
    public FigureBase createFigure(@NotNull JsonObject dataObject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MatplotlibDisplayObject displayObject = DisplayMessageKt.getDisplayObjectFromMap(dataObject);
        int index = displayObject.getPlotIndex();
        FigureBase figure = null;
        BufferedImage image = Util.INSTANCE.createImage$intellij_python_scientific(displayObject);
        MatplotlibMessageHandler $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(MatplotlibMessageHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.info("Plot is received: width=" + image.getWidth());
        String htmlString = displayObject.getHtmlString();
        boolean is3D = Intrinsics.areEqual((Object)htmlString, (Object)STRING_3D);
        if (!(((CharSequence)htmlString).length() == 0) && !is3D) {
            MatplotlibMessageHandler $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger3 = Logger.getInstance(MatplotlibMessageHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.info("Interactive plots mode");
            figure = InteractiveFigure.Companion.createDefault$default(InteractiveFigure.Companion, htmlString, image, null, project, null, 16, null);
        } else {
            Ref.ObjectRef additionalPanel = new Ref.ObjectRef();
            if (PySciProjectComponent.getInstance(project).isInteractivePlotsMode() && ((CharSequence)htmlString).length() == 0 && PySciProjectComponent.getInstance(project).isInteractivePlotsSuggested()) {
                additionalPanel.element = BuilderKt.panel(arg_0 -> MatplotlibMessageHandler.createFigure$lambda$3(project, additionalPanel, arg_0));
            }
            MatplotlibMessageHandler $this$thisLogger$iv3 = this;
            boolean $i$f$thisLogger3 = false;
            Logger logger4 = Logger.getInstance(MatplotlibMessageHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
            logger4.info("Static plots mode");
            figure = ImageFigure.Companion.createDefault(image, project, (JComponent)additionalPanel.element);
        }
        if (index >= 0) {
            figure.setSearchKey(index);
        }
        return figure;
    }

    private static final Unit createFigure$lambda$3$lambda$2$lambda$0(Project $project, Ref.ObjectRef $additionalPanel, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)PlotsCoroutinesService.Utils.INSTANCE.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, (Ref.ObjectRef<JComponent>)$additionalPanel, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef<JComponent> $additionalPanel;
            {
                this.$project = $project;
                this.$additionalPanel = $additionalPanel;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = PySdkExtKt.getPythonSdk((Project)this.$project);
                        if (v0 == null) {
                            return Unit.INSTANCE;
                        }
                        sdk = v0;
                        this.label = 1;
                        v1 = PyPackageInstallUtils.INSTANCE.confirmAndInstall(this.$project, sdk, "mpld3", (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl17:
                        // 2 sources

                        v2 = (JComponent)this.$additionalPanel.element;
                        if (v2 != null) {
                            v2.setVisible(false);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit createFigure$lambda$3$lambda$2$lambda$1(Project $project, Ref.ObjectRef $additionalPanel, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            PySciProjectComponent.getInstance($project).setInteractivePlotsSuggested(false);
            JComponent jComponent = (JComponent)$additionalPanel.element;
            if (jComponent == null) break block0;
            jComponent.setVisible(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createFigure$lambda$3$lambda$2(Project $project, Ref.ObjectRef $additionalPanel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyScientificBundle.message("link.label.install.mpld3.link", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ((ActionLink)$this$row.link(string, arg_0 -> MatplotlibMessageHandler.createFigure$lambda$3$lambda$2$lambda$0($project, $additionalPanel, arg_0)).gap(RightGap.SMALL).getComponent()).setIcon(AllIcons.General.Information);
        String string2 = PyScientificBundle.message("label.install.mpld3.to.see.preview", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.label(string2).gap(RightGap.SMALL);
        String string3 = PyScientificBundle.message("action.dont.show.again", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$row.link(string3, arg_0 -> MatplotlibMessageHandler.createFigure$lambda$3$lambda$2$lambda$1($project, $additionalPanel, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createFigure$lambda$3(Project $project, Ref.ObjectRef $additionalPanel, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> MatplotlibMessageHandler.createFigure$lambda$3$lambda$2($project, $additionalPanel, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/scientific/figures/display/MatplotlibMessageHandler$Companion;", "", "<init>", "()V", "STRING_3D", "", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/python/scientific/figures/display/MatplotlibMessageHandler$Util;", "", "<init>", "()V", "createImage", "Ljava/awt/image/BufferedImage;", "displayObject", "Lcom/intellij/python/scientific/figures/MatplotlibDisplayObject;", "createImage$intellij_python_scientific", "intellij.python.scientific"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @NotNull
        public final BufferedImage createImage$intellij_python_scientific(@NotNull MatplotlibDisplayObject displayObject) {
            Intrinsics.checkNotNullParameter((Object)displayObject, (String)"displayObject");
            try {
                String imageBase64 = displayObject.getImageBase64();
                byte[] bytes = Base64.getDecoder().decode(imageBase64);
                BufferedImage bufferedImage = FigureUtil.fromRawBytes(bytes);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"fromRawBytes(...)");
                return bufferedImage;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Couldn't decode image", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Couldn't decode image", e);
            }
        }
    }
}

