/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.uml.python;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.uml.python.PyDummyFileClass;
import com.intellij.python.uml.python.PyDummyPackageClass;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibCanonicalPathProviderKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUmlElementManager
extends AbstractDiagramElementManager<PyClass> {
    @Nullable
    public PyClass findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            PyUmlElementManager.$$$reportNull$$$0(0);
        }
        return PyUmlElementManager.findElementInContext(context);
    }

    public static PyClass findElementInContext(DataContext context) {
        PyClass umlElement = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (element instanceof PyClass) {
            umlElement = (PyClass)element;
        } else if (element instanceof PyFile) {
            umlElement = new PyDummyFileClass(((PyFile)element).getName(), project, (PyFile)element);
        } else if (element instanceof PsiDirectory && ((PsiDirectory)element).findFile("__init__.py") != null) {
            umlElement = new PyDummyPackageClass(project, (PsiDirectory)element);
        } else {
            PsiFile psiFile;
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            PsiFile psiFile2 = psiFile = element instanceof PsiFile ? (PsiFile)element : (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (psiFile != null && editor != null) {
                PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset());
                PyClass parent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyClass.class);
                if (parent != null) {
                    umlElement = parent;
                } else {
                    PsiFile file = psiElement.getContainingFile();
                    if (file instanceof PyFile) {
                        umlElement = new PyDummyFileClass(file.getName(), project, (PyFile)file);
                    }
                }
            }
        }
        return umlElement;
    }

    public Object @NotNull [] getNodeItems(PyClass aClass) {
        ArrayList elements = new ArrayList();
        Collections.addAll(elements, aClass.getMethods());
        Collections.addAll(elements, aClass.getNestedClasses());
        elements.addAll(aClass.getInstanceAttributes());
        elements.addAll(aClass.getClassAttributes());
        Object[] objectArray = elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
        if (objectArray == null) {
            PyUmlElementManager.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof PyClass;
    }

    @Nullable
    public String getElementTitle(PyClass element) {
        QualifiedName name;
        @NlsSafe String qualifiedName = element.getQualifiedName();
        if (qualifiedName != null && (name = PyStdlibCanonicalPathProviderKt.restoreStdlibCanonicalPath((QualifiedName)QualifiedName.fromDottedString((String)qualifiedName))) != null) {
            qualifiedName = name.toString();
        }
        return qualifiedName;
    }

    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            PyUmlElementManager.$$$reportNull$$$0(2);
        }
        StringBuilder text2 = new StringBuilder();
        if (element instanceof PyClass) {
            PyClass parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)((PyClass)element), PyClass.class);
            while (parentClass != null) {
                text2.append(parentClass.getName()).append(".");
                parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PyClass.class);
            }
            text2.append(((PyClass)element).getName());
        } else if (element instanceof PyFunction) {
            text2.append(((PyFunction)element).getName()).append(((PyFunction)element).getParameterList().getText());
        } else if (element instanceof PyTargetExpression) {
            text2.append(((PyTargetExpression)element).getName());
        }
        return new SimpleColoredText(text2.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Nullable
    @Nls
    public String getNodeTooltip(PyClass element) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/uml/python/PyUmlElementManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/uml/python/PyUmlElementManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

