/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.scientific.py.tables.panel.datawrangler.DSSummaryCreationSettings;
import com.intellij.scientific.py.tables.panel.datawrangler.DataWranglerMainPanel;
import com.intellij.scientific.py.tables.panel.datawrangler.NewSummaryTreePartShowcaseComponent;
import com.intellij.scientific.py.tables.panel.datawrangler.SummaryTreeTable;
import com.intellij.scientific.tables.panel.DSTableWithStatistics;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H&J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryComponent;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/scientific/py/tables/panel/datawrangler/NewSummaryTreePartShowcaseComponent;", "table", "Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "<init>", "(Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;)V", "getTable", "()Lcom/intellij/scientific/tables/panel/DSTableWithStatistics;", "treeTable", "Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeTable;", "getTreeTable", "()Lcom/intellij/scientific/py/tables/panel/datawrangler/SummaryTreeTable;", "createScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "initializeComponents", "", "addNewSummaryAndRepaint", "settings", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DSSummaryCreationSettings;", "deleteSummaryAndRepaint", "summaryName", "", "setSummaryVisibleAndRepaint", "isVisible", "", "replaceWithOneTreeSummaryAndRepaint", "intellij.scientific.py.tables"})
public abstract class SummaryComponent
extends JBPanel<NewSummaryTreePartShowcaseComponent> {
    @NotNull
    private final DSTableWithStatistics table;
    @NotNull
    private final SummaryTreeTable treeTable;

    public SummaryComponent(@NotNull DSTableWithStatistics table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        super((LayoutManager)new BorderLayout());
        this.table = table;
        this.treeTable = new SummaryTreeTable(this.table);
    }

    @NotNull
    public final DSTableWithStatistics getTable() {
        return this.table;
    }

    @NotNull
    public final SummaryTreeTable getTreeTable() {
        return this.treeTable;
    }

    @NotNull
    protected JBScrollPane createScrollPane() {
        JPanel panelWithTree = new JPanel(new BorderLayout());
        JBScrollPane myScrollPane = DataWranglerMainPanel.Companion.createScrollPane(panelWithTree);
        this.treeTable.getMyTreeTable().setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.treeTable.getMyTreeTable().setColumnProportion(0.33f);
        panelWithTree.add((Component)this.treeTable.getMyTreeTable());
        panelWithTree.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        panelWithTree.setOpaque(true);
        return myScrollPane;
    }

    public abstract void initializeComponents();

    public final void addNewSummaryAndRepaint(@NotNull DSSummaryCreationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.removeAll();
        this.treeTable.addNewSummary(settings);
        this.initializeComponents();
    }

    public final void deleteSummaryAndRepaint(@NotNull String summaryName) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        this.removeAll();
        this.treeTable.deleteSummary(summaryName);
        this.initializeComponents();
    }

    public final void setSummaryVisibleAndRepaint(@NotNull String summaryName, boolean isVisible2) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        this.removeAll();
        this.treeTable.setSummaryVisible(summaryName, isVisible2);
        this.initializeComponents();
    }

    public final void replaceWithOneTreeSummaryAndRepaint(@NotNull DSSummaryCreationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.removeAll();
        this.treeTable.replaceWithOneTree(settings, true);
        this.initializeComponents();
    }
}

