/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.facet;

import com.intellij.DynamicBundle;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UI;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.ManagePyEnvironmentVariablesComponent;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PythonFileType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoSettingsPanel
extends JPanel {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myProjectRootFolder;
    private TextFieldWithBrowseButton mySettingsFileField;
    private TextFieldWithBrowseButton myManageFileField;
    private JPanel myErrorPanel;
    private ManagePyEnvironmentVariablesComponent myVariablesComponent;
    private JBCheckBox myDoNotUseTestRunner;
    private JPanel myPlaceForFilesPattern;
    private final JBTextField myJBTrackFilePattern;
    private final FileChooserDescriptor mySettingsFileDescriptor;
    private final FileChooserDescriptor myManageFileDescriptor;
    private final TextFieldRootRelativePathAccessor textFieldAccessor;

    public DjangoSettingsPanel(Project project) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myJBTrackFilePattern = new JBTextField();
        this.textFieldAccessor = new TextFieldRootRelativePathAccessor();
        FileChooserDescriptor rootDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(DjangoBundle.message("select-root-folder-title", new Object[0])).withDescription(DjangoBundle.message("select-root-folder-desc", new Object[0]));
        this.myProjectRootFolder.addBrowseFolderListener(project, rootDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.mySettingsFileDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor().withTitle(DjangoBundle.message("django.select.settings.file", new Object[0]));
        this.mySettingsFileField.addBrowseFolderListener(project, this.mySettingsFileDescriptor, (TextComponentAccessor)this.textFieldAccessor);
        this.mySettingsFileField.setEditable(false);
        this.myManageFileDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)PythonFileType.INSTANCE).withTitle(DjangoBundle.message("django.select.manage.script", new Object[0]));
        this.myManageFileField.addBrowseFolderListener(project, this.myManageFileDescriptor, (TextComponentAccessor)this.textFieldAccessor);
        this.myManageFileField.setEditable(false);
        this.myProjectRootFolder.getTextField().getDocument().addDocumentListener(this.createProjectRootDocumentListener());
        this.initErrorValidation();
        this.add((Component)this.myPanel, "Center");
        JPanel trackFilesPanel = UI.PanelFactory.panel((JComponent)this.myJBTrackFilePattern).withComment(DjangoBundle.message("settings.file-tracking.comment", new Object[0])).createPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.gridx = 0;
        this.myPlaceForFilesPattern.add((Component)trackFilesPanel, cons);
    }

    private void initErrorValidation() {
        FacetErrorPanel facetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)facetErrorPanel.getComponent(), "Center");
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = DjangoSettingsPanel.validateProjectRoot(DjangoSettingsPanel.this.myProjectRootFolder.getText());
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/facet/DjangoSettingsPanel$1", "check"));
            }
        }, new JComponent[]{this.myProjectRootFolder});
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = DjangoSettingsPanel.this.validateSettings("settings file", DjangoSettingsPanel.this.mySettingsFileField.getText());
                if (validationResult == null) {
                    2.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/facet/DjangoSettingsPanel$2", "check"));
            }
        }, new JComponent[]{this.mySettingsFileField.getTextField()});
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                ValidationResult validationResult = DjangoSettingsPanel.validateManage("manage script", DjangoSettingsPanel.this.myManageFileField.getText());
                if (validationResult == null) {
                    3.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/facet/DjangoSettingsPanel$3", "check"));
            }
        }, new JComponent[]{this.myManageFileField.getTextField()});
        facetErrorPanel.getValidatorsManager().validate();
    }

    private ValidationResult validateSettings(String name, String value2) {
        if (StringUtil.isEmpty((String)value2)) {
            return new ValidationResult(DjangoBundle.message("settings.no.value.validation.error.message", name));
        }
        return ValidationResult.OK;
    }

    private static ValidationResult validateManage(String name, String value2) {
        if (StringUtil.isEmpty((String)value2)) {
            return new ValidationResult(DjangoBundle.message("settings.no.manage.value.validation.error.message", name));
        }
        return ValidationResult.OK;
    }

    private static ValidationResult validateProjectRoot(@Nullable String text2) {
        if (StringUtil.isEmpty((String)text2)) {
            return new ValidationResult(DjangoBundle.message("settings.project.root.validation.error.message", new Object[0]));
        }
        if (!new File(text2).exists()) {
            return new ValidationResult(DjangoBundle.message("settings.no.project.root.dir.validation.error.message", new Object[0]));
        }
        if (!new File(text2).isDirectory()) {
            return new ValidationResult(DjangoBundle.message("settings.project.root.dir.validation.error.message", new Object[0]));
        }
        return ValidationResult.OK;
    }

    private DocumentListener createProjectRootDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String root = DjangoSettingsPanel.this.myProjectRootFolder.getText();
                VirtualFile rootFile = VirtualFileUtil.findFile(root);
                if (rootFile != null) {
                    DjangoSettingsPanel.this.textFieldAccessor.setRoot(rootFile);
                    DjangoSettingsPanel.this.updateSettingsFile(rootFile);
                    DjangoSettingsPanel.this.updateManageFile(rootFile);
                }
            }
        };
    }

    private void updateSettingsFile(@NotNull VirtualFile rootFile) {
        if (rootFile == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(0);
        }
        this.mySettingsFileDescriptor.setRoots(new VirtualFile[]{rootFile});
        DjangoSettingsPanel.updateDescriptorAndField(this.mySettingsFileDescriptor, this.mySettingsFileField, this.textFieldAccessor, "settings.py", rootFile);
    }

    private void updateManageFile(@NotNull VirtualFile rootFile) {
        if (rootFile == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(1);
        }
        DjangoSettingsPanel.updateDescriptorAndField(this.myManageFileDescriptor, this.myManageFileField, this.textFieldAccessor, "manage.py", rootFile);
    }

    private static void updateDescriptorAndField(FileChooserDescriptor descriptor, TextFieldWithBrowseButton textField, TextFieldRootRelativePathAccessor textFieldAccessor, String name, @NotNull VirtualFile rootFile) {
        String file;
        if (rootFile == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(2);
        }
        if ((file = DjangoCoreUtil.getExistingFileForName(rootFile, name)) != null) {
            VirtualFile fileToSelect = rootFile.findChild(file);
            descriptor.getFileToSelect(fileToSelect);
            textFieldAccessor.setText(textField.getTextField(), file);
        }
    }

    public void setProjectRootFolder(String folder) {
        this.myProjectRootFolder.setText(folder != null ? FileUtil.toSystemDependentName((String)folder) : "");
    }

    @Nullable
    private String getSettingsModule() {
        return DjangoSettingsPanel.getPathRelativeToDjangoRoot(this.mySettingsFileField.getText());
    }

    @Nullable
    private String getManageScript() {
        return DjangoSettingsPanel.getPathRelativeToDjangoRoot(this.myManageFileField.getText());
    }

    @NotNull
    private static String getPathRelativeToDjangoRoot(String path2) {
        String string = FileUtil.toSystemIndependentName((String)path2);
        if (string == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setSettingsModule(@Nullable String settingsFileRelPath) {
        this.setRelativePathToField(this.mySettingsFileField, settingsFileRelPath);
    }

    public void setManageScript(@Nullable String manageFileRelPath) {
        this.setRelativePathToField(this.myManageFileField, manageFileRelPath);
    }

    public void setTrackFilePattern(@NotNull String trackFilePattern) {
        if (trackFilePattern == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(4);
        }
        this.myJBTrackFilePattern.setText(trackFilePattern);
    }

    @NotNull
    public String getTrackFilePattern() {
        String string = this.myJBTrackFilePattern.getText();
        if (string == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setRelativePathToField(@NotNull TextFieldWithBrowseButton textField, @Nullable @NlsSafe String settingsFileRelPath) {
        VirtualFile settingsFile;
        VirtualFile root;
        if (textField == null) {
            DjangoSettingsPanel.$$$reportNull$$$0(6);
        }
        if ((root = VirtualFileUtil.findFile(this.myProjectRootFolder.getText())) != null && settingsFileRelPath != null && (settingsFile = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)settingsFileRelPath))) != null) {
            this.textFieldAccessor.setText(textField.getTextField(), FileUtil.toSystemDependentName((String)settingsFile.getPath()));
            return;
        }
        VirtualFile vFile = VirtualFileUtil.findFile(settingsFileRelPath);
        if (vFile != null) {
            textField.setText(settingsFileRelPath);
            return;
        }
        textField.setText("");
    }

    public void reset(DjangoFacetConfiguration config2) {
        if (config2 != null) {
            VirtualFile file = config2.getProjectRootFolderFile();
            this.setProjectRootFolder(file != null ? file.getPath() : "");
            this.setSettingsModule(config2.getSettingsFilePath());
            this.setManageScript(config2.getManageFilePath());
            this.setTrackFilePattern(config2.getTrackFilePattern());
            this.myVariablesComponent.setEnvs(config2.getEnvVariables());
            this.myDoNotUseTestRunner.getModel().setSelected(config2.doNotUseTestRunner());
        }
    }

    public boolean isModified(DjangoFacetConfiguration configuration) {
        return !Objects.equals(this.getSettingsModule(), configuration.getSettingsFilePath()) || !Objects.equals(this.getManageScript(), configuration.getManageFilePath()) || !Objects.equals(this.getTrackFilePattern(), configuration.getTrackFilePattern()) || this.myDoNotUseTestRunner.getModel().isSelected() != configuration.doNotUseTestRunner() || !Comparing.equal((Object)this.getProjectRootFolder(), (Object)configuration.getProjectRootFolderFile()) || !Comparing.equal((Object)this.myVariablesComponent.getEnvs(), configuration.getEnvVariables());
    }

    @Nullable
    private VirtualFile getProjectRootFolder() {
        return VirtualFileUtil.findFile(this.myProjectRootFolder.getText());
    }

    public void apply(DjangoFacetConfiguration configuration) {
        configuration.setSettingsFilePath(this.getSettingsModule());
        configuration.setManageFilePath(this.getManageScript());
        configuration.setTrackFilePattern(this.getTrackFilePattern());
        configuration.setProjectRootFolderFile(this.getProjectRootFolder());
        configuration.setEnvVariables(this.myVariablesComponent.getEnvs());
        configuration.setDoNotUseTestRunner(this.myDoNotUseTestRunner.getModel().isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        ManagePyEnvironmentVariablesComponent managePyEnvironmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django-root-folder"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        this.myProjectRootFolder = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.mySettingsFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myManageFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("settings-module"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("manage-script"));
        jPanel3.add((Component)jLabel3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(8, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVariablesComponent = managePyEnvironmentVariablesComponent = new ManagePyEnvironmentVariablesComponent();
        jPanel3.add((Component)((Object)managePyEnvironmentVariablesComponent), new GridConstraints(5, 2, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.manage.py.env.settings"));
        jPanel3.add((Component)jLabel4, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(193, 14), null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.manage.py"));
        jPanel3.add((Component)titledSeparator, new GridConstraints(3, 0, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myErrorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.settings.dont.use.testrunner"));
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDoNotUseTestRunner = jBCheckBox = new JBCheckBox();
        jPanel3.add((Component)jBCheckBox, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoSettingsPanel.class).getString("django.settings.folder.pattern"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPlaceForFilesPattern = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridConstraints(6, 2, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/facet/DjangoSettingsPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackFilePattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/facet/DjangoSettingsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathRelativeToDjangoRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackFilePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateSettingsFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateManageFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDescriptorAndField";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTrackFilePattern";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRelativePathToField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    static class TextFieldRootRelativePathAccessor
    implements TextComponentAccessor<JTextField> {
        private VirtualFile myRoot;

        TextFieldRootRelativePathAccessor() {
        }

        public void setRoot(@NotNull VirtualFile root) {
            if (root == null) {
                TextFieldRootRelativePathAccessor.$$$reportNull$$$0(0);
            }
            this.myRoot = root;
        }

        public String getText(JTextField textField) {
            return this.myRoot == null ? textField.getText() : VirtualFileUtil.getAbsolutePath(this.myRoot, textField.getText());
        }

        public void setText(JTextField textField, @NotNull String text2) {
            if (text2 == null) {
                TextFieldRootRelativePathAccessor.$$$reportNull$$$0(1);
            }
            String path2 = this.myRoot == null ? text2 : VirtualFileUtil.getRelativePath(this.myRoot, text2);
            textField.setText(FileUtil.toSystemDependentName((String)path2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/facet/DjangoSettingsPanel$TextFieldRootRelativePathAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

