/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.ref;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jinja.ref.TypedReference;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.psi.Jinja2TemplateElementTypes;
import com.intellij.jinja.template.psi.impl.Jinja2MemberExpressionImpl;
import com.intellij.jinja.template.psi.impl.Jinja2MemberNameImpl;
import com.intellij.jinja.template.psi.impl.Jinja2VariableReferenceImpl;
import com.intellij.jinja.util.Jinja2PsiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.QualifiedName;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.ref.VariableReference;
import com.jetbrains.python.BaseReference;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoQualifiedMemberReference
extends BaseReference
implements TypedReference,
CachedValueProvider<Ref<PsiElement>> {
    @NotNull
    private final Jinja2MemberNameImpl myMember;

    public DjangoQualifiedMemberReference(@NotNull Jinja2MemberNameImpl member) {
        if (member == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)member);
        this.myMember = member;
    }

    public PsiElement resolve() {
        return (PsiElement)((Ref)CachedValuesManager.getCachedValue((PsiElement)this.myMember, (CachedValueProvider)this)).get();
    }

    @Nullable
    public CachedValueProvider.Result<Ref<PsiElement>> compute() {
        Iterator<PsiElement> iterator2 = this.resolveMulti(TypeEvalContext.deepCodeInsight((Project)this.myMember.getProject())).iterator();
        if (iterator2.hasNext()) {
            PsiElement el = iterator2.next();
            return CachedValueProvider.Result.create((Object)Ref.create((Object)el), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
        return CachedValueProvider.Result.create((Object)new Ref(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }

    public Object @NotNull [] getVariants() {
        TypeEvalContext context = TypeEvalContext.codeCompletion((Project)this.myElement.getProject(), (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)this.myElement).getContainingFile());
        PyExpression expr = this.getExpressionHook(context);
        ProcessingContext ctx2 = new ProcessingContext();
        ctx2.put(PyClassTypeImpl.CTX_SUPPRESS_PARENTHESES, (Object)Boolean.TRUE);
        boolean djangoTemplates = DjangoQualifiedMemberReference.isDjangoTemplates((PsiElement)this.myMember);
        ArrayList<Object> res = new ArrayList<Object>();
        PsiReference[] refs = this.getPrevReferences();
        if (refs != null) {
            for (PsiReference ref : refs) {
                TypedReference tr;
                PyType refType;
                if (!(ref instanceof TypedReference) || (refType = (tr = (TypedReference)ref).resolveType(context)) == null) continue;
                Object[] vars = refType.getCompletionVariants(this.getElement().getText(), (PsiElement)expr, ctx2);
                if (djangoTemplates) {
                    vars = Arrays.stream(vars).filter(o -> !(o instanceof LookupElement) || !((LookupElement)o).getLookupString().startsWith("_")).toArray();
                }
                res.addAll(Arrays.asList(vars));
            }
        }
        res.addAll(this.collectAssignedAttributes(this.myMember, (PsiElement)expr));
        Object[] objectArray = res.toArray();
        if (objectArray == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private static boolean isDjangoTemplates(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor)) == null) {
            return false;
        }
        return Objects.equals((Object)TemplatesService.getInstance(module).getTemplateLanguage(), (Object)DjangoTemplateLanguage.INSTANCE);
    }

    private Collection<PyTargetExpression> collectAssignedAttributes(@NotNull Jinja2MemberNameImpl member, @Nullable PsiElement hookElement) {
        QualifiedName qName;
        if (member == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(3);
        }
        if ((qName = this.getQualifierPath(member)) == null || hookElement == null) {
            return Collections.emptyList();
        }
        return PyQualifiedReference.collectAssignedAttributes((QualifiedName)qName, (PsiElement)hookElement);
    }

    @Override
    @Nullable
    public PyType resolveType(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(4);
        }
        PyType res = null;
        for (PsiElement member : this.resolveMulti(context)) {
            PyType type;
            if (member instanceof PyTypedElement && (type = context.getType((PyTypedElement)member)) != null) {
                res = res == null ? type : PyUnionType.union((PyType)res, (PyType)type);
            }
            if (!(member instanceof PyFunction)) continue;
            return PyTargetExpressionImpl.getContextSensitiveType((PyFunction)((PyFunction)member), (TypeEvalContext)context, null);
        }
        return res;
    }

    public List<PsiElement> resolveMulti(TypeEvalContext context) {
        ArrayList<PsiElement> res = new ArrayList<PsiElement>();
        PsiReference[] refs = this.getPrevReferences();
        if (refs != null) {
            for (PsiReference ref : refs) {
                TypedReference tr;
                PyType typeRef;
                if (!(ref instanceof TypedReference) || (typeRef = (tr = (TypedReference)ref).resolveType(context)) == null) continue;
                PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
                List members = typeRef.resolveMember(this.getElement().getText(), null, AccessDirection.READ, resolveContext);
                if (members == null) continue;
                for (RatedResolveResult member : members) {
                    res.add(member.getElement());
                }
            }
        }
        for (PyExpression pyExpression : this.collectAssignedAttributes(this.myMember, (PsiElement)this.getExpressionHook(context))) {
            if (!PythonStringUtil.getLastSuffix((String)pyExpression.getText(), (String)".").equals(this.getElement().getText())) continue;
            res.add((PsiElement)pyExpression);
        }
        return res;
    }

    public PsiReference @Nullable [] getPrevReferences() {
        PsiElement prevSibling = this.getElement().getPrevSibling();
        if (prevSibling != null && ".".equals(prevSibling.getText())) {
            PsiElement el = prevSibling.getPrevSibling();
            if (el instanceof Jinja2VariableReferenceImpl || el instanceof Jinja2MemberNameImpl) {
                return el.getReferences();
            }
            if (el instanceof Jinja2MemberExpressionImpl && el.getLastChild() != null) {
                return el.getLastChild().getReferences();
            }
        }
        return null;
    }

    public static boolean isVariableMember(Jinja2MemberNameImpl djangoMemberName) {
        return DjangoQualifiedMemberReference.getVariableReference(djangoMemberName) != null;
    }

    @Nullable
    public static Jinja2VariableReferenceImpl getVariableReference(Jinja2MemberNameImpl djangoMemberName) {
        PsiElement psiElement = djangoMemberName.getParent();
        if (psiElement instanceof Jinja2MemberExpressionImpl) {
            Jinja2MemberExpressionImpl memberExpression = (Jinja2MemberExpressionImpl)psiElement;
            return DjangoQualifiedMemberReference.getVariableReference(memberExpression);
        }
        return null;
    }

    @Nullable
    public static Jinja2VariableReferenceImpl getVariableReference(Jinja2MemberExpressionImpl memberExpression) {
        if (memberExpression.getNode().getFirstChildNode().getElementType() == Jinja2TemplateElementTypes.VAR) {
            return (Jinja2VariableReferenceImpl)memberExpression.getNode().getFirstChildNode().getPsi();
        }
        if (memberExpression.getNode().getFirstChildNode() instanceof Jinja2MemberExpressionImpl) {
            return DjangoQualifiedMemberReference.getVariableReference((Jinja2MemberExpressionImpl)memberExpression.getNode().getFirstChildNode());
        }
        return null;
    }

    @Nullable
    private PyExpression getExpressionHook(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoQualifiedMemberReference.$$$reportNull$$$0(5);
        }
        Set<NavigatablePsiElement> refs = DjangoTemplateManager.getTemplateReferences(Jinja2PsiUtil.Companion.getFile(this.getElement()), PyExpression.class, context);
        for (NavigatablePsiElement ref : refs) {
            if (!(ref instanceof PyExpression)) continue;
            return (PyExpression)ref;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private QualifiedName getQualifierPath(Jinja2MemberNameImpl member) {
        Jinja2MemberNameImpl el;
        ArrayList res = new ArrayList();
        PsiElement psiElement = this.myMember.getParent();
        if (psiElement instanceof Jinja2MemberExpressionImpl) {
            Jinja2MemberExpressionImpl memberExpression = (Jinja2MemberExpressionImpl)psiElement;
            el = memberExpression.getFirstChild();
        } else {
            el = this.myMember;
        }
        while (el != null && el != member) {
            PsiReference ref = (PsiReference)ContainerUtil.find((Object[])el.getReferences(), it -> it instanceof VariableReference);
            if (ref instanceof VariableReference) {
                PyExpression expr = ((VariableReference)ref).resolveTypeValueExpression();
                if (!(expr instanceof PyQualifiedExpression)) return null;
                QualifiedName qualifiedName = ((PyQualifiedExpression)expr).asQualifiedName();
                if (qualifiedName != null) {
                    res.addAll(qualifiedName.getComponents());
                }
            } else if (!".".equals(el.getText())) {
                res.addAll(QualifiedName.fromDottedString((String)el.getText()).getComponents());
            }
            el = el.getNextSibling();
        }
        return QualifiedName.fromComponents(res);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/ref/DjangoQualifiedMemberReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/ref/DjangoQualifiedMemberReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplates";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignedAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionHook";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

