/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.applications;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.django.model.applications.DjangoAppConfigClassUtil;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\nJ\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/django/model/applications/DjangoUnnamedApplicationModelUtil;", "", "<init>", "()V", "createFromFileInsideApp", "Lcom/jetbrains/django/model/applications/DjangoUnnamedApplicationModel;", "psiFile", "Lcom/intellij/psi/PsiFile;", "isApplicationRootFolder", "", "Lcom/intellij/psi/PsiDirectory;", "evaluateRelativePathFromAppRoot", "Ljava/nio/file/Path;", "djangoRoot", "transformToApplicationModel", "Lcom/jetbrains/django/model/applications/DjangoApplicationModel;", "intellij.django.core"})
public final class DjangoUnnamedApplicationModelUtil {
    @NotNull
    public static final DjangoUnnamedApplicationModelUtil INSTANCE = new DjangoUnnamedApplicationModelUtil();

    private DjangoUnnamedApplicationModelUtil() {
    }

    @Nullable
    public final DjangoUnnamedApplicationModel createFromFileInsideApp(@NotNull PsiFile psiFile) {
        PsiDirectory currentDirectory;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        for (currentDirectory = psiFile.getParent(); currentDirectory != null && !this.isApplicationRootFolder(currentDirectory); currentDirectory = currentDirectory.getParent()) {
        }
        if (currentDirectory == null) {
            return null;
        }
        return new DjangoUnnamedApplicationModel(currentDirectory);
    }

    private final boolean isApplicationRootFolder(PsiDirectory $this$isApplicationRootFolder) {
        return DjangoAppConfigClassUtil.getAppConfigFileFromApplicationRootFolder($this$isApplicationRootFolder) != null;
    }

    @Nullable
    public final Path evaluateRelativePathFromAppRoot(@NotNull PsiFile psiFile, @NotNull PsiDirectory djangoRoot) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)djangoRoot, (String)"djangoRoot");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)djangoRoot.getVirtualFile());
        if (string == null) {
            return null;
        }
        String relativePath = string;
        Path path2 = Paths.get(relativePath, new String[0]);
        if (path2.getNameCount() <= 0) {
            return null;
        }
        return path2;
    }

    @NotNull
    public final DjangoApplicationModel transformToApplicationModel(@NotNull DjangoUnnamedApplicationModel $this$transformToApplicationModel) {
        Intrinsics.checkNotNullParameter((Object)$this$transformToApplicationModel, (String)"<this>");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeInsightFallback((Project)$this$transformToApplicationModel.getApplicationRootFolder().getProject());
        DjangoAppConfig djangoAppConfig = DjangoAppConfigClassUtil.getAppConfigFromApplicationRootFolder($this$transformToApplicationModel.getApplicationRootFolder(), typeEvalContext);
        if (djangoAppConfig == null) {
            String string = $this$transformToApplicationModel.getApplicationRootFolder().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            djangoAppConfig = DjangoAppConfig.Companion.createFromQualifiedName(string);
        }
        DjangoAppConfig appConfig = djangoAppConfig;
        return new DjangoApplicationModel(appConfig, $this$transformToApplicationModel.getApplicationRootFolder());
    }
}

