/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.nio.ByteBuffer;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TEndpointTransport;
import org.apache.thrift.transport.TTransportException;

public class TMemoryTransport
extends TEndpointTransport {
    private final ByteBuffer inputBuffer;
    private final TByteArrayOutputStream outputBuffer;

    public TMemoryTransport(byte[] input) throws TTransportException {
        super(new TConfiguration());
        this.inputBuffer = ByteBuffer.wrap(input);
        this.outputBuffer = new TByteArrayOutputStream(1024);
        this.updateKnownMessageSize(input.length);
    }

    public TMemoryTransport(TConfiguration config2, byte[] input) throws TTransportException {
        super(config2);
        this.inputBuffer = ByteBuffer.wrap(input);
        this.outputBuffer = new TByteArrayOutputStream(1024);
        this.updateKnownMessageSize(input.length);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        this.checkReadBytesAvailable(len);
        int remaining = this.inputBuffer.remaining();
        if (remaining < len) {
            throw new TTransportException(4, "There's only " + remaining + "bytes, but it asks for " + len);
        }
        this.inputBuffer.get(buf, off, len);
        return len;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.outputBuffer.write(buf, off, len);
    }

    public TByteArrayOutputStream getOutput() {
        return this.outputBuffer;
    }
}

