/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.PieAnnotation;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 Q2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004QRSTB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010$\u001a\u00020%2\n\u0010&\u001a\u00060'R\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0002J0\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014J\u0014\u00105\u001a\u0002062\n\u0010&\u001a\u00060'R\u00020\u0000H\u0002J\u0014\u00107\u001a\u0002062\n\u0010&\u001a\u00060'R\u00020\u0000H\u0002J0\u00108\u001a\b\u0012\u0004\u0012\u000206092\u0010\u0010:\u001a\f\u0012\b\u0012\u00060'R\u00020\u0000092\u0006\u0010;\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u0016H\u0002J>\u0010=\u001a\f\u0012\b\u0012\u00060'R\u00020\u0000092\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?092\u0014\u0010@\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0006\u0012\u0004\u0018\u00010B0A2\u0006\u0010C\u001a\u00020\u0006H\u0002J \u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020?2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00060HH\u0002J0\u0010I\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020?2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00060H2\u0006\u0010J\u001a\u00020\u00062\u0006\u0010K\u001a\u00020LH\u0016J0\u0010M\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020?2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00060H2\u0006\u0010J\u001a\u00020\u00062\u0006\u0010K\u001a\u00020LH\u0016J\u0018\u0010N\u001a\u00020%*\u00020O2\n\u0010&\u001a\u00060'R\u00020\u0000H\u0002J\u0018\u0010P\u001a\u00020%*\u00020O2\n\u0010&\u001a\u00060'R\u00020\u0000H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\b\"\u0004\b\u001d\u0010\nR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006U"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "holeSize", "", "getHoleSize", "()D", "setHoleSize", "(D)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "sizeUnit", "", "getSizeUnit", "()Ljava/lang/String;", "setSizeUnit", "(Ljava/lang/String;)V", "spacerColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getSpacerColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "setSpacerColor", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "spacerWidth", "getSpacerWidth", "setSpacerWidth", "strokeSide", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "getStrokeSide", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "setStrokeSide", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;)V", "buildHint", "", "sector", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Sector;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "buildIntern", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildSvgArcs", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "buildSvgSector", "buildSvgSpacerLines", "", "pieSectors", "width", "color", "computeSectors", "dataPoints", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "toLocation", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "sizeUnitRatio", "dimensionSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "heightSpan", "resolution", "isDiscrete", "", "widthSpan", "svgInnerArc", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "svgOuterArc", "Companion", "PieLegendKeyElementFactory", "Sector", "StrokeSide", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPieGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1477#2:395\n1502#2,3:396\n1505#2,3:406\n1549#2:410\n1620#2,3:411\n1549#2:414\n1620#2,3:415\n1855#2,2:418\n1569#2,11:422\n1864#2,2:433\n1866#2:436\n1580#2:437\n1559#2:438\n1590#2,4:439\n1603#2,9:443\n1855#2:452\n1856#2:454\n1612#2:455\n372#3,7:399\n215#4:409\n216#4:421\n1#5:420\n1#5:435\n1#5:453\n*S KotlinDebug\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom\n*L\n63#1:395\n63#1:396,3\n63#1:406,3\n72#1:410\n72#1:411,3\n73#1:414\n73#1:415,3\n80#1:418,2\n167#1:422,11\n167#1:433,2\n167#1:436\n167#1:437\n183#1:438\n183#1:439,4\n247#1:443,9\n247#1:452\n247#1:454\n247#1:455\n63#1:399,7\n64#1:409\n64#1:421\n167#1:435\n247#1:453\n*E\n"})
public final class PieGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double holeSize;
    private double spacerWidth = 0.75;
    @NotNull
    private Color spacerColor = Color.Companion.getWHITE();
    @NotNull
    private StrokeSide strokeSide = StrokeSide.BOTH;
    @Nullable
    private String sizeUnit;
    public static final boolean HANDLES_GROUPS = false;

    public final double getHoleSize() {
        return this.holeSize;
    }

    public final void setHoleSize(double d) {
        this.holeSize = d;
    }

    public final double getSpacerWidth() {
        return this.spacerWidth;
    }

    public final void setSpacerWidth(double d) {
        this.spacerWidth = d;
    }

    @NotNull
    public final Color getSpacerColor() {
        return this.spacerColor;
    }

    public final void setSpacerColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.spacerColor = color;
    }

    @NotNull
    public final StrokeSide getStrokeSide() {
        return this.strokeSide;
    }

    public final void setStrokeSide(@NotNull StrokeSide strokeSide) {
        Intrinsics.checkNotNullParameter((Object)((Object)strokeSide), (String)"<set-?>");
        this.strokeSide = strokeSide;
    }

    @Nullable
    public final String getSizeUnit() {
        return this.sizeUnit;
    }

    public final void setSizeUnit(@Nullable String string) {
        this.sizeUnit = string;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new PieLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$forEach$iv;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getSLICE());
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = p.y();
            Intrinsics.checkNotNull((Object)d3);
            DoubleVector key$iv$iv = new DoubleVector(d2, d3);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Sector p0;
            Collection<LinePath> collection;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            double d;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            DoubleVector point2 = (DoubleVector)entry.getKey();
            List dataPoints2 = (List)entry.getValue();
            if (this.sizeUnit == null) {
                d = 1.0;
            } else {
                String string = this.sizeUnit;
                Intrinsics.checkNotNull((Object)string);
                d = PieGeom.Companion.getSizeUnitRatio(point2, coord, string);
            }
            double sizeUnitRatio = d;
            Function1 toLocation2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(geomHelper, point2){
                final /* synthetic */ GeomHelper $geomHelper;
                final /* synthetic */ DoubleVector $point;
                {
                    this.$geomHelper = $geomHelper;
                    this.$point = $point;
                    super(1);
                }

                @Nullable
                public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    return this.$geomHelper.toClient(this.$point, p);
                }
            };
            List<Sector> pieSectors = this.computeSectors(dataPoints2, (Function1<? super DataPointAesthetics, DoubleVector>)toLocation2, sizeUnitRatio);
            value$iv$iv$iv = pieSectors;
            SvgRoot svgRoot = root;
            GeomBase.Companion companion = GeomBase.Companion;
            boolean $i$f$map = false;
            void var23_28 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                item$iv$iv = iterator3.next();
                Sector sector = (Sector)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(this.buildSvgSector(p0));
            }
            collection = (List)destination$iv$iv2;
            companion.appendNodes(svgRoot, (List<LinePath>)collection);
            $this$map$iv = pieSectors;
            svgRoot = root;
            companion = GeomBase.Companion;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                item$iv$iv = iterator3.next();
                p0 = (Sector)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(this.buildSvgArcs(p0));
            }
            collection = (List)destination$iv$iv2;
            companion.appendNodes(svgRoot, (List<LinePath>)collection);
            if (this.spacerWidth > 0.0) {
                GeomBase.Companion.appendNodes(root, this.buildSvgSpacerLines(pieSectors, this.spacerWidth, this.spacerColor));
            }
            Iterable $this$forEach$iv2 = pieSectors;
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv.next();
                Sector it = (Sector)element$iv2;
                boolean bl5 = false;
                this.buildHint(it, ctx2.getTargetCollector());
            }
            if (ctx2.getAnnotation() == null) continue;
            boolean bl6 = false;
            PieAnnotation.INSTANCE.build(root, pieSectors, ctx2);
        }
    }

    private final void svgOuterArc(SvgPathDataBuilder $this$svgOuterArc, Sector sector) {
        Sector $this$svgOuterArc_u24lambda_u245 = sector;
        boolean bl = false;
        $this$svgOuterArc.ellipticalArc($this$svgOuterArc_u24lambda_u245.getRadius(), $this$svgOuterArc_u24lambda_u245.getRadius(), 0.0, $this$svgOuterArc_u24lambda_u245.getAngle() > Math.PI, true, $this$svgOuterArc_u24lambda_u245.getOuterArcEnd());
    }

    private final void svgInnerArc(SvgPathDataBuilder $this$svgInnerArc, Sector sector) {
        Sector $this$svgInnerArc_u24lambda_u246 = sector;
        boolean bl = false;
        $this$svgInnerArc.ellipticalArc($this$svgInnerArc_u24lambda_u246.getHoleRadius(), $this$svgInnerArc_u24lambda_u246.getHoleRadius(), 0.0, $this$svgInnerArc_u24lambda_u246.getAngle() > Math.PI, false, $this$svgInnerArc_u24lambda_u246.getInnerArcStart());
    }

    private final LinePath buildSvgSector(Sector sector) {
        Object object = new SvgPathDataBuilder(false, 1, null);
        SvgPathDataBuilder $this$buildSvgSector_u24lambda_u247 = object;
        boolean bl = false;
        $this$buildSvgSector_u24lambda_u247.moveTo(sector.getInnerArcStart());
        $this$buildSvgSector_u24lambda_u247.lineTo(sector.getOuterArcStart());
        this.svgOuterArc($this$buildSvgSector_u24lambda_u247, sector);
        $this$buildSvgSector_u24lambda_u247.lineTo(sector.getInnerArcEnd());
        this.svgInnerArc($this$buildSvgSector_u24lambda_u247, sector);
        SvgPathDataBuilder svgPathDataBuilder = object;
        Object $this$buildSvgSector_u24lambda_u248 = object = new LinePath(svgPathDataBuilder);
        boolean bl2 = false;
        Color color = sector.getP().fill();
        Intrinsics.checkNotNull((Object)color);
        Color fill2 = color;
        double fillAlpha = AestheticsUtil.INSTANCE.alpha(fill2, sector.getP());
        ((LinePath)$this$buildSvgSector_u24lambda_u248).fill().set(Colors.INSTANCE.withOpacity(fill2, fillAlpha));
        return object;
    }

    private final LinePath buildSvgArcs(Sector sector) {
        Object object = new SvgPathDataBuilder(false, 1, null);
        SvgPathDataBuilder $this$buildSvgArcs_u24lambda_u249 = object;
        boolean bl = false;
        if (this.strokeSide.getHasOuter()) {
            $this$buildSvgArcs_u24lambda_u249.moveTo(sector.getOuterArcStart());
            this.svgOuterArc($this$buildSvgArcs_u24lambda_u249, sector);
        }
        if (this.strokeSide.getHasInner()) {
            $this$buildSvgArcs_u24lambda_u249.moveTo(sector.getInnerArcEnd());
            this.svgInnerArc($this$buildSvgArcs_u24lambda_u249, sector);
        }
        SvgPathDataBuilder svgPathDataBuilder = object;
        Object $this$buildSvgArcs_u24lambda_u2410 = object = new LinePath(svgPathDataBuilder);
        boolean bl2 = false;
        ((LinePath)$this$buildSvgArcs_u24lambda_u2410).width().set(sector.getStrokeWidth());
        ((LinePath)$this$buildSvgArcs_u24lambda_u2410).color().set(sector.getP().color());
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LinePath> buildSvgSpacerLines(List<Sector> pieSectors, double width2, Color color) {
        void $this$mapIndexedTo$iv$iv;
        int n;
        Iterable $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = pieSectors;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Integer it$iv$iv;
            void sector;
            void element$iv$iv;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            Sector sector2 = (Sector)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            Integer n2 = index;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            if ((!Intrinsics.areEqual((Object)sector.getPosition(), (Object)sector.getPieCenter()) ? n2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List explodedSectors = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv = pieSectors;
        boolean $i$f$mapIndexed = false;
        $this$mapIndexedNotNullTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void sector;
            int n3;
            Object item$iv$iv$iv;
            if ((n3 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv$iv = (Sector)item$iv$iv;
            n = n3;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PieGeom.buildSvgSpacerLines$svgSpacerLines(width2, color, (Sector)sector, PieGeom.buildSvgSpacerLines$needAddAtStart(explodedSectors, pieSectors, (int)index), PieGeom.buildSvgSpacerLines$needAddAtEnd(explodedSectors, pieSectors, (int)index)));
        }
        return (List)destination$iv$iv;
    }

    private final void buildHint(Sector sector, GeomTargetCollector targetCollector) {
        List list2 = CollectionsKt.plus((Collection)PieGeom.buildHint$resampleArc(sector, true), (Iterable)CollectionsKt.reversed((Iterable)PieGeom.buildHint$resampleArc(sector, false)));
        int n = sector.getP().index();
        Color color = sector.getP().fill();
        Intrinsics.checkNotNull((Object)color);
        Double d = sector.getP().alpha();
        Intrinsics.checkNotNull((Object)d);
        GeomTargetCollector.DefaultImpls.addPolygon$default(targetCollector, list2, n, new GeomTargetCollector.TooltipParams(null, null, null, CollectionsKt.listOf((Object)HintColorUtil.INSTANCE.applyAlpha(color, d)), 7, null), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Sector> computeSectors(List<? extends DataPointAesthetics> dataPoints2, Function1<? super DataPointAesthetics, DoubleVector> toLocation2, double sizeUnitRatio) {
        void $this$mapNotNullTo$iv$iv;
        Iterable iterable = dataPoints2;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            DataPointAesthetics dataPointAesthetics = (DataPointAesthetics)t;
            double d2 = d;
            boolean bl = false;
            Double d3 = it.slice();
            Intrinsics.checkNotNull((Object)d3);
            double d4 = Math.abs(d3);
            d = d2 + d4;
        }
        double sum2 = d;
        double currentAngle = 0.0;
        currentAngle = -1.5707963267948966;
        currentAngle -= PieGeom.computeSectors$angle(sum2, dataPoints2, (DataPointAesthetics)CollectionsKt.first(dataPoints2));
        Iterable $this$mapNotNull$iv = dataPoints2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Sector sector;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DataPointAesthetics p = (DataPointAesthetics)element$iv$iv;
            boolean bl2 = false;
            if ((DoubleVector)toLocation2.invoke((Object)p) == null) {
                sector = null;
            } else {
                DoubleVector pieCenter;
                Sector sector2;
                double d5 = currentAngle;
                double d6 = currentAngle + PieGeom.computeSectors$angle(sum2, dataPoints2, p);
                Sector sector3 = sector2 = new Sector(this, pieCenter, p, d5, d6, sizeUnitRatio);
                boolean bl3 = false;
                currentAngle = sector3.getEndAngle();
                sector = sector2;
            }
            if (sector == null) continue;
            Sector it$iv$iv = sector;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final DoubleSpan dimensionSpan(DataPointAesthetics p, Aes<Double> coordAes) {
        DoubleSpan doubleSpan;
        Double size2;
        Double loc = p.get(coordAes);
        if (SeriesUtil.INSTANCE.allFinite(loc, size2 = p.get(Aes.Companion.getSIZE()))) {
            Intrinsics.checkNotNull((Object)loc);
            Double d = size2;
            Intrinsics.checkNotNull((Object)d);
            double expand = d / 2.0;
            doubleSpan = new DoubleSpan(loc - expand, loc + expand);
        } else {
            doubleSpan = null;
        }
        return doubleSpan;
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        if (!isDiscrete) {
            return null;
        }
        return this.dimensionSpan(p, coordAes);
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        if (!isDiscrete) {
            return null;
        }
        return this.dimensionSpan(p, coordAes);
    }

    private static final LinePath buildSvgSpacerLines$svgSpacerLines(double $width, Color $color, Sector sector, boolean atStart, boolean atEnd) {
        Object object = new SvgPathDataBuilder(false, 1, null);
        SvgPathDataBuilder $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411 = object;
        boolean bl = false;
        if (atStart) {
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.moveTo(sector.getInnerStrokeStartPoint());
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.lineTo(sector.getOuterStrokeStartPoint());
        }
        if (atEnd) {
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.moveTo(sector.getInnerStrokeEndPoint());
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.lineTo(sector.getOuterStrokeEndPoint());
        }
        SvgPathDataBuilder svgPathDataBuilder = object;
        Object $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2412 = object = new LinePath(svgPathDataBuilder);
        boolean bl2 = false;
        ((LinePath)$this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2412).width().set($width);
        ((LinePath)$this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2412).color().set($color);
        return object;
    }

    private static final boolean buildSvgSpacerLines$needAddAtStart(List<Integer> explodedSectors, List<Sector> $pieSectors, int index) {
        int n = index;
        return explodedSectors.contains(n) ? false : (n == 0 ? !explodedSectors.contains(CollectionsKt.getLastIndex($pieSectors)) : !explodedSectors.contains(index - 1));
    }

    private static final boolean buildSvgSpacerLines$needAddAtEnd(List<Integer> explodedSectors, List<Sector> $pieSectors, int index) {
        int n = index;
        return explodedSectors.contains(n) ? false : (n == CollectionsKt.getLastIndex($pieSectors) ? !explodedSectors.contains(0) : !explodedSectors.contains(index + 1));
    }

    private static final List<DoubleVector> buildHint$resampleArc(Sector $sector, boolean outerArc) {
        DoubleVector doubleVector;
        DoubleVector doubleVector2;
        Function1 function1;
        boolean bl = outerArc;
        if (bl) {
            function1 = (Function1)new Function1<Double, DoubleVector>($sector){
                final /* synthetic */ Sector $sector;
                {
                    this.$sector = $sector;
                    super(1);
                }

                @NotNull
                public final DoubleVector invoke(double angle) {
                    return this.$sector.outerArcPointWithStroke(angle);
                }
            };
        } else if (!bl) {
            function1 = (Function1)new Function1<Double, DoubleVector>($sector){
                final /* synthetic */ Sector $sector;
                {
                    this.$sector = $sector;
                    super(1);
                }

                @NotNull
                public final DoubleVector invoke(double angle) {
                    return this.$sector.innerArcPointWithStroke(angle);
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function1 arcPoint2 = function1;
        boolean bl2 = outerArc;
        if (bl2) {
            doubleVector2 = $sector.getOuterStrokeStartPoint();
        } else if (!bl2) {
            doubleVector2 = $sector.getInnerStrokeStartPoint();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DoubleVector startPoint = doubleVector2;
        boolean bl3 = outerArc;
        if (bl3) {
            doubleVector = $sector.getOuterStrokeEndPoint();
        } else if (!bl3) {
            doubleVector = $sector.getInnerStrokeEndPoint();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DoubleVector endPoint = doubleVector;
        double segmentLength = startPoint.subtract(endPoint).length();
        return AdaptiveResampler.Companion.resample(startPoint, endPoint, 0.95, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>(startPoint, segmentLength, (Function1<? super Double, DoubleVector>)arcPoint2, $sector){
            final /* synthetic */ DoubleVector $startPoint;
            final /* synthetic */ double $segmentLength;
            final /* synthetic */ Function1<Double, DoubleVector> $arcPoint;
            final /* synthetic */ Sector $sector;
            {
                this.$startPoint = $startPoint;
                this.$segmentLength = $segmentLength;
                this.$arcPoint = $arcPoint;
                this.$sector = $sector;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DoubleVector p) {
                double ratio;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                double d = ratio = p.subtract(this.$startPoint).length() / this.$segmentLength;
                return !Double.isInfinite(d) && !Double.isNaN(d) ? (DoubleVector)this.$arcPoint.invoke((Object)(this.$sector.getStartAngle() + this.$sector.getAngle() * ratio)) : p;
            }
        }));
    }

    private static final double computeSectors$angle(double sum2, List<? extends DataPointAesthetics> $dataPoints, DataPointAesthetics p) {
        double d;
        if (sum2 == 0.0) {
            d = 1.0 / (double)$dataPoints.size();
        } else {
            Double d2 = p.slice();
            Intrinsics.checkNotNull((Object)d2);
            d = Math.abs(d2) / sum2;
        }
        double it = d;
        boolean bl = false;
        return Math.PI * 2 * it;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "getSizeUnitRatio", "", "p", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "axis", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final double getSizeUnitRatio(DoubleVector p, CoordinateSystem coord, String axis) {
            double d;
            DoubleVector unitSquareSize = coord.unitSize(p);
            String string = axis.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"x")) {
                d = unitSquareSize.getX();
            } else if (Intrinsics.areEqual((Object)string2, (Object)"y")) {
                d = unitSquareSize.getY();
            } else {
                throw new IllegalStateException(("Size unit value must be either 'x' or 'y', but was " + axis + '.').toString());
            }
            double unitSize = d;
            return unitSize / 10.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$PieLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;)V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "minimumKeySize", "shapeSize", "", "plot-base"})
    private final class PieLegendKeyElementFactory
    implements LegendKeyElementFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
            void $this$createKeyElement_u24lambda_u241_u24lambda_u240;
            SvgCircleElement svgCircleElement;
            SvgGElement svgGElement;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            SvgGElement $this$createKeyElement_u24lambda_u241 = svgGElement = new SvgGElement();
            boolean bl = false;
            SvgCircleElement svgCircleElement2 = svgCircleElement = new SvgCircleElement(size2.getX() / (double)2, size2.getY() / (double)2, this.shapeSize(p) / (double)2);
            ObservableList<SvgNode> observableList = $this$createKeyElement_u24lambda_u241.children();
            boolean bl2 = false;
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.fillColor().set(p.fill());
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.strokeColor().set(p.color());
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.strokeWidth().set(p.stroke());
            observableList.add(svgCircleElement);
            return svgGElement;
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            double shapeSize = this.shapeSize(p);
            double size2 = shapeSize + 4.0;
            return new DoubleVector(size2, size2);
        }

        private final double shapeSize(DataPointAesthetics p) {
            return AesScaling.INSTANCE.pieDiameter(p);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b#\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u00104\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u0011\u0010\"\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0019R\u0011\u0010+\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0019R\u0011\u0010-\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\rR\u0011\u0010/\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\rR\u0011\u00102\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\r\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Sector;", "", "pieCenter", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "startAngle", "", "endAngle", "sizeUnitRatio", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;DDD)V", "angle", "getAngle", "()D", "direction", "getDirection", "getEndAngle", "explode", "fullCircleDrawingFix", "hasVisibleStroke", "", "holeRadius", "getHoleRadius", "innerArcEnd", "getInnerArcEnd", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "innerArcStart", "getInnerArcStart", "innerStrokeEndPoint", "getInnerStrokeEndPoint", "innerStrokeStartPoint", "getInnerStrokeStartPoint", "outerArcEnd", "getOuterArcEnd", "outerArcStart", "getOuterArcStart", "outerStrokeEndPoint", "getOuterStrokeEndPoint", "outerStrokeStartPoint", "getOuterStrokeStartPoint", "getP", "()Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "getPieCenter", "position", "getPosition", "radius", "getRadius", "sectorCenter", "getSectorCenter", "getStartAngle", "strokeWidth", "getStrokeWidth", "arcPoint", "innerArcPointWithStroke", "outerArcPointWithStroke", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nPieGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Sector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
    public final class Sector {
        @NotNull
        private final DoubleVector pieCenter;
        @NotNull
        private final DataPointAesthetics p;
        private final double startAngle;
        private final double endAngle;
        private final double angle;
        private final double strokeWidth;
        private final boolean hasVisibleStroke;
        private final double radius;
        private final double holeRadius;
        private final double direction;
        private final double explode;
        @NotNull
        private final DoubleVector position;
        private final double fullCircleDrawingFix;
        @NotNull
        private final DoubleVector outerArcStart;
        @NotNull
        private final DoubleVector outerArcEnd;
        @NotNull
        private final DoubleVector innerArcStart;
        @NotNull
        private final DoubleVector innerArcEnd;
        @NotNull
        private final DoubleVector outerStrokeStartPoint;
        @NotNull
        private final DoubleVector outerStrokeEndPoint;
        @NotNull
        private final DoubleVector innerStrokeStartPoint;
        @NotNull
        private final DoubleVector innerStrokeEndPoint;
        final /* synthetic */ PieGeom this$0;

        /*
         * Unable to fully structure code
         */
        public Sector(@NotNull PieGeom this$0, @NotNull DoubleVector pieCenter, DataPointAesthetics p, double startAngle, double endAngle, double sizeUnitRatio) {
            Intrinsics.checkNotNullParameter((Object)pieCenter, (String)"pieCenter");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            this.this$0 = this$0;
            super();
            this.pieCenter = pieCenter;
            this.p = p;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
            this.angle = this.endAngle - this.startAngle;
            v0 = this;
            v1 = this.p.stroke();
            if (v1 == null) ** GOTO lbl-1000
            var10_7 = v1;
            var11_8 = ((Number)var10_7).doubleValue();
            var15_9 = v0;
            $i$a$-takeIf-PieGeom$Sector$strokeWidth$1 = false;
            v2 = this.p.color();
            var16_11 = (v2 != null ? v2.getAlpha() == 0 : false) == false;
            v0 = var15_9;
            v1 = var16_11 != false ? var10_7 : null;
            if (v1 != null) {
                v3 = v1;
            } else lbl-1000:
            // 2 sources

            {
                v3 = 0.0;
            }
            v0.strokeWidth = v3;
            this.hasVisibleStroke = this.strokeWidth > 0.0;
            this.radius = sizeUnitRatio * AesScaling.INSTANCE.pieDiameter(this.p) / (double)2;
            this.holeRadius = this.radius * this.this$0.getHoleSize();
            this.direction = this.startAngle + this.angle / (double)2;
            v4 = this;
            v5 = this.p.explode();
            if (v5 != null) {
                var12_13 = ((Number)v5).doubleValue();
                var15_9 = v4;
                $i$a$-let-PieGeom$Sector$explode$1 = false;
                var16_12 = this.radius * it;
                v4 = var15_9;
                v6 = var16_12;
            } else {
                v6 = 0.0;
            }
            v4.explode = v6;
            this.position = this.pieCenter.add(new DoubleVector(this.explode * Math.cos(this.direction), this.explode * Math.sin(this.direction)));
            this.fullCircleDrawingFix = this.angle % 6.283185307179586 == 0.0 != false ? 1.0E-4 : 0.0;
            this.outerArcStart = this.arcPoint(this.radius, this.startAngle);
            this.outerArcEnd = this.arcPoint(this.radius, this.endAngle - this.fullCircleDrawingFix);
            this.innerArcStart = this.arcPoint(this.holeRadius, this.startAngle);
            this.innerArcEnd = this.arcPoint(this.holeRadius, this.endAngle - this.fullCircleDrawingFix);
            this.outerStrokeStartPoint = this.outerArcPointWithStroke(this.startAngle);
            this.outerStrokeEndPoint = this.outerArcPointWithStroke(this.endAngle - this.fullCircleDrawingFix);
            this.innerStrokeStartPoint = this.innerArcPointWithStroke(this.startAngle);
            this.innerStrokeEndPoint = this.innerArcPointWithStroke(this.endAngle - this.fullCircleDrawingFix);
        }

        @NotNull
        public final DoubleVector getPieCenter() {
            return this.pieCenter;
        }

        @NotNull
        public final DataPointAesthetics getP() {
            return this.p;
        }

        public final double getStartAngle() {
            return this.startAngle;
        }

        public final double getEndAngle() {
            return this.endAngle;
        }

        public final double getAngle() {
            return this.angle;
        }

        public final double getStrokeWidth() {
            return this.strokeWidth;
        }

        public final double getRadius() {
            return this.radius;
        }

        public final double getHoleRadius() {
            return this.holeRadius;
        }

        public final double getDirection() {
            return this.direction;
        }

        @NotNull
        public final DoubleVector getPosition() {
            return this.position;
        }

        @NotNull
        public final DoubleVector getOuterArcStart() {
            return this.outerArcStart;
        }

        @NotNull
        public final DoubleVector getOuterArcEnd() {
            return this.outerArcEnd;
        }

        @NotNull
        public final DoubleVector getInnerArcStart() {
            return this.innerArcStart;
        }

        @NotNull
        public final DoubleVector getInnerArcEnd() {
            return this.innerArcEnd;
        }

        @NotNull
        public final DoubleVector getOuterStrokeStartPoint() {
            return this.outerStrokeStartPoint;
        }

        @NotNull
        public final DoubleVector getOuterStrokeEndPoint() {
            return this.outerStrokeEndPoint;
        }

        @NotNull
        public final DoubleVector getInnerStrokeStartPoint() {
            return this.innerStrokeStartPoint;
        }

        @NotNull
        public final DoubleVector getInnerStrokeEndPoint() {
            return this.innerStrokeEndPoint;
        }

        @NotNull
        public final DoubleVector outerArcPointWithStroke(double angle) {
            double d;
            boolean bl;
            boolean bl2 = bl = this.this$0.getStrokeSide().getHasOuter() && this.hasVisibleStroke;
            if (bl) {
                d = this.radius + this.strokeWidth / (double)2;
            } else if (!bl) {
                d = this.radius;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return this.arcPoint(d, angle);
        }

        @NotNull
        public final DoubleVector innerArcPointWithStroke(double angle) {
            double d;
            boolean bl;
            boolean bl2 = bl = this.this$0.getStrokeSide().getHasInner() && this.hasVisibleStroke && this.this$0.getHoleSize() > 0.0;
            if (bl) {
                d = this.holeRadius - this.strokeWidth / (double)2;
            } else if (!bl) {
                d = this.holeRadius;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return this.arcPoint(d, angle);
        }

        private final DoubleVector arcPoint(double radius, double angle) {
            return this.position.add(new DoubleVector(radius * Math.cos(angle), radius * Math.sin(angle)));
        }

        @NotNull
        public final DoubleVector getSectorCenter() {
            double offset2 = this.holeRadius + 0.5 * (this.radius - this.holeRadius);
            return this.arcPoint(offset2, this.direction);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "", "(Ljava/lang/String;I)V", "hasInner", "", "getHasInner", "()Z", "hasOuter", "getHasOuter", "OUTER", "INNER", "BOTH", "plot-base"})
    public static final class StrokeSide
    extends Enum<StrokeSide> {
        public static final /* enum */ StrokeSide OUTER = new StrokeSide();
        public static final /* enum */ StrokeSide INNER = new StrokeSide();
        public static final /* enum */ StrokeSide BOTH = new StrokeSide();
        private static final /* synthetic */ StrokeSide[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean getHasOuter() {
            return this == OUTER || this == BOTH;
        }

        public final boolean getHasInner() {
            return this == INNER || this == BOTH;
        }

        public static StrokeSide[] values() {
            return (StrokeSide[])$VALUES.clone();
        }

        public static StrokeSide valueOf(String value2) {
            return Enum.valueOf(StrokeSide.class, value2);
        }

        @NotNull
        public static EnumEntries<StrokeSide> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = strokeSideArray = new StrokeSide[]{StrokeSide.OUTER, StrokeSide.INNER, StrokeSide.BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

