/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.facet.FacetGrid;
import org.jetbrains.letsPlot.core.plot.builder.assemble.facet.FacetScales;
import org.jetbrains.letsPlot.core.plot.builder.assemble.facet.FacetWrap;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u001c\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/FacetConfig;", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "options", "", "", "", "superscriptExponent", "", "(Ljava/util/Map;Z)V", "createFacets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "dataByLayer", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "createGrid", "createWrap", "getDirOption", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/facet/FacetWrap$Direction;", "getFormatterOption", "Lkotlin/Function1;", "optionName", "getLabWidthOption", "", "getOrderOption", "getScalesOption", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/facet/FacetScales;", "toFormatterVal", "optionVal", "toOrderVal", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nFacetConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetConfig.kt\norg/jetbrains/letsPlot/core/spec/config/FacetConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1549#2:188\n1620#2,3:189\n1549#2:193\n1620#2,3:194\n1549#2:197\n1620#2,3:198\n1#3:192\n*S KotlinDebug\n*F\n+ 1 FacetConfig.kt\norg/jetbrains/letsPlot/core/spec/config/FacetConfig\n*L\n103#1:188\n103#1:189,3\n110#1:193\n110#1:194,3\n117#1:197\n117#1:198,3\n*E\n"})
public final class FacetConfig
extends OptionsAccessor {
    private final boolean superscriptExponent;

    public FacetConfig(@NotNull Map<String, ? extends Object> options, boolean superscriptExponent) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        super(options, null, 2, null);
        this.superscriptExponent = superscriptExponent;
    }

    @NotNull
    public final PlotFacets createFacets(@NotNull List<DataFrame> dataByLayer) {
        PlotFacets plotFacets;
        Intrinsics.checkNotNullParameter(dataByLayer, (String)"dataByLayer");
        String name = this.getStringSafe("name");
        if (Intrinsics.areEqual((Object)name, (Object)"grid")) {
            plotFacets = this.createGrid(dataByLayer);
        } else if (Intrinsics.areEqual((Object)name, (Object)"wrap")) {
            plotFacets = this.createWrap(dataByLayer);
        } else {
            throw new IllegalArgumentException("Facet 'grid' or 'wrap' expected but was: `" + name + '`');
        }
        return plotFacets;
    }

    private final PlotFacets createGrid(List<DataFrame> dataByLayer) {
        String nameX = null;
        LinkedHashSet levelsX = new LinkedHashSet();
        if (this.has("x")) {
            nameX = this.getStringSafe("x");
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, nameX)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameX);
                levelsX.addAll(data.distinctValues(variable));
            }
        }
        String nameY = null;
        LinkedHashSet levelsY = new LinkedHashSet();
        if (this.has("y")) {
            nameY = this.getStringSafe("y");
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, nameY)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameY);
                levelsY.addAll(data.distinctValues(variable));
            }
        }
        FacetScales scales = this.getScalesOption();
        return new FacetGrid(nameX, nameY, new ArrayList(levelsX), new ArrayList(levelsY), this.getOrderOption("x_order"), this.getOrderOption("y_order"), this.getFormatterOption("x_format"), this.getFormatterOption("y_format"), scales, this.getLabWidthOption("x_labwidth"), this.getLabWidthOption("y_labwidth"));
    }

    /*
     * WARNING - void declaration
     */
    private final PlotFacets createWrap(List<DataFrame> dataByLayer) {
        void $this$mapTo$iv$iv;
        Iterator it4;
        ArrayList $this$mapTo$iv$iv2;
        ArrayList<Integer> arrayList;
        Iterator it22;
        Collection collection;
        ArrayList<Integer> $this$mapTo$iv$iv3;
        List<String> facets = this.getAsStringList("facets");
        Integer ncol = this.getInteger("ncol");
        Integer nrow = this.getInteger("nrow");
        ArrayList<List> facetLevels = new ArrayList<List>();
        for (String name : facets) {
            LinkedHashSet levels = new LinkedHashSet();
            for (DataFrame data : dataByLayer) {
                if (!DataFrameUtil.INSTANCE.hasVariable(data, name)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, name);
                levels.addAll(data.distinctValues(variable));
            }
            facetLevels.add(CollectionsKt.toList((Iterable)levels));
        }
        Iterable $this$map$iv = this.getAsList("order");
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo22 = 0;
        Iterator iterator2 = $this$mapTo$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv22;
            boolean bl = false;
            collection.add(this.toOrderVal(it22));
        }
        List orderOption = (List)destination$iv$iv22;
        $i$f$map = facets.size();
        collection = orderOption;
        $this$mapTo$iv$iv3 = new ArrayList<Integer>($i$f$map);
        int destination$iv$iv22 = 0;
        while (destination$iv$iv22 < $i$f$map) {
            int n = $i$f$mapTo22 = destination$iv$iv22++;
            arrayList = $this$mapTo$iv$iv3;
            boolean bl = false;
            arrayList.add(0);
        }
        List ordering = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)$this$mapTo$iv$iv3), (int)facets.size());
        Iterable $this$map$iv2 = this.getAsList("format");
        int $i$f$map2 = 0;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        int $i$f$mapTo32 = 0;
        it22 = $this$mapTo$iv$iv2.iterator();
        while (it22.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = it22.next();
            collection = destination$iv$iv32;
            boolean bl = false;
            collection.add(this.toFormatterVal(it4));
        }
        List formatterOption = (List)destination$iv$iv32;
        $i$f$map2 = facets.size();
        collection = formatterOption;
        $this$mapTo$iv$iv2 = new ArrayList($i$f$map2);
        int destination$iv$iv32 = 0;
        while (destination$iv$iv32 < $i$f$map2) {
            int it22 = $i$f$mapTo32 = destination$iv$iv32++;
            arrayList = $this$mapTo$iv$iv2;
            boolean bl = false;
            arrayList.add((Integer)PlotFacets.Companion.getDEF_FORMATTER());
        }
        List formatters = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)$this$mapTo$iv$iv2), (int)facets.size());
        Iterable $this$map$iv3 = this.getAsList("labwidth");
        int $i$f$map3 = 0;
        Iterable $i$f$mapTo32 = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        it4 = $this$mapTo$iv$iv.iterator();
        while (it4.hasNext()) {
            void it3;
            Object item$iv$iv;
            Object t = item$iv$iv = it4.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Number number = it3 instanceof Number ? (Number)((Number)it3) : (Number)null;
            collection.add(number != null ? number.intValue() : -1);
        }
        List labWidthOption = (List)destination$iv$iv;
        $i$f$map3 = facets.size();
        collection = labWidthOption;
        ArrayList arrayList2 = new ArrayList($i$f$map3);
        int n = 0;
        while (n < $i$f$map3) {
            int n2;
            int it4 = n2 = n++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(-1);
        }
        List labWidths = CollectionsKt.take((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)arrayList2), (int)facets.size());
        FacetScales scales = this.getScalesOption();
        return new FacetWrap(facets, (List<? extends List<? extends Object>>)facetLevels, nrow, ncol, this.getDirOption(), ordering, formatters, scales, labWidths);
    }

    private final int getOrderOption(String optionName) {
        return this.toOrderVal(this.get(optionName));
    }

    private final int toOrderVal(Object optionVal) {
        int n;
        Object object = optionVal;
        if (object == null) {
            n = 0;
        } else if (object instanceof Number) {
            n = ((Number)optionVal).intValue();
        } else {
            throw new IllegalArgumentException("Unsupported `order` value: " + optionVal + ".\nUse: 1 (natural), -1 (descending) or 0 (no ordering).");
        }
        return n;
    }

    private final FacetWrap.Direction getDirOption() {
        FacetWrap.Direction direction;
        Object opt = this.get("dir");
        if (opt == null) {
            direction = FacetWrap.Direction.H;
        } else {
            String string = opt.toString().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"V")) {
                direction = FacetWrap.Direction.V;
            } else if (Intrinsics.areEqual((Object)string2, (Object)"H")) {
                direction = FacetWrap.Direction.H;
            } else {
                throw new IllegalArgumentException("Unsupported `dir` value: " + opt + ".\nUse: 'H' (horizontal) or 'V' (vertical).");
            }
        }
        return direction;
    }

    private final Function1<Object, String> toFormatterVal(Object optionVal) {
        if (optionVal != null) {
            StringFormat fmt = StringFormat.Companion.forOneArg$default(StringFormat.Companion, optionVal.toString(), null, null, this.superscriptExponent, 6, null);
            return (Function1)new Function1<Object, String>(fmt){
                final /* synthetic */ StringFormat $fmt;
                {
                    this.$fmt = $fmt;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull Object value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    return this.$fmt.format(value2);
                }
            };
        }
        return PlotFacets.Companion.getDEF_FORMATTER();
    }

    private final Function1<Object, String> getFormatterOption(String optionName) {
        return this.toFormatterVal(this.get(optionName));
    }

    private final int getLabWidthOption(String optionName) {
        return this.getIntegerDef(optionName, -1);
    }

    private final FacetScales getScalesOption() {
        Object object;
        block22: {
            block20: {
                FacetScales facetScales;
                object = this.getString("scales");
                if (object == null) break block20;
                String it = object;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                switch (string) {
                    case "fixed": {
                        facetScales = FacetScales.FIXED;
                        break;
                    }
                    case "free": {
                        facetScales = FacetScales.FREE;
                        break;
                    }
                    case "free_x": {
                        facetScales = FacetScales.FREE_X;
                        break;
                    }
                    case "free_y": {
                        facetScales = FacetScales.FREE_Y;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported `scales` value: " + it + ".\nUse: fixed, free, free_x or free_y");
                    }
                }
                object = facetScales;
                if (facetScales != null) break block22;
            }
            object = FacetScales.FIXED;
        }
        return object;
    }
}

