/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.css.engine.value.svg;

import org.jetbrains.relocated.apache.batik.css.engine.CSSEngine;
import org.jetbrains.relocated.apache.batik.css.engine.value.AbstractValueManager;
import org.jetbrains.relocated.apache.batik.css.engine.value.URIValue;
import org.jetbrains.relocated.apache.batik.css.engine.value.Value;
import org.jetbrains.relocated.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class ClipPathManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public String getPropertyName() {
        return "clip-path";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 20;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine2) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 24: {
                return new URIValue(lu.getStringValue(), ClipPathManager.resolveURI(engine2.getCSSBaseURI(), lu.getStringValue()));
            }
            case 35: {
                if (!lu.getStringValue().equalsIgnoreCase("none")) break;
                return ValueConstants.NONE_VALUE;
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(short type, String value2, CSSEngine engine2) throws DOMException {
        switch (type) {
            case 21: {
                if (!value2.equalsIgnoreCase("none")) break;
                return ValueConstants.NONE_VALUE;
            }
            case 20: {
                return new URIValue(value2, ClipPathManager.resolveURI(engine2.getCSSBaseURI(), value2));
            }
        }
        throw this.createInvalidStringTypeDOMException(type);
    }
}

