/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.xdebugger.XDebuggerBundle;
import com.jetbrains.firefox.FirefoxBreakpointManager;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxListener;
import com.jetbrains.firefox.FirefoxScriptManager;
import com.jetbrains.firefox.FirefoxSuspendContextManager;
import com.jetbrains.firefox.rdp.Source;
import com.jetbrains.firefox.rdp.ThreadInterrupted;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.VmBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H$R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\t\u00a8\u0006%"}, d2={"Lcom/jetbrains/firefox/FirefoxVm;", "Lorg/jetbrains/debugger/VmBase;", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "<init>", "(Lorg/jetbrains/debugger/DebugEventListener;)V", "tabActor", "", "getTabActor", "()Ljava/lang/String;", "setTabActor", "(Ljava/lang/String;)V", "threadActor", "getThreadActor", "setThreadActor", "commandProcessor", "Lcom/jetbrains/firefox/FirefoxCommandProcessor;", "getCommandProcessor", "()Lcom/jetbrains/firefox/FirefoxCommandProcessor;", "breakpointManager", "Lcom/jetbrains/firefox/FirefoxBreakpointManager;", "getBreakpointManager", "()Lcom/jetbrains/firefox/FirefoxBreakpointManager;", "scriptManager", "Lcom/jetbrains/firefox/FirefoxScriptManager;", "getScriptManager", "()Lcom/jetbrains/firefox/FirefoxScriptManager;", "suspendContextManager", "Lcom/jetbrains/firefox/FirefoxSuspendContextManager;", "getSuspendContextManager", "()Lcom/jetbrains/firefox/FirefoxSuspendContextManager;", "presentableName", "getPresentableName", "writeMessage", "", "content", "Lio/netty/buffer/ByteBuf;", "intellij.javascript.firefox.connector"})
public abstract class FirefoxVm
extends VmBase {
    @Nullable
    private String tabActor;
    @Nullable
    private String threadActor;
    @NotNull
    private final FirefoxCommandProcessor commandProcessor;
    @NotNull
    private final FirefoxBreakpointManager breakpointManager;
    @NotNull
    private final FirefoxScriptManager scriptManager;
    @NotNull
    private final FirefoxSuspendContextManager suspendContextManager;

    public FirefoxVm(final @NotNull DebugEventListener debugListener) {
        Intrinsics.checkNotNullParameter((Object)debugListener, (String)"debugListener");
        super(debugListener);
        this.commandProcessor = new FirefoxCommandProcessor((Function1<? super ByteBuf, Boolean>)((Function1)arg_0 -> FirefoxVm.commandProcessor$lambda$0(this, arg_0)));
        this.breakpointManager = new FirefoxBreakpointManager(this);
        this.scriptManager = new FirefoxScriptManager(this);
        this.suspendContextManager = new FirefoxSuspendContextManager(this);
        this.commandProcessor.addListener(new FirefoxListener(){

            @Override
            public void frameUpdated(String actor, boolean destroyAll) {
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                if (destroyAll && Intrinsics.areEqual((Object)this.getTabActor(), (Object)actor)) {
                    this.getCommandProcessor().clear();
                    this.getScriptManager().clear(debugListener);
                    this.getSuspendContextManager().mainFrameUpdated();
                }
            }

            @Override
            public void paused(ThreadInterrupted event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.why().type() != ThreadInterrupted.Reason.Type.ATTACHED) {
                    this.getSuspendContextManager().paused(event);
                }
            }

            @Override
            public void scriptAdded(Source script) {
                Intrinsics.checkNotNullParameter((Object)script, (String)"script");
                this.getScriptManager().addScript(script);
            }
        });
    }

    @Nullable
    public final String getTabActor() {
        return this.tabActor;
    }

    public final void setTabActor(@Nullable String string) {
        this.tabActor = string;
    }

    @Nullable
    public final String getThreadActor() {
        return this.threadActor;
    }

    public final void setThreadActor(@Nullable String string) {
        this.threadActor = string;
    }

    @NotNull
    public final FirefoxCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @NotNull
    public FirefoxBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @NotNull
    public FirefoxScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @NotNull
    public FirefoxSuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    @NotNull
    public String getPresentableName() {
        String string = XDebuggerBundle.message((String)"debugger.session.tab.frames.thread.main", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected abstract boolean writeMessage(@NotNull ByteBuf var1);

    private static final boolean commandProcessor$lambda$0(FirefoxVm this$0, ByteBuf it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.writeMessage(it);
    }
}

