/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.dataframe;

import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.PyNumericViewUtil;
import com.jetbrains.python.debugger.dataframe.DataViewCellRenderer;
import com.jetbrains.python.debugger.dataframe.TableValueDescriptor;
import java.awt.Color;
import javax.swing.JTable;

class DataFrameTableCellRenderer
extends DataViewCellRenderer
implements ColoredCellRenderer {
    private boolean myColored = true;

    DataFrameTableCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        this.setVerticalAlignment(0);
    }

    @Override
    public void setColored(boolean colored) {
        this.myColored = colored;
    }

    @Override
    protected void colorize(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof TableValueDescriptor)) {
            this.setBackground(null);
            return;
        }
        TableValueDescriptor descriptor2 = (TableValueDescriptor)value;
        Color background = null;
        if (this.myColored) {
            try {
                double rangedValue = descriptor2.getRangedValue();
                if (!Double.isNaN(rangedValue)) {
                    background = PyNumericViewUtil.rangedValueToColor(rangedValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setBackground(background);
    }
}

