/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PyRequirement {
    @NotNull
    public String getName();

    @NotNull
    public List<PyRequirementVersionSpec> getVersionSpecs();

    @NotNull
    public List<String> getInstallOptions();

    @NotNull
    public String getExtras();

    @Nullable
    public PyPackage match(@NotNull Collection<? extends PyPackage> var1);

    default public boolean isEditable() {
        if (this.getInstallOptions().isEmpty()) {
            return false;
        }
        String firstOption = this.getInstallOptions().get(0);
        return "-e".equals(firstOption) || "--editable".equals(firstOption);
    }

    @NotNull
    @NlsSafe
    default public String getPresentableText() {
        String string = this.getName() + this.getExtras() + StringUtil.join(this.getVersionSpecs(), PyRequirementVersionSpec::getPresentableText, (String)",");
        if (string == null) {
            PyRequirement.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/packaging/PyRequirement", "getPresentableText"));
    }
}

