/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.grouping;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\bJ\u001c\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u0016\u001a\u00020\u0012H\u0086\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ui/grouping/NodeGroupRepository;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "", "<init>", "()V", "groups", "", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "root2GroupMap", "Ljava/util/IdentityHashMap;", "Lcom/intellij/profiler/model/CallTreeNode;", "addGroup", "", "group", "groupStartingWithNode", "node", "size", "", "getSize", "()I", "get", "index", "intellij.profiler.common"})
@ApiStatus.Experimental
public final class NodeGroupRepository<Call extends BaseCallStackElement> {
    @NotNull
    private final List<FoldingNodesGroup<Call>> groups = new ArrayList();
    @NotNull
    private final IdentityHashMap<CallTreeNode<Call>, FoldingNodesGroup<Call>> root2GroupMap = new IdentityHashMap();

    public final void addGroup(@NotNull FoldingNodesGroup<Call> group2) {
        Intrinsics.checkNotNullParameter(group2, (String)"group");
        ((Collection)this.groups).add(group2);
        ((Map)this.root2GroupMap).put(group2.getGroupStart(), group2);
    }

    @Nullable
    public final FoldingNodesGroup<Call> groupStartingWithNode(@NotNull CallTreeNode<? extends Call> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return this.root2GroupMap.get(node);
    }

    public final int getSize() {
        return this.groups.size();
    }

    @NotNull
    public final FoldingNodesGroup<Call> get(int index) {
        return this.groups.get(index);
    }
}

