/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.fs;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.WebServerConfigsChangedListener;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.remoteEdit.notification.RemoteEditEditorDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDeploymentFileSystem
extends DeprecatedVirtualFileSystem
implements FileEditorManagerListener {
    @NonNls
    private static final String PROTOCOL = "remoteDeploymentFS";
    private final ConcurrentHashMap<String, RemoteVirtualFile> myOpenFiles = new ConcurrentHashMap();

    public static RemoteDeploymentFileSystem getInstance() {
        return (RemoteDeploymentFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public RemoteDeploymentFileSystem() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        busConnection.subscribe(WebDeploymentTopics.WEB_SERVER_CONFIGS, (Object)new WebServerConfigsChangedListener(){

            @Override
            public void serverConfigsChanged() {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project);
                    for (VirtualFile file : fileEditorManagerEx.getOpenFiles()) {
                        if (!(file instanceof RemoteVirtualFile)) continue;
                        fileEditorManagerEx.updateFilePresentation(file);
                    }
                }
            }
        });
        ProjectManager.getInstance().addProjectManagerListener(new VetoableProjectManagerListener(){

            public boolean canClose(@NotNull Project project) {
                String message;
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                SmartList openFiles = new SmartList();
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
                for (RemoteVirtualFile file : RemoteDeploymentFileSystem.this.myOpenFiles.values()) {
                    if (editorManager.getEditors((VirtualFile)file).length == 0 || !file.isChanged()) continue;
                    openFiles.add(file);
                }
                if (openFiles.isEmpty()) {
                    return true;
                }
                if (openFiles.size() == 1) {
                    message = WDBundle.message("remote.edit.close.project.message", ((RemoteVirtualFile)((Object)openFiles.get(0))).getPresentableName());
                } else {
                    ArrayList<@Nls Object> messages = new ArrayList<Object>();
                    messages.add(WDBundle.message("remote.edit.some.remote.files.are.opened.for.editing.and.their.changes.are.not.uploaded", new Object[0]));
                    for (RemoteVirtualFile file : openFiles) {
                        messages.add("'" + file.getPresentableName() + "'");
                    }
                    messages.add(WDBundle.message("remote.edit.do.you.want.to.close.the.project.and.lose.them", new Object[0]));
                    message = StringUtil.join(messages, (String)"\n");
                }
                int choice = Messages.showYesNoDialog((Project)project, (String)message, (String)RemoteDeploymentFileSystem.getMessagesTitle(), (Icon)Messages.getQuestionIcon());
                if (choice == 1) {
                    return false;
                }
                for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
                    VirtualFile[] files;
                    if (openProject == project) continue;
                    for (VirtualFile file : files = FileEditorManager.getInstance((Project)openProject).getOpenFiles()) {
                        if (!(file instanceof RemoteVirtualFile)) continue;
                        openFiles.remove(file);
                    }
                }
                RemoteDeploymentFileSystem.this.myOpenFiles.values().removeAll((Collection<?>)openFiles);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem$2", "canClose"));
            }
        });
        this.startEventPropagation();
        this.addVirtualFileListener(new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                VirtualFile file;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!((file = event.getFile()) instanceof RemoteVirtualFile)) {
                    return;
                }
                RemoteEditEditorDecorator.updateDecorators((RemoteVirtualFile)file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem$3", "contentsChanged"));
            }
        });
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public RemoteVirtualFile checkAndGetFileIfOpened(String url) {
        ThreadingAssertions.assertEventDispatchThread();
        RemoteVirtualFile file = this.myOpenFiles.get(url);
        if (file == null) {
            return null;
        }
        if (RemoteDeploymentFileSystem.isFileOpenInSomeEditor(file)) {
            return file;
        }
        this.myOpenFiles.remove(url);
        return null;
    }

    @NotNull
    public RemoteVirtualFile constructFileByNodeServerAndContent(@NotNull FileObject node, @NotNull Deployable config, byte @NotNull [] content, RemoteConnection connection, @Nullable String presentableServerName) {
        if (node == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(0);
        }
        if (config == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(1);
        }
        if (content == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        String name = node.getName().getBaseName();
        String nodePath = RemoteDeploymentFileSystem.getPath(node, config);
        String path = RemoteDeploymentFileSystem.constructIdPath(nodePath, config);
        String url = RemoteDeploymentFileSystem.constructURL(nodePath, config);
        RemoteVirtualFile file = new RemoteVirtualFile(this, path, name, content, config, connection, node, presentableServerName);
        RemoteVirtualFile lastSavedFile = this.myOpenFiles.putIfAbsent(url, file);
        RemoteVirtualFile remoteVirtualFile = lastSavedFile == null ? file : lastSavedFile;
        if (remoteVirtualFile == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(3);
        }
        return remoteVirtualFile;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(4);
        }
        return this.myOpenFiles.get(path);
    }

    public void refresh(boolean asynchronous) {
        throw new UnsupportedOperationException("refresh is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(5);
        }
        return null;
    }

    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("deleteFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) {
        if (vFile == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(7);
        }
        if (newParent == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException("moveFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException("renameFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) {
        if (vDir == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException("createChildFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        if (vDir == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(13);
        }
        if (dirName == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException("createChildDirectory is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) {
        if (virtualFile == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(15);
        }
        if (newParent == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(16);
        }
        if (copyName == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException("copyFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    public static String constructURL(@NotNull FileObject fileObject, @NotNull Deployable config) {
        if (fileObject == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(18);
        }
        if (config == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(19);
        }
        return RemoteDeploymentFileSystem.constructURL(RemoteDeploymentFileSystem.getPath(fileObject, config), config);
    }

    public static String constructURL(@NotNull String nodePath, @NotNull Deployable config) {
        if (nodePath == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(20);
        }
        if (config == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(21);
        }
        return RemoteDeploymentFileSystem.constructIdURL(nodePath, config);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(22);
        }
        super.fireBeforeContentsChange(requestor, file);
    }

    public void fireContentsChanged(Object requestor, @NotNull VirtualFile file, long oldModificationStamp) {
        if (file == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(23);
        }
        super.fireContentsChanged(requestor, file, oldModificationStamp);
    }

    private static String constructIdURL(@NotNull String nodePath, @NotNull Deployable config) {
        if (nodePath == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(24);
        }
        if (config == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(25);
        }
        return "remoteDeploymentFS://" + RemoteDeploymentFileSystem.constructIdPath(nodePath, config);
    }

    private static String constructIdPath(@NotNull String nodePath, @NotNull Deployable config) {
        if (nodePath == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(26);
        }
        if (config == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(27);
        }
        return "<" + config.getId() + ">/" + nodePath;
    }

    private static String getPath(@NotNull FileObject fileObject, @NotNull Deployable config) {
        int i;
        if (fileObject == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(28);
        }
        if (config == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(29);
        }
        String path = config.getRemotePath(fileObject).toString();
        for (i = 0; i < path.length() && (path.charAt(i) == '\\' || path.charAt(i) == '/'); ++i) {
        }
        return path.substring(i);
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(30);
        }
        if (file == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(31);
        }
        if (!(file instanceof RemoteVirtualFile)) {
            return;
        }
        RemoteEditEditorDecorator.updateDecorators(source, (RemoteVirtualFile)file);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        RemoteVirtualFile remoteVirtualFile;
        Project project;
        block10: {
            block9: {
                if (source == null) {
                    RemoteDeploymentFileSystem.$$$reportNull$$$0(32);
                }
                if (file == null) {
                    RemoteDeploymentFileSystem.$$$reportNull$$$0(33);
                }
                ThreadingAssertions.assertEventDispatchThread();
                project = source.getProject();
                if (!(file instanceof RemoteVirtualFile)) break block9;
                remoteVirtualFile = (RemoteVirtualFile)file;
                if (project.isOpen()) break block10;
            }
            return;
        }
        if (!remoteVirtualFile.isChanged()) {
            return;
        }
        String message = WDBundle.message("remote.edit.remote.file.0.was.closed.and", remoteVirtualFile.getPresentableName());
        int choice = Messages.showYesNoDialog((Project)project, (String)message, (String)RemoteDeploymentFileSystem.getMessagesTitle(), (Icon)Messages.getQuestionIcon());
        if (choice == 1) {
            if (RemoteDeploymentFileSystem.isFileOpenInSomeEditor(file)) {
                return;
            }
            this.myOpenFiles.remove(file.getUrl());
        } else {
            PsiNavigationSupport.getInstance().createNavigatable(project, file, -1).navigate(true);
        }
    }

    private static boolean isFileOpenInSomeEditor(@NotNull VirtualFile file) {
        if (file == null) {
            RemoteDeploymentFileSystem.$$$reportNull$$$0(34);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!FileEditorManager.getInstance((Project)project).isFileOpen(file)) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.DialogTitle
    private static String getMessagesTitle() {
        return WDBundle.message("remote.edit.fs.messages.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileObject";
                break;
            }
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePath";
                break;
            }
            case 22: 
            case 23: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constructFileByNodeServerAndContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "constructFileByNodeServerAndContent";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "constructURL";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeContentsChange";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fireContentsChanged";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "constructIdURL";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "constructIdPath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpenInSomeEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

