/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.actions.edit.mode;

import com.intellij.jupyter.core.editor.actions.edit.mode.HorizontalDirection;
import com.intellij.jupyter.core.editor.actions.edit.mode.JupyterCaretMoveHandler;
import com.intellij.jupyter.core.editor.actions.edit.mode.JupyterCustomCaretMoveUtilKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/editor/actions/edit/mode/JupyterHorizontalCaretMove;", "Lcom/intellij/jupyter/core/editor/actions/edit/mode/JupyterCaretMoveHandler;", "direction", "Lcom/intellij/jupyter/core/editor/actions/edit/mode/HorizontalDirection;", "withSelection", "", "<init>", "(Lcom/intellij/jupyter/core/editor/actions/edit/mode/HorizontalDirection;Z)V", "getDirection", "()Lcom/intellij/jupyter/core/editor/actions/edit/mode/HorizontalDirection;", "getWithSelection", "()Z", "canMove", "jupyterEditor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "tryMove", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "intellij.jupyter.core"})
final class JupyterHorizontalCaretMove
implements JupyterCaretMoveHandler {
    @NotNull
    private final HorizontalDirection direction;
    private final boolean withSelection;

    public JupyterHorizontalCaretMove(@NotNull HorizontalDirection direction, boolean withSelection) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
        this.withSelection = withSelection;
    }

    @NotNull
    public final HorizontalDirection getDirection() {
        return this.direction;
    }

    public final boolean getWithSelection() {
        return this.withSelection;
    }

    private final boolean canMove(Editor jupyterEditor, Caret caret) {
        if (!this.withSelection && caret.hasSelection()) {
            return true;
        }
        return !JupyterCustomCaretMoveUtilKt.isAtVisibleCellBorder(jupyterEditor, caret, this.direction);
    }

    @Override
    public void tryMove(@NotNull Editor jupyterEditor, @NotNull Caret caret, @Nullable DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)jupyterEditor, (String)"jupyterEditor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            if (!this.canMove(jupyterEditor, caret)) break block1;
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler != null) {
                editorActionHandler.execute(jupyterEditor, caret, dataContext);
            }
        }
    }
}

