/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections;

import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterNotebookProcessHandlerKt;
import com.intellij.jupyter.core.jupyter.connections.JupyterProcessException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u0003678B\u00a3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\t\u0012\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f\u0012<\b\u0002\u0010\u000e\u001a6\u0012\u0017\u0012\u00150\u000fj\u0002`\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\n0\f\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\b\u0010-\u001a\u00020\nH\u0002J\u0006\u0010.\u001a\u00020 J\b\u0010/\u001a\u00020\nH\u0016J\b\u00100\u001a\u00020\nH\u0014J\b\u00101\u001a\u00020\nH\u0014J\b\u00102\u001a\u00020\nH\u0002J\b\u00103\u001a\u00020\u0018H\u0014J\b\u00104\u001a\u000205H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u000e\u001a6\u0012\u0017\u0012\u00150\u000fj\u0002`\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001b\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\"\u0010$\u001a\u0004\u0018\u00010 2\b\u0010\u001b\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u000e\u0010&\u001a\u00020'X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00060)j\u0002`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler;", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "targetCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "startupProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onServerInit", "Lkotlin/Function1;", "", "onServerTerminated", "Lkotlin/Function2;", "Lcom/intellij/execution/process/ProcessEvent;", "onServerError", "Ljava/lang/Exception;", "Lkotlin/ParameterName;", "name", "e", "Lkotlin/Exception;", "notebookProcessHandler", "connectionPattern", "Ljava/util/regex/Pattern;", "allowNonLocalStorage", "", "<init>", "(Lcom/intellij/execution/target/TargetEnvironment;Lcom/intellij/execution/target/TargetedCommandLine;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Ljava/util/regex/Pattern;Z)V", "value", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$Location;", "location", "getLocation", "()Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters$Location;", "", "token", "getToken", "()Ljava/lang/String;", "serverPath", "getServerPath", "STDERR_DATA_MAX_CAPACITY", "", "stderrData", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "serverInitLatch", "Ljava/util/concurrent/CountDownLatch;", "initJupyterServer", "collectErrorData", "startNotify", "doDestroyProcess", "detachProcessImpl", "closeStreams", "destroyProcessGracefully", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "JupyterProcessListener", "ConnectionPatternMatchResult", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,388:1\n24#2:389\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler\n*L\n213#1:389\n*E\n"})
public final class JupyterNotebookProcessHandler
extends KillableColoredProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TargetEnvironment targetEnvironment;
    @NotNull
    private final Function1<JupyterNotebookProcessHandler, Unit> onServerInit;
    @NotNull
    private final Function2<JupyterNotebookProcessHandler, ProcessEvent, Unit> onServerTerminated;
    @NotNull
    private final Function2<Exception, JupyterNotebookProcessHandler, Unit> onServerError;
    @NotNull
    private final Pattern connectionPattern;
    private final boolean allowNonLocalStorage;
    @Nullable
    private volatile JupyterConnectionParameters.Location location;
    @Nullable
    private volatile String token;
    @Nullable
    private volatile String serverPath;
    private final int STDERR_DATA_MAX_CAPACITY;
    @NotNull
    private final StringBuilder stderrData;
    @NotNull
    private final CountDownLatch serverInitLatch;
    @NotNull
    private static final Pattern NOTEBOOK_CONNECTION_PATTERN;
    @NotNull
    private static final Regex SERVER_PATH_PATTERN;

    public JupyterNotebookProcessHandler(@NotNull TargetEnvironment targetEnvironment, @NotNull TargetedCommandLine targetCommandLine, @NotNull ProgressIndicator startupProgressIndicator, @NotNull Function1<? super JupyterNotebookProcessHandler, Unit> onServerInit, @NotNull Function2<? super JupyterNotebookProcessHandler, ? super ProcessEvent, Unit> onServerTerminated, @NotNull Function2<? super Exception, ? super JupyterNotebookProcessHandler, Unit> onServerError, @NotNull Pattern connectionPattern, boolean allowNonLocalStorage) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)targetCommandLine, (String)"targetCommandLine");
        Intrinsics.checkNotNullParameter((Object)startupProgressIndicator, (String)"startupProgressIndicator");
        Intrinsics.checkNotNullParameter(onServerInit, (String)"onServerInit");
        Intrinsics.checkNotNullParameter(onServerTerminated, (String)"onServerTerminated");
        Intrinsics.checkNotNullParameter(onServerError, (String)"onServerError");
        Intrinsics.checkNotNullParameter((Object)connectionPattern, (String)"connectionPattern");
        super(targetEnvironment.createProcess(targetCommandLine, startupProgressIndicator), targetCommandLine.getCommandPresentation(targetEnvironment));
        this.targetEnvironment = targetEnvironment;
        this.onServerInit = onServerInit;
        this.onServerTerminated = onServerTerminated;
        this.onServerError = onServerError;
        this.connectionPattern = connectionPattern;
        this.allowNonLocalStorage = allowNonLocalStorage;
        this.STDERR_DATA_MAX_CAPACITY = 8192;
        this.stderrData = new StringBuilder();
        this.serverInitLatch = new CountDownLatch(1);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                Logger $this$debug_u24default$iv = JupyterNotebookProcessHandlerKt.access$getLOG$p();
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    char[] cArray = new char[]{'\r', '\n'};
                    logger.debug(StringsKt.trimStart((String)((Object)StringsKt.trimEnd((CharSequence)string)).toString(), (char[])cArray), e$iv);
                }
            }
        });
    }

    public /* synthetic */ JupyterNotebookProcessHandler(TargetEnvironment targetEnvironment, TargetedCommandLine targetedCommandLine, ProgressIndicator progressIndicator, Function1 function1, Function2 function2, Function2 function22, Pattern pattern, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = JupyterNotebookProcessHandler::_init_$lambda$0;
        }
        if ((n & 0x10) != 0) {
            function2 = JupyterNotebookProcessHandler::_init_$lambda$1;
        }
        if ((n & 0x20) != 0) {
            function22 = JupyterNotebookProcessHandler::_init_$lambda$2;
        }
        if ((n & 0x40) != 0) {
            pattern = NOTEBOOK_CONNECTION_PATTERN;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        this(targetEnvironment, targetedCommandLine, progressIndicator, (Function1<? super JupyterNotebookProcessHandler, Unit>)function1, (Function2<? super JupyterNotebookProcessHandler, ? super ProcessEvent, Unit>)function2, (Function2<? super Exception, ? super JupyterNotebookProcessHandler, Unit>)function22, pattern, bl);
    }

    @Nullable
    public final JupyterConnectionParameters.Location getLocation() {
        return this.location;
    }

    @Nullable
    public final String getToken() {
        return this.token;
    }

    @Nullable
    public final String getServerPath() {
        return this.serverPath;
    }

    private final void initJupyterServer() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        while (!this.serverInitLatch.await(500L, TimeUnit.MILLISECONDS)) {
            if (!this.isProcessTerminating() && !this.isProcessTerminated()) continue;
            throw new InterruptedException();
        }
        if (this.location == null || !this.allowNonLocalStorage && this.serverPath == null) {
            throw new JupyterProcessException(this.getExitCode(), this.collectErrorData());
        }
    }

    @NotNull
    public final String collectErrorData() {
        String string = this.stderrData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void startNotify() {
        this.addProcessListener((ProcessListener)new JupyterProcessListener());
        BuildersKt.launch$default((CoroutineScope)NotebookDisposable.Companion.getForApp(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterNotebookProcessHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        JupyterNotebookProcessHandler.access$initJupyterServer(this.this$0);
                        v0 = this.this$0.getLocation();
                        Intrinsics.checkNotNull((Object)v0);
                        this.label = 1;
                        v1 = JupyterNotebookProcessHandlerKt.access$waitUntilServerReachable(v0.getUri(), (Continuation)this);
                        ** if (v1 != var3_2) goto lbl14
lbl13:
                        // 1 sources

                        return var3_2;
lbl14:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl20:
                            // 2 sources

                            JupyterNotebookProcessHandler.access$getOnServerInit$p(this.this$0).invoke((Object)this.this$0);
                        }
                        catch (InterruptedException var2_3) {
                        }
                        catch (Exception e) {
                            JupyterNotebookProcessHandler.access$getOnServerError$p(this.this$0).invoke((Object)e, (Object)this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        super.startNotify();
    }

    protected void doDestroyProcess() {
        boolean bl;
        boolean gracefulTerminationAttempted;
        boolean bl2 = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canDestroyProcessGracefully() && this.destroyProcessGracefully();
        if (gracefulTerminationAttempted) {
            return;
        }
        boolean bl3 = bl = this.shouldDestroyProcessRecursively() && KillableColoredProcessHandler.processCanBeKilledByOS((Process)this.getProcess());
        if (bl) {
            this.killProcessTree(this.getProcess());
        } else if (!bl) {
            this.getProcess().destroy();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    protected void detachProcessImpl() {
        if (SystemInfo.isUnix) {
            super.detachProcessImpl();
        } else {
            Runnable runnable = () -> JupyterNotebookProcessHandler.detachProcessImpl$lambda$3(this);
            Future future = this.executeTask(runnable);
            Intrinsics.checkNotNull((Object)future);
        }
    }

    private final void closeStreams() {
        block2: {
            try {
                this.myProcess.getOutputStream().close();
            }
            catch (IOException e) {
                if (!this.myProcess.isAlive()) break block2;
                JupyterNotebookProcessHandler $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterNotebookProcessHandler.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot close stdin of '" + this.getCommandLine() + "'", (Throwable)e);
            }
        }
    }

    protected boolean destroyProcessGracefully() {
        return SystemInfo.isUnix ? false : super.destroyProcessGracefully();
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
        return options;
    }

    private static final Unit _init_$lambda$0(JupyterNotebookProcessHandler it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(JupyterNotebookProcessHandler jupyterNotebookProcessHandler, ProcessEvent processEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterNotebookProcessHandler), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)processEvent, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Exception exception, JupyterNotebookProcessHandler jupyterNotebookProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterNotebookProcessHandler), (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final void detachProcessImpl$lambda$3(JupyterNotebookProcessHandler this$0) {
        this$0.closeStreams();
        this$0.myWaitFor.detach();
        this$0.notifyProcessDetached();
    }

    public static final /* synthetic */ void access$initJupyterServer(JupyterNotebookProcessHandler $this) {
        $this.initJupyterServer();
    }

    public static final /* synthetic */ Function1 access$getOnServerInit$p(JupyterNotebookProcessHandler $this) {
        return $this.onServerInit;
    }

    public static final /* synthetic */ Function2 access$getOnServerError$p(JupyterNotebookProcessHandler $this) {
        return $this.onServerError;
    }

    static {
        Pattern pattern = Pattern.compile("(?<protocol>\\w+)://((?<host>[-.a-zA-Z0-9]+)|(\\([-.a-zA-Z0-9]+ or (?<localhost>[-.a-zA-Z0-9]+)\\))):(?<port>\\d*)(/(?<path>([a-zA-Z0-9.\\-_~!$&'()*+,;=:@%/])*)(\\?token=((?<token>\\w+)|\\.\\.\\.))?)?$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        NOTEBOOK_CONNECTION_PATTERN = pattern;
        SERVER_PATH_PATTERN = new Regex("Serving notebooks from local directory: (.*)$");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler$Companion;", "", "<init>", "()V", "NOTEBOOK_CONNECTION_PATTERN", "Ljava/util/regex/Pattern;", "SERVER_PATH_PATTERN", "Lkotlin/text/Regex;", "getSERVER_PATH_PATTERN", "()Lkotlin/text/Regex;", "findConnectionPattern", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler$ConnectionPatternMatchResult;", "input", "", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterNotebookProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n1#2:389\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSERVER_PATH_PATTERN() {
            return SERVER_PATH_PATTERN;
        }

        @Nullable
        public final ConnectionPatternMatchResult findConnectionPattern(@NotNull CharSequence input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (!URLUtil.canContainUrl((String)((Object)input).toString())) {
                return null;
            }
            Matcher matcher = NOTEBOOK_CONNECTION_PATTERN.matcher(input);
            if (matcher.find()) {
                Object object;
                String string = matcher.group("protocol");
                if (string == null) {
                    return null;
                }
                String protocol = string;
                String string2 = matcher.group("host");
                if (string2 == null && (string2 = matcher.group("localhost")) == null) {
                    return null;
                }
                String host = string2;
                Object object2 = matcher.group("port");
                int port = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : -1;
                String token = matcher.group("token");
                Object object3 = this;
                try {
                    Companion $this$findConnectionPattern_u24lambda_u240 = object3;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)matcher.group("path"));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object3 = object;
                String string3 = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
                String path = string3 != null ? StringsKt.removeSuffix((String)string3, (CharSequence)"/") : null;
                return new ConnectionPatternMatchResult(protocol, host, port, token, path);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JA\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler$ConnectionPatternMatchResult;", "", "protocol", "", "host", "port", "", "token", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getProtocol", "()Ljava/lang/String;", "getHost", "getPort", "()I", "getToken", "getPath", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.jupyter.core"})
    public static final class ConnectionPatternMatchResult {
        @NotNull
        private final String protocol;
        @Nullable
        private final String host;
        private final int port;
        @Nullable
        private final String token;
        @Nullable
        private final String path;

        public ConnectionPatternMatchResult(@NotNull String protocol, @Nullable String host, int port, @Nullable String token, @Nullable String path) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.token = token;
            this.path = path;
        }

        @NotNull
        public final String getProtocol() {
            return this.protocol;
        }

        @Nullable
        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        @Nullable
        public final String getToken() {
            return this.token;
        }

        @Nullable
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String component1() {
            return this.protocol;
        }

        @Nullable
        public final String component2() {
            return this.host;
        }

        public final int component3() {
            return this.port;
        }

        @Nullable
        public final String component4() {
            return this.token;
        }

        @Nullable
        public final String component5() {
            return this.path;
        }

        @NotNull
        public final ConnectionPatternMatchResult copy(@NotNull String protocol, @Nullable String host, int port, @Nullable String token, @Nullable String path) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            return new ConnectionPatternMatchResult(protocol, host, port, token, path);
        }

        public static /* synthetic */ ConnectionPatternMatchResult copy$default(ConnectionPatternMatchResult connectionPatternMatchResult, String string, String string2, int n, String string3, String string4, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = connectionPatternMatchResult.protocol;
            }
            if ((n2 & 2) != 0) {
                string2 = connectionPatternMatchResult.host;
            }
            if ((n2 & 4) != 0) {
                n = connectionPatternMatchResult.port;
            }
            if ((n2 & 8) != 0) {
                string3 = connectionPatternMatchResult.token;
            }
            if ((n2 & 0x10) != 0) {
                string4 = connectionPatternMatchResult.path;
            }
            return connectionPatternMatchResult.copy(string, string2, n, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ConnectionPatternMatchResult(protocol=" + this.protocol + ", host=" + this.host + ", port=" + this.port + ", token=" + this.token + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result2 = this.protocol.hashCode();
            result2 = result2 * 31 + (this.host == null ? 0 : this.host.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.port);
            result2 = result2 * 31 + (this.token == null ? 0 : this.token.hashCode());
            result2 = result2 * 31 + (this.path == null ? 0 : this.path.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionPatternMatchResult)) {
                return false;
            }
            ConnectionPatternMatchResult connectionPatternMatchResult = (ConnectionPatternMatchResult)other;
            if (!Intrinsics.areEqual((Object)this.protocol, (Object)connectionPatternMatchResult.protocol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.host, (Object)connectionPatternMatchResult.host)) {
                return false;
            }
            if (this.port != connectionPatternMatchResult.port) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.token, (Object)connectionPatternMatchResult.token)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)connectionPatternMatchResult.path);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler$JupyterProcessListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterNotebookProcessHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler$JupyterProcessListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n774#2:389\n865#2,2:390\n1#3:392\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookProcessHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/JupyterNotebookProcessHandler$JupyterProcessListener\n*L\n150#1:389\n150#1:390,2\n*E\n"})
    private final class JupyterProcessListener
    extends ProcessAdapter {
        /*
         * WARNING - void declaration
         */
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            if (!Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
                return;
            }
            StringBuilder stringBuilder = JupyterNotebookProcessHandler.this.stderrData;
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            JupyterNotebookProcessHandlerKt.access$append(stringBuilder, string, JupyterNotebookProcessHandler.this.STDERR_DATA_MAX_CAPACITY);
            if (JupyterNotebookProcessHandler.this.getServerPath() == null) {
                Regex regex = Companion.getSERVER_PATH_PATTERN();
                String string2 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string2, (int)0, (int)2, null);
                if (matchResult != null) {
                    MatchResult matchResult2 = matchResult;
                    objectArray = JupyterNotebookProcessHandler.this;
                    MatchResult it = matchResult2;
                    boolean bl = false;
                    ((JupyterNotebookProcessHandler)objectArray).serverPath = (String)it.getGroupValues().get(1);
                }
            }
            if (JupyterNotebookProcessHandler.this.getLocation() == null) {
                JupyterConnectionParameters.Location location;
                Iterable iterable;
                Iterable $this$filter$iv;
                String[] bl;
                String string3 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                ConnectionPatternMatchResult connectionPatternMatchResult = Companion.findConnectionPattern(string3);
                if (connectionPatternMatchResult == null) {
                    return;
                }
                ConnectionPatternMatchResult match = connectionPatternMatchResult;
                Object object = match.getPath();
                if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(bl = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null) {
                    void $this$filterTo$iv$iv;
                    $this$filter$iv = (Iterable)object;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        boolean bl3 = ((CharSequence)it).length() > 0;
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable it = $this$filter$iv = (List)destination$iv$iv;
                    boolean bl4 = false;
                    iterable = !((Collection)it).isEmpty() ? $this$filter$iv : null;
                } else {
                    iterable = null;
                }
                List splitedPath = iterable;
                objectArray = new String[]{"tree", "lab"};
                List list = splitedPath;
                if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)(list != null ? (String)CollectionsKt.last(list) : null))) {
                    List list2 = splitedPath;
                    splitedPath = list2 != null ? CollectionsKt.dropLast(list2, (int)1) : null;
                }
                List list3 = splitedPath;
                String preparedPath = list3 != null ? CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) : null;
                URI targetUri = new URIBuilder().setScheme(match.getProtocol()).setHost(match.getHost()).setPort(match.getPort()).setPath(preparedPath).build();
                JupyterNotebookProcessHandler jupyterNotebookProcessHandler = JupyterNotebookProcessHandler.this;
                if (JupyterNotebookProcessHandler.this.targetEnvironment instanceof LocalTargetEnvironment) {
                    Intrinsics.checkNotNull((Object)targetUri);
                    location = new JupyterConnectionParameters.Location.Direct(targetUri);
                } else {
                    Object object2;
                    JupyterNotebookProcessHandler jupyterNotebookProcessHandler2;
                    block14: {
                        $this$filter$iv = JupyterNotebookProcessHandler.this.targetEnvironment.getTargetPortBindings().entrySet();
                        jupyterNotebookProcessHandler2 = jupyterNotebookProcessHandler;
                        for (Map.Entry entry : $this$filter$iv) {
                            boolean bl5 = false;
                            TargetEnvironment.TargetPortBinding binding = (TargetEnvironment.TargetPortBinding)entry.getKey();
                            ResolvedPortBinding localPort = (ResolvedPortBinding)entry.getValue();
                            object2 = binding.getTarget() == targetUri.getPort() ? localPort : null;
                            if (object2 == null) {
                                continue;
                            }
                            break block14;
                        }
                        object2 = null;
                    }
                    if (object2 == null) {
                        throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
                    }
                    jupyterNotebookProcessHandler = jupyterNotebookProcessHandler2;
                    ResolvedPortBinding portBinding = object2;
                    HostPort localEndpoint = portBinding.getLocalEndpoint();
                    URI uRI = new URIBuilder(targetUri).setHost(localEndpoint.getHost()).setPort(localEndpoint.getPort()).build();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
                    Intrinsics.checkNotNull((Object)targetUri);
                    location = new JupyterConnectionParameters.Location.Tunneled(uRI, targetUri);
                }
                jupyterNotebookProcessHandler.location = location;
                JupyterNotebookProcessHandler.this.token = match.getToken();
                JupyterNotebookProcessHandler.this.serverInitLatch.countDown();
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ApplicationManager.getApplication().executeOnPooledThread(() -> JupyterProcessListener.processTerminated$lambda$4(JupyterNotebookProcessHandler.this, event));
            JupyterNotebookProcessHandler.this.location = null;
            JupyterNotebookProcessHandler.this.token = null;
            JupyterNotebookProcessHandler.this.serverPath = null;
        }

        private static final void processTerminated$lambda$4(JupyterNotebookProcessHandler this$0, ProcessEvent $event) {
            this$0.onServerTerminated.invoke((Object)this$0, (Object)$event);
        }
    }
}

