/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthHandler;
import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthHandlerFinder;
import com.intellij.jupyter.core.jupyter.connections.configuration.ManagedServerSettingsForm;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ExtendedManagedServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.LegacyManagedServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ManagedServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.RunConfigurationManagedServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.server.ManagedServerKind;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ComponentPredicate;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/configuration/JupyterServerModuleConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "managedServerSettingsForm", "Lcom/intellij/jupyter/core/jupyter/connections/configuration/ManagedServerSettingsForm;", "url", "", "value", "Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterModuleConnectionSettings;", "savedJupyterConnectionParameters", "getSavedJupyterConnectionParameters", "()Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterModuleConnectionSettings;", "setSavedJupyterConnectionParameters", "(Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterModuleConnectionSettings;)V", "selectedJupyterModuleConnectionSettingsClass", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "Ljava/lang/Class;", "formPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getFormPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "formPanel$delegate", "Lkotlin/Lazy;", "jupyterManagedServerConfClass", "Lcom/intellij/jupyter/core/jupyter/connections/settings/ManagedServerJupyterModuleConnectionSettings;", "createPanel", "apply", "", "isModified", "", "validateOnApply", "reset", "getConnectionParametersFromUI", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterServerModuleConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerModuleConfigurable.kt\ncom/intellij/jupyter/core/jupyter/connections/configuration/JupyterServerModuleConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 5 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,231:1\n1611#2,9:232\n1863#2:241\n1864#2:243\n1620#2:244\n295#2,2:245\n1#3:242\n24#4,6:247\n27#5:253\n*S KotlinDebug\n*F\n+ 1 JupyterServerModuleConfigurable.kt\ncom/intellij/jupyter/core/jupyter/connections/configuration/JupyterServerModuleConfigurable\n*L\n152#1:232,9\n152#1:241\n152#1:243\n152#1:244\n153#1:245,2\n152#1:242\n190#1:247,6\n98#1:253\n*E\n"})
public final class JupyterServerModuleConfigurable
extends BoundConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final ManagedServerSettingsForm managedServerSettingsForm;
    @NotNull
    private String url;
    @NotNull
    private final ObservableMutableProperty<Class<? extends JupyterModuleConnectionSettings>> selectedJupyterModuleConnectionSettingsClass;
    @NotNull
    private final Lazy formPanel$delegate;

    public JupyterServerModuleConfigurable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super("", null);
        this.module = module;
        this.managedServerSettingsForm = new ManagedServerSettingsForm();
        this.url = "";
        this.selectedJupyterModuleConnectionSettingsClass = (ObservableMutableProperty)new AtomicProperty(this.jupyterManagedServerConfClass());
        this.formPanel$delegate = LazyKt.lazy(() -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18(this));
    }

    private final JupyterModuleConnectionSettings getSavedJupyterConnectionParameters() {
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JupyterConnectionParametersSettings.Companion.getInstance(project).getConnectionParametersForModule(this.module);
    }

    private final void setSavedJupyterConnectionParameters(JupyterModuleConnectionSettings value) {
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterConnectionParametersSettings.Companion.getInstance(project).setConnectionParametersForModule(this.module, value);
    }

    private final DialogPanel getFormPanel() {
        Lazy lazy = this.formPanel$delegate;
        return (DialogPanel)lazy.getValue();
    }

    private final Class<? extends ManagedServerJupyterModuleConnectionSettings> jupyterManagedServerConfClass() {
        return switch (WhenMappings.$EnumSwitchMapping$0[ManagedServerKind.Companion.get().ordinal()]) {
            case 1 -> LegacyManagedServerJupyterModuleConnectionSettings.class;
            case 2 -> ExtendedManagedServerJupyterModuleConnectionSettings.class;
            case 3 -> RunConfigurationManagedServerJupyterModuleConnectionSettings.class;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public DialogPanel createPanel() {
        return this.getFormPanel();
    }

    public void apply() {
        boolean modified = this.isModified();
        switch (WhenMappings.$EnumSwitchMapping$0[ManagedServerKind.Companion.get().ordinal()]) {
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                this.getFormPanel().apply();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.validateOnApply();
        super.apply();
        if (modified) {
            try {
                this.setSavedJupyterConnectionParameters(this.getConnectionParametersFromUI());
            }
            catch (ProcessCanceledException t) {
                Messages.showInfoMessage((Project)this.module.getProject(), (String)JupyterBundle.message("Jupyter.server.connection.canceled", new Object[0]), (String)JupyterBundle.message("jupyter.colors.name", new Object[0]));
            }
            catch (Throwable t) {
                Project project = this.module.getProject();
                String string = t.getMessage();
                if (string == null) {
                    string = t.toString();
                }
                Messages.showErrorDialog((Project)project, (String)string, (String)JupyterBundle.message("jupyter.colors.name", new Object[0]));
            }
        }
    }

    public boolean isModified() {
        boolean isManaged = Intrinsics.areEqual((Object)this.selectedJupyterModuleConnectionSettingsClass.get(), this.jupyterManagedServerConfClass());
        boolean isSavedManaged = this.getSavedJupyterConnectionParameters() instanceof ManagedServerJupyterModuleConnectionSettings;
        if (isSavedManaged != isManaged) {
            return true;
        }
        return super.isModified();
    }

    private final void validateOnApply() {
        Object v0;
        block3: {
            Iterator $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.getFormPanel().getValidateCallbacks();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ValidationInfo it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Function0 it = (Function0)element$iv$iv;
                boolean bl2 = false;
                if ((ValidationInfo)it.invoke() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ValidationInfo it = (ValidationInfo)element$iv;
                boolean bl = false;
                if (!(!it.warning)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ValidationInfo validationInfo = v0;
        if (validationInfo != null) {
            ValidationInfo it = validationInfo;
            boolean bl = false;
            throw new ConfigurationException(it.message);
        }
    }

    public void reset() {
        JupyterModuleConnectionSettings it = this.getSavedJupyterConnectionParameters();
        boolean bl = false;
        this.selectedJupyterModuleConnectionSettingsClass.set(this.getSavedJupyterConnectionParameters().getClass());
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings = it;
        if (jupyterModuleConnectionSettings instanceof ManagedServerJupyterModuleConnectionSettings) {
            this.managedServerSettingsForm.reset((ManagedServerJupyterModuleConnectionSettings)it);
        } else if (jupyterModuleConnectionSettings instanceof ConfiguredServerJupyterModuleConnectionSettings) {
            this.url = JupyterServerModuleConfigurable.Companion.persistentConnectionPresentation((ConfiguredServerJupyterModuleConnectionSettings)it);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        super.reset();
    }

    /*
     * WARNING - void declaration
     */
    private final JupyterModuleConnectionSettings getConnectionParametersFromUI() {
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings;
        if (ManagedServerJupyterModuleConnectionSettings.class.isAssignableFrom((Class)this.selectedJupyterModuleConnectionSettingsClass.get())) {
            jupyterModuleConnectionSettings = this.managedServerSettingsForm.getConnectionSettingsFromUI();
        } else if (ConfiguredServerJupyterModuleConnectionSettings.class.isAssignableFrom((Class)this.selectedJupyterModuleConnectionSettingsClass.get())) {
            ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings;
            String text = this.url;
            if (StringsKt.isBlank((CharSequence)text)) {
                throw new RuntimeConfigurationError(JupyterBundle.message("Jupyter.server.url.required", new Object[0]));
            }
            try {
                void title$iv;
                void project$iv;
                URI uri = new URI(text);
                Ref.ObjectRef taskResult = new Ref.ObjectRef();
                Ref.ObjectRef throwable = new Ref.ObjectRef();
                Ref.BooleanRef isCanceled = new Ref.BooleanRef();
                Object object = JupyterBundle.message("Jupyter.servers.verifying.url", new Object[0]);
                Project project = this.module.getProject();
                boolean cancellable$iv = true;
                boolean $i$f$runModalTask = false;
                ProgressManager.getInstance().run((Task)new Task.Modal((Project)project$iv, (String)title$iv, cancellable$iv, taskResult, uri, throwable, isCanceled){
                    final /* synthetic */ Ref.ObjectRef $taskResult$inlined;
                    final /* synthetic */ URI $uri$inlined;
                    final /* synthetic */ Ref.ObjectRef $throwable$inlined;
                    final /* synthetic */ Ref.BooleanRef $isCanceled$inlined;
                    {
                        this.$taskResult$inlined = objectRef;
                        this.$uri$inlined = uRI;
                        this.$throwable$inlined = objectRef2;
                        this.$isCanceled$inlined = booleanRef;
                        super($project, $title, $cancellable);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public void run(ProgressIndicator indicator) {
                        Pair<JupyterAuthHandler, URI> pair;
                        Ref.ObjectRef objectRef;
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator it = indicator;
                        boolean bl = false;
                        Ref.ObjectRef objectRef2 = this.$taskResult$inlined;
                        try {
                            Pair<JupyterAuthHandler, URI> response;
                            objectRef = objectRef2;
                            pair = response = JupyterAuthHandlerFinder.Companion.chooseAppropriate(this.$uri$inlined);
                        }
                        catch (Throwable throwable) {
                            void t;
                            objectRef = objectRef2;
                            this.$throwable$inlined.element = t;
                            pair = null;
                        }
                        finally {
                            this.$isCanceled$inlined.element = it.isCanceled();
                        }
                        objectRef.element = pair;
                    }
                });
                if (isCanceled.element) {
                    throw new ProcessCanceledException();
                }
                object = (Throwable)throwable.element;
                if (object != null) {
                    Object it = object;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{text};
                    throw new IllegalStateException(JupyterBundle.message("Jupyter.server.connection.error", objectArray), (Throwable)it);
                }
                Pair pair = (Pair)taskResult.element;
                if (pair == null) {
                    throw new RuntimeConfigurationError(JupyterBundle.message("Jupyter.server.url.malformed", new Object[0]));
                }
                object = pair;
                JupyterAuthHandler authHandler = (JupyterAuthHandler)object.component1();
                URI fixedUri = (URI)object.component2();
                configuredServerJupyterModuleConnectionSettings = new ConfiguredServerJupyterModuleConnectionSettings(fixedUri, authHandler, false, 4, null);
            }
            catch (MalformedURLException e) {
                Object[] objectArray = new Object[]{String.valueOf(e.getMessage())};
                throw new RuntimeConfigurationError(JupyterBundle.message("Jupyter.server.url.malformed.message", objectArray));
            }
            jupyterModuleConnectionSettings = configuredServerJupyterModuleConnectionSettings;
        } else {
            throw new IllegalStateException("Unexpected class " + this.selectedJupyterModuleConnectionSettingsClass);
        }
        return jupyterModuleConnectionSettings;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9$lambda$1$lambda$0(LinkedHashMap $elements, SegmentedButton.ItemPresentation $this$segmentedButton, Class cls) {
        Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        String string = (String)$elements.get(cls);
        if (string == null) {
            string = "";
        }
        $this$segmentedButton.setText(string);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9$lambda$1(JupyterServerModuleConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Pair[] pairArray = new Pair[]{TuplesKt.to(this$0.jupyterManagedServerConfClass(), (Object)JupyterBundle.message("Jupyter.servers.use.managed.server", new Object[0])), TuplesKt.to(ConfiguredServerJupyterModuleConnectionSettings.class, (Object)JupyterBundle.message("Jupyter.servers.configured.server.no.colon", new Object[0]))};
        LinkedHashMap elements = MapsKt.linkedMapOf((Pair[])pairArray);
        Set set = elements.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        $this$row.segmentedButton((Collection)set, (arg_0, arg_1) -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$1$lambda$0(elements, arg_0, arg_1)).bind(this$0.selectedJupyterModuleConnectionSettingsClass);
        return Unit.INSTANCE;
    }

    private static final boolean formPanel_delegate$lambda$18$lambda$9$lambda$2(JupyterServerModuleConfigurable this$0, Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, this$0.jupyterManagedServerConfClass());
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9$lambda$4$lambda$3(JupyterServerModuleConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ManagedServerSettingsForm managedServerSettingsForm = this$0.managedServerSettingsForm;
        Module module = this$0.module;
        ComponentPredicate componentPredicate = ComponentPredicate.Companion.getTRUE();
        Disposable disposable = this$0.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        ManagedServerSettingsForm.Companion.managedSettingsPanel($this$panel, managedServerSettingsForm, module, componentPredicate, disposable);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9$lambda$4(ObservableProperty $isManagedServerVisible, JupyterServerModuleConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$4$lambda$3(this$0, arg_0)).visibleIf($isManagedServerVisible);
        return Unit.INSTANCE;
    }

    private static final String formPanel_delegate$lambda$18$lambda$9$lambda$8$lambda$5(JupyterServerModuleConfigurable this$0) {
        return this$0.url;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9$lambda$8$lambda$6(JupyterServerModuleConfigurable this$0, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.url = ((Object)StringsKt.trim((CharSequence)value)).toString();
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9$lambda$8$lambda$7(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getEmptyText().setText(JupyterBundle.message("jupyter.server.url.prompt", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9$lambda$8(JupyterServerModuleConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)$this$row.textField().align((Align)AlignX.FILL.INSTANCE), () -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$8$lambda$5(this$0), arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$8$lambda$6(this$0, arg_0)).applyToComponent(JupyterServerModuleConfigurable::formPanel_delegate$lambda$18$lambda$9$lambda$8$lambda$7);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$9(JupyterServerModuleConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$1(this$0, arg_0), (int)1, null);
        ObservableProperty isManagedServerVisible = PropertyOperationUtil.transform((ObservableProperty)((ObservableProperty)this$0.selectedJupyterModuleConnectionSettingsClass), arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$2(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$4(isManagedServerVisible, this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9$lambda$8(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED).visibleIf(PropertyOperationUtil.not((ObservableProperty)isManagedServerVisible));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$10(Ref.ObjectRef $rbManagedServer, JupyterServerModuleConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $rbManagedServer.element = $this$row.radioButton(JupyterBundle.message("Jupyter.servers.use.managed.server", new Object[0]), this$0.jupyterManagedServerConfClass());
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$11(JupyterServerModuleConfigurable this$0, Ref.ObjectRef $rbManagedServer, Panel $this$indent) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        ManagedServerSettingsForm managedServerSettingsForm = this$0.managedServerSettingsForm;
        Module module = this$0.module;
        if ($rbManagedServer.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rbManagedServer");
            cell = null;
        } else {
            cell = (Cell)$rbManagedServer.element;
        }
        ComponentPredicate componentPredicate = ButtonKt.getSelected((Cell)cell);
        Disposable disposable = this$0.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        ManagedServerSettingsForm.Companion.managedSettingsPanel($this$indent, managedServerSettingsForm, module, componentPredicate, disposable);
        return Unit.INSTANCE;
    }

    private static final String formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15$lambda$12(JupyterServerModuleConfigurable this$0) {
        return this$0.url;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15$lambda$13(JupyterServerModuleConfigurable this$0, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.url = ((Object)StringsKt.trim((CharSequence)value)).toString();
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getEmptyText().setText(JupyterBundle.message("jupyter.server.url.prompt", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15(JupyterServerModuleConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell rbConfiguredServer = $this$row.radioButton(JupyterBundle.message("Jupyter.servers.configured.server", new Object[0]), ConfiguredServerJupyterModuleConnectionSettings.class);
        TextFieldKt.bindText((Cell)$this$row.textField().align((Align)AlignX.FILL.INSTANCE), () -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15$lambda$12(this$0), arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15$lambda$13(this$0, arg_0)).enabledIf(ButtonKt.getSelected((Cell)rbConfiguredServer)).applyToComponent(JupyterServerModuleConfigurable::formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$18$lambda$17$lambda$16(JupyterServerModuleConfigurable this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Ref.ObjectRef rbManagedServer = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$10(rbManagedServer, this$0, arg_0), (int)1, null);
        $this$buttonsGroup.indent(arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$11(this$0, rbManagedServer, arg_0));
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$17$lambda$16$lambda$15(this$0, arg_0), (int)1, null).layout(RowLayout.LABEL_ALIGNED);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit formPanel_delegate$lambda$18$lambda$17(JupyterServerModuleConfigurable this$0, Panel $this$panel) {
        void getter$iv;
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$17$lambda$16(this$0, arg_0), (int)3, null);
        Function0 function0 = (Function0)new Function0<Class<? extends JupyterModuleConnectionSettings>>(this$0.selectedJupyterModuleConnectionSettingsClass){

            public final Class<? extends JupyterModuleConnectionSettings> invoke() {
                return (Class)((ObservableMutableProperty)this.receiver).get();
            }
        };
        Function1 setter$iv = (Function1)new Function1<Class<? extends JupyterModuleConnectionSettings>, Unit>(this$0.selectedJupyterModuleConnectionSettingsClass){

            public final void invoke(Class<? extends JupyterModuleConnectionSettings> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((ObservableMutableProperty)this.receiver).set(p0);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Class.class);
        return Unit.INSTANCE;
    }

    private static final DialogPanel formPanel_delegate$lambda$18(JupyterServerModuleConfigurable this$0) {
        boolean useNewLayout = Registry.Companion.is("jupyter.server.form.segmented.buttons");
        return useNewLayout ? BuilderKt.panel(arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$9(this$0, arg_0)) : BuilderKt.panel(arg_0 -> JupyterServerModuleConfigurable.formPanel_delegate$lambda$18$lambda$17(this$0, arg_0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/configuration/JupyterServerModuleConfigurable$Companion;", "", "<init>", "()V", "persistentConnectionPresentation", "", "Lcom/intellij/jupyter/core/jupyter/connections/settings/ConfiguredServerJupyterModuleConnectionSettings;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String persistentConnectionPresentation(ConfiguredServerJupyterModuleConnectionSettings $this$persistentConnectionPresentation) {
            String string = $this$persistentConnectionPresentation.getUri().toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCIIString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ManagedServerKind.values().length];
            try {
                nArray[ManagedServerKind.LEGACY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManagedServerKind.EXTENDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManagedServerKind.RUN_CONF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

