/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.AsyncOutputDetector;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellOutputUtils;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.callbacks.JupyterExecutionCallbackData;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.OtherKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerConcurrentMap;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableRunnable;
import java.lang.ref.WeakReference;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b\u0011\u0010\u0012J&\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ%\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#JU\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010%\u001a\u00060\u001fj\u0002`&2\u0006\u0010'\u001a\u00020(2\u0010\u0010)\u001a\f\u0012\b\u0012\u00060\u001fj\u0002`&0*2\u0014\b\u0004\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u000e0\nH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b-J%\u0010.\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b1J#\u00102\u001a\b\u0012\u0004\u0012\u0002030\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b4J\u0017\u00105\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b6R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00067"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterCellOutputUtils;", "", "<init>", "()V", "dateWithOffsetFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "Ljava/time/format/DateTimeFormatter;", "dateTimeParsers", "", "Lkotlin/Function1;", "", "Ljava/time/ZonedDateTime;", "clearOutputIfNecessary", "", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "clearOutputIfNecessary$intellij_jupyter_core", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearOutput", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "setExecuting", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getCellOutputsTextToCopy", "notebookVirtualFile", "cellIndex", "", "setNextInput", "text", "replace", "setNextInput$intellij_jupyter_core", "updateCell", "taskId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/TaskId;", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "lastTaskIdForCell", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;", "doUpdate", "Lcom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterExecutionCallbackData;", "updateCell$intellij_jupyter_core", "hasAsyncOutput", "jupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "hasAsyncOutput$intellij_jupyter_core", "getAllEditorsByJupyterVirtualFile", "Lcom/intellij/openapi/editor/Editor;", "getAllEditorsByJupyterVirtualFile$intellij_jupyter_core", "getMessageTime", "getMessageTime$intellij_jupyter_core", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCellOutputUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCellOutputUtils.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/JupyterCellOutputUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,180:1\n1611#2,9:181\n1863#2:190\n1864#2:192\n1620#2:193\n1611#2,9:194\n1863#2:203\n1864#2:205\n1620#2:206\n1557#2:207\n1628#2,3:208\n1#3:191\n1#3:204\n24#4:211\n24#4:212\n*S KotlinDebug\n*F\n+ 1 JupyterCellOutputUtils.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/JupyterCellOutputUtils\n*L\n70#1:181,9\n70#1:190\n70#1:192\n70#1:193\n146#1:194,9\n146#1:203\n146#1:205\n146#1:206\n147#1:207\n147#1:208,3\n70#1:191\n146#1:204\n161#1:211\n175#1:212\n*E\n"})
public final class JupyterCellOutputUtils {
    @NotNull
    public static final JupyterCellOutputUtils INSTANCE = new JupyterCellOutputUtils();
    private static final DateTimeFormatter dateWithOffsetFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmZ");
    @NotNull
    private static final List<Function1<String, ZonedDateTime>> dateTimeParsers;

    private JupyterCellOutputUtils() {
    }

    @Nullable
    public final Object clearOutputIfNecessary$intellij_jupyter_core(@NotNull JupyterExecutionTask task2, @NotNull Continuation<? super Unit> $completion) {
        if (!task2.getOptions().getCleanOutput()) {
            return Unit.INSTANCE;
        }
        Object object = CoroutinesKt.writeAction(() -> JupyterCellOutputUtils.clearOutputIfNecessary$lambda$1(task2), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void clearOutput(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, boolean setExecuting, @NotNull NotebookIntervalPointer cellPointer) {
        JupyterCell jupyterCell;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return;
        }
        int index = interval.getOrdinal();
        JupyterNotebook notebook = notebookFile.getNotebook();
        JupyterCell $this$clearOutput_u24lambda_u242 = jupyterCell = notebook.getCell(index);
        boolean bl = false;
        $this$clearOutput_u24lambda_u242.setExecutionCount(null);
        $this$clearOutput_u24lambda_u242.setOutputs(null);
        $this$clearOutput_u24lambda_u242.setExecuting(setExecuting);
        $this$clearOutput_u24lambda_u242.setExecutionStartTime(null);
        if (!setExecuting) {
            JupyterInlayProgressStatusManager.Companion.getInstance(project).clearStatusForCell(cellPointer, notebookFile);
        }
        JupyterListenersKt.outputUpdated(notebook, cellPointer);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getCellOutputsTextToCopy(@NotNull BackedNotebookVirtualFile notebookVirtualFile, int cellIndex) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        JupyterNotebook notebook = notebookVirtualFile.getNotebook();
        JupyterCell jupyterCell = notebook.getCell(cellIndex);
        JupyterOutputs jupyterOutputs = jupyterCell.getOutputs();
        if (jupyterOutputs == null) {
            return null;
        }
        JupyterOutputs outputs = jupyterOutputs;
        Iterable iterable = outputs.getOutputs();
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JupyterOutput it = (JupyterOutput)element$iv$iv;
            boolean bl2 = false;
            if (it.getTextForCopy() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public final void setNextInput$intellij_jupyter_core(@NotNull JupyterExecutionTask task2, @NotNull String text, boolean replace) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        WriteAction.run(() -> JupyterCellOutputUtils.setNextInput$lambda$5(task2, replace, text));
    }

    public final void updateCell$intellij_jupyter_core(@NotNull JupyterExecutionTask task2, int taskId, @NotNull JupyterMessage message2, @NotNull NotebookIntervalPointerConcurrentMap<Integer> lastTaskIdForCell, @NotNull Function1<? super JupyterExecutionCallbackData, Unit> doUpdate) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter(lastTaskIdForCell, (String)"lastTaskIdForCell");
        Intrinsics.checkNotNullParameter(doUpdate, (String)"doUpdate");
        boolean $i$f$updateCell$intellij_jupyter_core = false;
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable(task2, lastTaskIdForCell, taskId, message2, doUpdate){
            final /* synthetic */ JupyterExecutionTask $task;
            final /* synthetic */ NotebookIntervalPointerConcurrentMap<Integer> $lastTaskIdForCell;
            final /* synthetic */ int $taskId;
            final /* synthetic */ JupyterMessage $message;
            final /* synthetic */ Function1<JupyterExecutionCallbackData, Unit> $doUpdate;
            {
                this.$task = $task;
                this.$lastTaskIdForCell = $lastTaskIdForCell;
                this.$taskId = $taskId;
                this.$message = $message;
                this.$doUpdate = $doUpdate;
            }

            public final void run() {
                Project project = this.$task.getProject();
                if (!(this.$task.getOptions().getCellPointer() != null)) {
                    boolean $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = false;
                    String $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = "Jupyter task without cell couldn't update output";
                    throw new IllegalArgumentException($i$a$-require-JupyterCellOutputUtils$updateCell$1$22.toString());
                }
                if (this.$task.isValid() && project != null) {
                    Integer n = (Integer)this.$lastTaskIdForCell.get(this.$task.getOptions().getCellPointer());
                    int $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = this.$taskId;
                    boolean isLastTaskForCell = n != null && n == $i$a$-require-JupyterCellOutputUtils$updateCell$1$22;
                    JupyterExecutionCallbackData updateData = new JupyterExecutionCallbackData(this.$task, this.$message, project, isLastTaskForCell);
                    this.$doUpdate.invoke((Object)updateData);
                }
            }
        });
    }

    public final boolean hasAsyncOutput$intellij_jupyter_core(@NotNull Project project, @NotNull JupyterExecutionTask task2, @NotNull JupyterCell jupyterCell) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)jupyterCell, (String)"jupyterCell");
        NotebookIntervalPointer notebookIntervalPointer = task2.getOptions().getCellPointer();
        if (notebookIntervalPointer == null) {
            return false;
        }
        NotebookIntervalPointer cellPointer = notebookIntervalPointer;
        Object object = jupyterCell.getOutputs();
        if (object == null || (object = object.getOutputs()) == null) {
            return false;
        }
        Object outputSequence = object;
        JupyterOutput jupyterOutput = (JupyterOutput)CollectionsKt.lastOrNull((List)outputSequence);
        if (jupyterOutput == null) {
            return false;
        }
        JupyterOutput output = jupyterOutput;
        boolean hasOutputInCurrentSession = JupyterInlayProgressStatusManager.Companion.hasOutputInCurrentSession(project, task2.getVirtualFileForSession(), cellPointer);
        return AsyncOutputDetector.Companion.isAsyncOutput(output, hasOutputInCurrentSession);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Editor> getAllEditorsByJupyterVirtualFile$intellij_jupyter_core(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        List list;
        boolean bl;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditor[] fileEditorArray = fileEditorManager.getAllEditors(notebookVirtualFile.getOriginFile());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Set allEditors = ArraysKt.toMutableSet((Object[])fileEditorArray);
        if (!JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            Collection collection = allEditors;
            FileEditor[] fileEditorArray2 = fileEditorManager.getAllEditors(notebookVirtualFile.getFile());
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray2, (String)"getAllEditors(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])fileEditorArray2);
        }
        Iterable iterable = allEditors;
        boolean $i$f$mapNotNull = false;
        void var8_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            JupyterFileEditor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl2 = false;
            FileEditor it = (FileEditor)element$iv$iv;
            boolean bl3 = false;
            if ((it instanceof JupyterFileEditor ? (JupyterFileEditor)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fileEditor;
            object = (JupyterFileEditor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(fileEditor.getEditor());
        }
        List result2 = (List)destination$iv$iv;
        WeakReference weakReference = (WeakReference)notebookVirtualFile.getFile().getUserData(OtherKt.getJUPYTER_EDITOR_KEY());
        Editor jupyterConsoleEditor = weakReference != null ? (Editor)weakReference.get() : null;
        boolean bl6 = bl = jupyterConsoleEditor != null;
        if (bl) {
            list = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)result2, (Object)jupyterConsoleEditor));
        } else if (!bl) {
            list = CollectionsKt.distinct((Iterable)result2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Nullable
    public final ZonedDateTime getMessageTime$intellij_jupyter_core(@NotNull JupyterMessage message2) {
        ZonedDateTime result2;
        String messageDate;
        block5: {
            ZonedDateTime zonedDateTime;
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            messageDate = message2.getHeader().getDate();
            if (messageDate == null) {
                JupyterCellOutputUtils $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterCellOutputUtils.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Message time isn't specified in the message");
                return null;
            }
            for (Function1 parser : (Iterable)dateTimeParsers) {
                ZonedDateTime zonedDateTime2;
                ZonedDateTime zonedDateTime3;
                boolean bl = false;
                try {
                    zonedDateTime3 = (ZonedDateTime)parser.invoke((Object)messageDate);
                }
                catch (DateTimeParseException ex) {
                    zonedDateTime3 = null;
                }
                if ((zonedDateTime2 = zonedDateTime3) == null) continue;
                zonedDateTime = zonedDateTime2;
                break block5;
            }
            zonedDateTime = result2 = null;
        }
        if (result2 == null) {
            JupyterCellOutputUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterCellOutputUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot parse message time from '" + messageDate + "'");
        }
        return result2;
    }

    private static final ZonedDateTime dateTimeParsers$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ZonedDateTime.parse(it, dateWithOffsetFormatter);
    }

    private static final Unit clearOutputIfNecessary$lambda$1(JupyterExecutionTask $task) {
        Project project = $task.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        NotebookIntervalPointer notebookIntervalPointer = $task.getOptions().getCellPointer();
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
            return Unit.INSTANCE;
        }
        notebookIntervalPointer.getOrdinal();
        INSTANCE.clearOutput(project2, $task.getNotebookVirtualFile(), true, $task.getOptions().getCellPointer());
        return Unit.INSTANCE;
    }

    private static final void setNextInput$lambda$5$lambda$4(boolean $replace, Document $document, NotebookCellLines.Interval $interval, int $lastOffset, String $text) {
        if ($replace) {
            int firstOffset = $document.getLineStartOffset($interval.getFirstContentLine());
            $document.replaceString(firstOffset, $lastOffset, (CharSequence)$text);
        } else {
            $document.insertString($lastOffset, (CharSequence)("\n#%%\n" + $text));
        }
    }

    private static final void setNextInput$lambda$5(JupyterExecutionTask $task, boolean $replace, String $text) {
        Project project = $task.getProject();
        NotebookIntervalPointer cellPointer = $task.getOptions().getCellPointer();
        if ($task.isValid() && project != null) {
            NotebookIntervalPointer notebookIntervalPointer = cellPointer;
            if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
                return;
            }
            NotebookIntervalPointer interval = notebookIntervalPointer;
            Object[] objectArray = FileEditorManager.getInstance((Project)project).getEditors($task.getNotebookVirtualFile().getFile());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getEditors(...)");
            Object[] editors = objectArray;
            Object object = ArraysKt.firstOrNull((Object[])editors);
            TextEditor textEditor = object instanceof TextEditor ? (TextEditor)object : null;
            if (textEditor == null) {
                return;
            }
            TextEditor textEditor2 = textEditor;
            Document document = textEditor2.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int lastOffset = document2.getLineEndOffset(interval.getLastContentLine());
            WriteCommandAction.writeCommandAction((Project)project).withName("set_next_input").run(() -> JupyterCellOutputUtils.setNextInput$lambda$5$lambda$4($replace, document2, (NotebookCellLines.Interval)interval, lastOffset, $text));
        }
    }

    static {
        Object[] objectArray = new Function1[]{dateTimeParsers.1.INSTANCE, JupyterCellOutputUtils::dateTimeParsers$lambda$0};
        dateTimeParsers = CollectionsKt.listOf((Object[])objectArray);
    }
}

