/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.callbacks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.connections.execution.IntrospectionInfoReadyCallback;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellOutputUtils;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatusKt;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.MessageTracker;
import com.intellij.jupyter.core.jupyter.connections.execution.callbacks.JupyterExecutionCallbackData;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallbackAdapter;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageChannel;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageHeader;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputsBaseKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerConcurrentMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableRunnable;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J9\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterCellExecuteReplyCallback;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallbackAdapter;", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "taskId", "", "Lcom/intellij/jupyter/core/jupyter/connections/execution/TaskId;", "lastTaskIdForCell", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;", "messageTracker", "Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker;", "lastStoppedTimeForCell", "Ljava/time/ZonedDateTime;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;ILcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker;Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;)V", "channel", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "getChannel", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "onExecuteReply", "", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "processPayload", "payload", "Lcom/fasterxml/jackson/databind/JsonNode;", "doUpdate", "data", "Lcom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterExecutionCallbackData;", "handleExecutionForLastTask", "jupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "executionStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "project", "Lcom/intellij/openapi/project/Project;", "isCellEmpty", "", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;Lcom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterExecutionCallbackData;Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;)V", "handleAsyncOutput", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCellExecuteReplyCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCellExecuteReplyCallback.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterCellExecuteReplyCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 JupyterCellOutputUtils.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/JupyterCellOutputUtils\n*L\n1#1,108:1\n1#2:109\n1863#3,2:110\n106#4,11:112\n*S KotlinDebug\n*F\n+ 1 JupyterCellExecuteReplyCallback.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterCellExecuteReplyCallback\n*L\n46#1:110,2\n38#1:112,11\n*E\n"})
public final class JupyterCellExecuteReplyCallback
extends JupyterExecutionCallbackAdapter {
    @NotNull
    private final JupyterExecutionTask task;
    private final int taskId;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<Integer> lastTaskIdForCell;
    @NotNull
    private final MessageTracker messageTracker;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<ZonedDateTime> lastStoppedTimeForCell;
    @NotNull
    private final JupyterMessageChannel channel;

    public JupyterCellExecuteReplyCallback(@NotNull JupyterExecutionTask task2, int taskId, @NotNull NotebookIntervalPointerConcurrentMap<Integer> lastTaskIdForCell, @NotNull MessageTracker messageTracker, @NotNull NotebookIntervalPointerConcurrentMap<ZonedDateTime> lastStoppedTimeForCell) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter(lastTaskIdForCell, (String)"lastTaskIdForCell");
        Intrinsics.checkNotNullParameter((Object)messageTracker, (String)"messageTracker");
        Intrinsics.checkNotNullParameter(lastStoppedTimeForCell, (String)"lastStoppedTimeForCell");
        this.task = task2;
        this.taskId = taskId;
        this.lastTaskIdForCell = lastTaskIdForCell;
        this.messageTracker = messageTracker;
        this.lastStoppedTimeForCell = lastStoppedTimeForCell;
        if (!(this.task.getOptions().getCellPointer() != null)) {
            boolean bl = false;
            String string = "Jupyter task without cell couldn't update output";
            throw new IllegalArgumentException(string.toString());
        }
        this.channel = JupyterMessageChannel.SHELL;
    }

    @Override
    @NotNull
    public JupyterMessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public void onExecuteReply(@NotNull JupyterMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ApplicationManager.getApplication().invokeLater(() -> JupyterCellExecuteReplyCallback.onExecuteReply$lambda$2(message2, this));
    }

    private final void processPayload(JsonNode payload) {
        ArrayNode arrayNode = payload instanceof ArrayNode ? (ArrayNode)payload : null;
        if (arrayNode == null) {
            return;
        }
        ArrayNode arrayNode2 = arrayNode;
        Iterable $this$forEach$iv = (Iterable)arrayNode2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ObjectNode objectNode;
            JsonNode it = (JsonNode)element$iv;
            boolean bl = false;
            if ((it instanceof ObjectNode ? (ObjectNode)it : null) == null) {
                return;
            }
            objectNode = objectNode;
            JsonNode jsonNode = objectNode.get("source");
            if (!Intrinsics.areEqual((Object)(jsonNode != null ? jsonNode.asText() : null), (Object)"set_next_input") || (object = objectNode.get("text")) == null || (object = object.asText()) == null) continue;
            Object text = object;
            JsonNode jsonNode2 = objectNode.get("replace");
            if (jsonNode2 == null) {
                continue;
            }
            boolean replace = jsonNode2.asBoolean();
            JupyterCellOutputUtils.INSTANCE.setNextInput$intellij_jupyter_core(this.task, (String)text, replace);
        }
    }

    private final void doUpdate(JupyterExecutionCallbackData data) {
        JupyterCell jupyterCell;
        JupyterExecutionStatus executionStatus = JupyterExecutionStatusKt.getStatus(data.getMessage());
        JupyterCell jupyterCell2 = jupyterCell = data.getJupyterCell();
        CharSequence charSequence = jupyterCell2 != null ? jupyterCell2.getSource() : null;
        boolean isCellEmpty = charSequence == null || charSequence.length() == 0;
        Project project = data.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        this.handleExecutionForLastTask(jupyterCell, executionStatus, data, project2, isCellEmpty);
        Object object = data.getMessage().getParentHeader();
        if (object == null || (object = object.getSession-nLGbpMM()) == null) {
            return;
        }
        Object sessionId = object;
        this.handleAsyncOutput(project2, data);
        JupyterMessageHeader jupyterMessageHeader = data.getMessage().getParentHeader();
        if (jupyterMessageHeader == null) {
            return;
        }
        String messageId = jupyterMessageHeader.getMessageId-j9c_AtQ();
        boolean executionFinished = this.messageTracker.handleExecutionFinished-d3ImeOY((String)sessionId, messageId, project2, data.getTask().getNotebookVirtualFile());
        boolean underDebugger = JupyterDebugger.INSTANCE.isUnderDebugger(project2, data.getTask().getNotebookVirtualFile());
        if (executionFinished && !underDebugger) {
            ((JupyterCellExecutionListener)project2.getMessageBus().syncPublisher(JupyterCellExecutionListener.Companion.getTOPIC())).executionFinished(data.getTask().getNotebookVirtualFile());
        }
    }

    private final void handleExecutionForLastTask(JupyterCell jupyterCell, JupyterExecutionStatus executionStatus, JupyterExecutionCallbackData data, Project project, Boolean isCellEmpty) {
        if (Intrinsics.areEqual((Object)data.isLastTaskForCell(), (Object)false)) {
            return;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        if (jupyterCell2 != null) {
            jupyterCell2.setExecutionCount(executionStatus != JupyterExecutionStatus.ABORTED && Intrinsics.areEqual((Object)isCellEmpty, (Object)false) ? JupyterExecutionStatusKt.getExecutionCount(data.getMessage()) : null);
        }
        JupyterCell jupyterCell3 = jupyterCell;
        if (jupyterCell3 != null) {
            jupyterCell3.setExecuting(false);
        }
        if (executionStatus == JupyterExecutionStatus.ABORTED) {
            return;
        }
        String info = JupyterOutputsBaseKt.getIntrospectionInfo(data.getMessage());
        CharSequence charSequence = info;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        for (IntrospectionInfoReadyCallback callback2 : IntrospectionInfoReadyCallback.Companion.getEP_NAME().getExtensionList()) {
            callback2.introspectionInfoReady(project, info);
        }
    }

    private final void handleAsyncOutput(Project project, JupyterExecutionCallbackData data) {
        if (Intrinsics.areEqual((Object)data.isLastTaskForCell(), (Object)false)) {
            return;
        }
        ZonedDateTime zonedDateTime = JupyterCellOutputUtils.INSTANCE.getMessageTime$intellij_jupyter_core(data.getMessage());
        if (zonedDateTime == null) {
            zonedDateTime = ZonedDateTime.now();
        }
        ZonedDateTime endTime = zonedDateTime;
        NotebookIntervalPointer notebookIntervalPointer = data.getCellPointer();
        Intrinsics.checkNotNull((Object)endTime);
        this.lastStoppedTimeForCell.set(notebookIntervalPointer, (Object)endTime);
        JupyterInlayProgressStatusManager.Companion.getInstance(project).executionStopped(data.getCellPointer(), data.getTask().getNotebookVirtualFile(), JupyterExecutionStatusKt.getStatus(data.getMessage()), endTime);
    }

    /*
     * WARNING - void declaration
     */
    private static final void onExecuteReply$lambda$2(JupyterMessage $message, JupyterCellExecuteReplyCallback this$0) {
        void taskId$iv;
        void task$iv;
        JsonNode jsonNode = $message.getMessageContent().get("payload");
        if (jsonNode != null) {
            JsonNode it = jsonNode;
            boolean bl = false;
            this$0.processPayload(it);
        }
        JupyterCellOutputUtils jupyterCellOutputUtils = JupyterCellOutputUtils.INSTANCE;
        JupyterExecutionTask jupyterExecutionTask = this$0.task;
        int it = this$0.taskId;
        NotebookIntervalPointerConcurrentMap<Integer> lastTaskIdForCell$iv = this$0.lastTaskIdForCell;
        boolean $i$f$updateCell$intellij_jupyter_core = false;
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable((JupyterExecutionTask)task$iv, lastTaskIdForCell$iv, (int)taskId$iv, $message, this$0){
            final /* synthetic */ JupyterExecutionTask $task;
            final /* synthetic */ NotebookIntervalPointerConcurrentMap $lastTaskIdForCell;
            final /* synthetic */ int $taskId;
            final /* synthetic */ JupyterMessage $message;
            final /* synthetic */ JupyterCellExecuteReplyCallback $receiver$inlined;
            {
                this.$task = $task;
                this.$lastTaskIdForCell = $lastTaskIdForCell;
                this.$taskId = $taskId;
                this.$message = $message;
                this.$receiver$inlined = jupyterCellExecuteReplyCallback;
            }

            public final void run() {
                Project project = this.$task.getProject();
                if (!(this.$task.getOptions().getCellPointer() != null)) {
                    boolean $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = false;
                    String $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = "Jupyter task without cell couldn't update output";
                    throw new IllegalArgumentException($i$a$-require-JupyterCellOutputUtils$updateCell$1$22.toString());
                }
                if (this.$task.isValid() && project != null) {
                    JupyterExecutionCallbackData updateData;
                    Integer n = (Integer)this.$lastTaskIdForCell.get(this.$task.getOptions().getCellPointer());
                    int $i$a$-require-JupyterCellOutputUtils$updateCell$1$22 = this.$taskId;
                    boolean isLastTaskForCell = n != null && n == $i$a$-require-JupyterCellOutputUtils$updateCell$1$22;
                    JupyterExecutionCallbackData p0 = updateData = new JupyterExecutionCallbackData(this.$task, this.$message, project, isLastTaskForCell);
                    boolean bl = false;
                    boolean $i$f$onExecuteReply$lambda$2$stub_for_inlining = false;
                    JupyterCellExecuteReplyCallback.access$doUpdate(this.$receiver$inlined, p0);
                }
            }
        });
        this$0.getFinalizeCallback().invoke();
    }

    public static final /* synthetic */ void access$doUpdate(JupyterCellExecuteReplyCallback $this, JupyterExecutionCallbackData data) {
        $this.doUpdate(data);
    }
}

