/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.core;

import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServers;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServersFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterServersImpl;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterServers;", "<init>", "()V", "servers", "", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterServer;", "getServer", "connectionParameters", "reset", "", "dispose", "intellij.jupyter.core"})
public final class JupyterServersImpl
implements JupyterServers {
    @NotNull
    private final Map<JupyterConnectionParameters, JupyterServer> servers = new ConcurrentHashMap();

    @Override
    @NotNull
    public JupyterServer getServer(@NotNull JupyterConnectionParameters connectionParameters) {
        Intrinsics.checkNotNullParameter((Object)connectionParameters, (String)"connectionParameters");
        JupyterServer newInstance = JupyterServersFactory.Companion.create(connectionParameters);
        JupyterServer jupyterServer = this.servers.putIfAbsent(connectionParameters, newInstance);
        if (jupyterServer == null) {
            JupyterServersImpl $this$getServer_u24lambda_u240 = this;
            boolean bl = false;
            Disposer.register((Disposable)$this$getServer_u24lambda_u240, (Disposable)newInstance);
            ((JupyterServers.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JupyterServers.Listener.TOPIC)).created(connectionParameters, newInstance);
            jupyterServer = newInstance;
        }
        return jupyterServer;
    }

    @Override
    public void reset() {
        for (Pair pair : MapsKt.toList(this.servers)) {
            JupyterConnectionParameters key = (JupyterConnectionParameters)pair.component1();
            JupyterServer server2 = (JupyterServer)pair.component2();
            this.servers.remove(key);
            Disposer.dispose((Disposable)server2);
        }
    }

    public void dispose() {
        this.reset();
    }
}

