/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.http;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.jupyter.connections.http.AuthHttpClient;
import com.intellij.jupyter.core.jupyter.connections.http.HttpSession;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/http/JupyterRest;", "", "<init>", "()V", "execRequest", "Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession$Response;", "", "uri", "Ljava/net/URI;", "execRequest$intellij_jupyter_core", "getStringResponse", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRest.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterRest\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n40#2,3:51\n11165#3:54\n11500#3,3:55\n24#4:58\n61#4,5:59\n24#4:64\n68#4,4:65\n*S KotlinDebug\n*F\n+ 1 JupyterRest.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterRest\n*L\n16#1:51,3\n27#1:54\n27#1:55,3\n32#1:58\n32#1:59,5\n36#1:64\n36#1:65,4\n*E\n"})
public final class JupyterRest {
    @NotNull
    public static final JupyterRest INSTANCE = new JupyterRest();

    private JupyterRest() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final HttpSession.Response<String> execRequest$intellij_jupyter_core(@NotNull URI uri) {
        void $this$trace$iv;
        void $this$debug_u24default$iv;
        Collection collection;
        Charset $this$mapTo$iv$iv;
        ProgressIndicator indicator;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        boolean $i$f$service = false;
        Class<AuthHttpClient> serviceClass$iv = AuthHttpClient.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CloseableHttpClient httpClient = ((AuthHttpClient)object).getClient();
        ProgressIndicator progressIndicator = indicator = ProgressManager.getInstance().getProgressIndicator();
        boolean bl = progressIndicator != null ? progressIndicator.isCanceled() : false;
        if (bl) {
            return null;
        }
        HttpGet request = new HttpGet(uri);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        ProgressIndicator progressIndicator2 = indicator;
        boolean bl2 = progressIndicator2 != null ? progressIndicator2.isCanceled() : false;
        if (bl2) {
            return null;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        Header[] headerArray = response.getAllHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"getAllHeaders(...)");
        Object[] $this$map$iv = headerArray;
        boolean $i$f$map22 = false;
        Object[] objectArray = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.length);
        int $i$f$mapTo = 0;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            Header header = (Header)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(TuplesKt.to((Object)string2, (Object)it.getValue()));
        }
        List headers = (List)destination$iv$iv;
        InputStream inputStream = response.getEntity().getContent();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
        InputStream $i$f$map22 = inputStream;
        $this$mapTo$iv$iv = Charsets.UTF_8;
        destination$iv$iv = new InputStreamReader($i$f$map22, $this$mapTo$iv$iv);
        $i$f$mapTo = 8192;
        String body = TextStreamsKt.readText((Reader)(destination$iv$iv instanceof BufferedReader ? (BufferedReader)destination$iv$iv : new BufferedReader((Reader)destination$iv$iv, $i$f$mapTo)));
        JupyterRest $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterRest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            collection = $this$debug_u24default$iv;
            boolean bl4 = false;
            collection.debug("Trying to choose an appropriate Jupyter auth handler for `" + JupyterHttpSessionRestUtilsKt.getObfuscated(uri) + "`. " + JupyterHttpSessionRestUtilsKt.getObfuscated(new HttpSession.Response<ByteArrayInputStream>(statusCode, headers, new ByteArrayInputStream(new byte[0]))), e$iv);
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(JupyterRest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        $this$thisLogger$iv = logger2;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            collection = $this$trace$iv;
            boolean bl5 = false;
            collection.trace("Body of the response for `" + JupyterHttpSessionRestUtilsKt.getObfuscated(uri) + "`: " + body);
        }
        return new HttpSession.Response<String>(statusCode, headers, body);
    }

    @Nullable
    public final String getStringResponse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        HttpSession.Response<String> response = this.execRequest$intellij_jupyter_core(uri);
        if (response == null) {
            return null;
        }
        HttpSession.Response<String> response2 = response;
        if (response2.getStatusCode() != 200) {
            return null;
        }
        return response2.getBody();
    }
}

