/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.ui;

import com.intellij.CommonBundle;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterKernelDoesNotExistsException;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterKernelSpecMissingException;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterManagedServerExited;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterResolvableException;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterWebSocketClientClosedException;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRestClientErrorResponseException;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.apache.http.conn.HttpHostConnectException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/ui/JupyterErrorReporter;", "", "<init>", "()V", "Companion", "intellij.jupyter.core"})
public final class JupyterErrorReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rJ&\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0002J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J*\u0010\u0017\u001a\u00020\b2\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010\u0019\u001a\u00020\u00122\n\b\u0003\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/ui/JupyterErrorReporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "displayAndLogError", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "displayKernelProblem", "jupyterFileEditor", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;", "balloonMessage", "", "dialogMessage", "getJupyterFileEditor", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "showErrorDialog", "message", "title", "moreInfo", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterErrorReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterErrorReporter.kt\ncom/intellij/jupyter/core/jupyter/connections/ui/JupyterErrorReporter$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n4135#2,11:111\n*S KotlinDebug\n*F\n+ 1 JupyterErrorReporter.kt\ncom/intellij/jupyter/core/jupyter/connections/ui/JupyterErrorReporter$Companion\n*L\n96#1:111,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void displayAndLogError(@Nullable Project project, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Exception exception = e;
            if (exception instanceof JupyterKernelDoesNotExistsException) {
                BackedNotebookVirtualFile backedNotebookVirtualFile = ((JupyterKernelDoesNotExistsException)e).getNotebookVirtualFile();
                JupyterFileEditor jupyterFileEditor = this.getJupyterFileEditor(project, (VirtualFile)(backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getOriginFile() : null));
                v1 = JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(jupyterFileEditor, e, null){
                    int label;
                    final /* synthetic */ JupyterFileEditor $jupyterFileEditor;
                    final /* synthetic */ Exception $e;
                    {
                        this.$jupyterFileEditor = $jupyterFileEditor;
                        this.$e = $e;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                com.intellij.jupyter.core.jupyter.connections.ui.JupyterErrorReporter$Companion.access$displayKernelProblem(JupyterErrorReporter.Companion, this.$jupyterFileEditor, JupyterBundle.message("Jupyter.kernel.does.not.exist.balloon.message", new Object[0]), ((JupyterKernelDoesNotExistsException)this.$e).getMessage());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            } else if (exception instanceof JupyterKernelSpecMissingException) {
                JupyterFileEditor jupyterFileEditor = this.getJupyterFileEditor(project, ((JupyterKernelSpecMissingException)e).getNotebookVirtualFile().getOriginFile());
                v1 = JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(jupyterFileEditor, e, null){
                    int label;
                    final /* synthetic */ JupyterFileEditor $jupyterFileEditor;
                    final /* synthetic */ Exception $e;
                    {
                        this.$jupyterFileEditor = $jupyterFileEditor;
                        this.$e = $e;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                com.intellij.jupyter.core.jupyter.connections.ui.JupyterErrorReporter$Companion.access$displayKernelProblem(JupyterErrorReporter.Companion, this.$jupyterFileEditor, JupyterBundle.message("Jupyter.kernel.spec.is.missing.in.notebook.balloon.message", new Object[0]), ((JupyterKernelSpecMissingException)this.$e).getMessage());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            } else if (exception instanceof JupyterRestClientErrorResponseException) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.displayAndLogError$lambda$0(e));
                v1 = Unit.INSTANCE;
            } else if (exception instanceof JupyterWebSocketClientClosedException || exception instanceof JupyterManagedServerExited || exception instanceof HttpHostConnectException) {
                JupyterResolvableException rootException;
                Throwable throwable = e.getCause();
                JupyterResolvableException jupyterResolvableException = rootException = throwable instanceof JupyterResolvableException ? (JupyterResolvableException)throwable : null;
                if (rootException != null) {
                    rootException.resolve();
                    v1 = Unit.INSTANCE;
                } else {
                    v1 = JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(e, null){
                        int label;
                        final /* synthetic */ Exception $e;
                        {
                            this.$e = $e;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    com.intellij.jupyter.core.jupyter.connections.ui.JupyterErrorReporter$Companion.showErrorDialog$default(JupyterErrorReporter.Companion, this.$e.getMessage(), JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), null, 4, null);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                }
            } else {
                LOG.error("Unhandled Jupyter error", (Throwable)e);
                v1 = JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(e, null){
                    int label;
                    final /* synthetic */ Exception $e;
                    {
                        this.$e = $e;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                com.intellij.jupyter.core.jupyter.connections.ui.JupyterErrorReporter$Companion.showErrorDialog$default(JupyterErrorReporter.Companion, this.$e.getMessage(), JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), null, 4, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        }

        private final void displayKernelProblem(JupyterFileEditor jupyterFileEditor, @NlsContexts.DialogMessage String balloonMessage, @NlsContexts.DialogMessage String dialogMessage) {
            if (jupyterFileEditor != null && jupyterFileEditor.isValid()) {
                jupyterFileEditor.showErrorBalloonForKernelComboBoxAction(balloonMessage);
            } else {
                com.intellij.jupyter.core.jupyter.connections.ui.JupyterErrorReporter$Companion.showErrorDialog$default(this, dialogMessage, JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), null, 4, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final JupyterFileEditor getJupyterFileEditor(Project project, VirtualFile originalFile) {
            JupyterFileEditor jupyterFileEditor;
            if (project != null && originalFile != null) {
                void $this$filterIsInstanceTo$iv$iv;
                FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors(originalFile);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
                Object[] $this$filterIsInstance$iv = fileEditorArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JupyterFileEditor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                jupyterFileEditor = (JupyterFileEditor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            } else {
                jupyterFileEditor = null;
            }
            return jupyterFileEditor;
        }

        private final void showErrorDialog(@NlsContexts.DialogMessage String message2, @NlsContexts.DialogTitle String title, @NlsSafe String moreInfo) {
            if (moreInfo == null) {
                Messages.showErrorDialog((String)message2, (String)title);
            } else {
                String[] stringArray = new String[]{CommonBundle.getOkButtonText()};
                Messages.showDialog(null, (String)message2, (String)title, (String)moreInfo, (String[])stringArray, (int)0, (int)0, (Icon)Messages.getErrorIcon());
            }
        }

        static /* synthetic */ void showErrorDialog$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            companion.showErrorDialog(string, string2, string3);
        }

        private static final void displayAndLogError$lambda$0(Exception $e) {
            Companion.showErrorDialog($e.getMessage(), JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), ((JupyterRestClientErrorResponseException)((Object)$e)).getTraceback());
        }

        public static final /* synthetic */ void access$displayKernelProblem(Companion $this, JupyterFileEditor jupyterFileEditor, String balloonMessage, String dialogMessage) {
            $this.displayKernelProblem(jupyterFileEditor, balloonMessage, dialogMessage);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

