/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.NotebookMetadataLanguageProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"jupyterNotebookOrNull", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getJupyterNotebookOrNull", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getOriginalVirtualFile", "notebookJsonText", "", "getNotebookJsonText", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "notebookLanguage", "Lcom/intellij/lang/Language;", "getNotebookLanguage", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/lang/Language;", "intellij.jupyter.core"})
public final class JupyterFileExtensionsKt {
    @Nullable
    public static final JupyterNotebook getJupyterNotebookOrNull(@NotNull VirtualFile $this$jupyterNotebookOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$jupyterNotebookOrNull, (String)"<this>");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeFront($this$jupyterNotebookOrNull);
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebookOrNull() : null;
    }

    @NotNull
    public static final VirtualFile getOriginalVirtualFile(@NotNull VirtualFile $this$getOriginalVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getOriginalVirtualFile, (String)"<this>");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked($this$getOriginalVirtualFile);
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getOriginFile()) == null) {
            backedNotebookVirtualFile = $this$getOriginalVirtualFile;
        }
        return backedNotebookVirtualFile;
    }

    @NotNull
    public static final String getNotebookJsonText(@NotNull VirtualFile $this$notebookJsonText) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookJsonText, (String)"<this>");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked($this$notebookJsonText);
        if (backedNotebookVirtualFile == null) {
            backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.findOrCreate($this$notebookJsonText);
        }
        BackedNotebookVirtualFile backedFile = backedNotebookVirtualFile;
        ObjectNode notebookJson = backedFile.getNotebook().getJson();
        String string = notebookJson.toPrettyString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPrettyString(...)");
        return string;
    }

    @Nullable
    public static final Language getNotebookLanguage(@NotNull VirtualFile $this$notebookLanguage) {
        Language calculatedLanguage;
        Intrinsics.checkNotNullParameter((Object)$this$notebookLanguage, (String)"<this>");
        Object object = BackedNotebookVirtualFile.Companion.takeIfBacked($this$notebookLanguage);
        if (object != null && (object = object.getNotebookOrNull()) != null) {
            Object it = object;
            boolean bl = false;
            return it.getLanguage();
        }
        Language cachedLanguage = NotebookMetadataLanguageProvider.Utils.INSTANCE.getNotebookLanguage($this$notebookLanguage);
        if (cachedLanguage != null) {
            return cachedLanguage;
        }
        Language parentLanguage = NotebookMetadataLanguageProvider.Utils.INSTANCE.getNotebookLanguage($this$notebookLanguage.getParent());
        if (parentLanguage != null) {
            return parentLanguage;
        }
        JupyterNotebookBase jupyterNotebookBase = JupyterFileUtils.INSTANCE.readNotebookOrNull($this$notebookLanguage);
        Object object2 = calculatedLanguage = jupyterNotebookBase != null ? jupyterNotebookBase.getLanguage() : null;
        if (calculatedLanguage != null) {
            NotebookMetadataLanguageProvider.Utils.INSTANCE.setNotebookLanguage($this$notebookLanguage, calculatedLanguage);
        }
        return calculatedLanguage;
    }
}

