/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.references;

import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferenceSearcher;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/references/JupyterReferencesSearcher;", "Lcom/intellij/psi/search/searches/ReferenceSearcher;", "<init>", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/psi/PsiReference;", "parameters", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "intellij.jupyter.core"})
public final class JupyterReferencesSearcher
implements ReferenceSearcher {
    @NotNull
    public Collection<Query<? extends PsiReference>> collectSearchRequests(@NotNull ReferencesSearch.SearchParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        PsiFile psiFile = parameters.getElementToSearch().getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile virtualFile = psiFile;
        if (!(virtualFile instanceof BackedVirtualFile)) {
            return CollectionsKt.emptyList();
        }
        if (!parameters.getScopeDeterminedByUser().contains(((BackedVirtualFile)virtualFile).getOriginFile())) {
            return CollectionsKt.emptyList();
        }
        if (parameters.getEffectiveSearchScope() instanceof LocalSearchScope) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(parameters.getElementToSearch(), (SearchScope)new LocalSearchScope((PsiElement)parameters.getElementToSearch().getContainingFile()), false)));
    }
}

