/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSCachingFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JSLineBreakpointManagerBase;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManagerKt;
import com.intellij.javascript.debugger.LineVisitor;
import com.intellij.javascript.debugger.PsiVisitorKt;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptRegExpBreakpointTarget;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001;B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\bH\u0014J\"\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J.\u0010\u001a\u001a\u00020\u001b2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\fH\u0014J\"\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\"\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-J`\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190&2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u0001002\b\b\u0002\u00101\u001a\u00020\fJ<\u00102\u001a\b\u0012\u0004\u0012\u00020\u00190&2\u0006\u00103\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J$\u00105\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0&2\n\u00106\u001a\u0006\u0012\u0002\b\u0003072\u0006\u00108\u001a\u00020\u0014J\u001e\u00109\u001a\b\u0012\u0004\u0012\u00020\b0&2\u0006\u00103\u001a\u00020:2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "Lcom/intellij/javascript/debugger/JSLineBreakpointManagerBase;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "anyFirstLineBreakpoints", "Lcom/intellij/util/containers/ConcurrentList;", "Lorg/jetbrains/debugger/Breakpoint;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isAnyFirstLineBreakpoint", "", "breakpoint", "unregisterAnyFirstLineBreakpoint", "", "setAnyFirstLineBreakpoint", "vm", "Lorg/jetbrains/debugger/Vm;", "regExp", "", "condition", "setMeteorAnyClientScriptBreakpointIfNeeded", "isUseScriptIdTarget", "location", "Lorg/jetbrains/debugger/Location;", "createTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "isTemporary", "checkDuplicates", "newTarget", "findExisting", "Lorg/jetbrains/debugger/ScriptRegExpBreakpointTarget;", "createNameRegExp", "sourceMapFound", "", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "scriptUrl", "Lcom/intellij/util/Url;", "getActualLocations", "outSourceMappedLocationFound", "Lcom/intellij/openapi/util/Ref;", "keepEmptySourceMappedLocation", "findRawLocationsFromExactPosition", "position", "Lorg/jetbrains/debugger/SourceInfo;", "findTopFirstLineBreakpoints", "context", "Lorg/jetbrains/debugger/SuspendContext;", "scriptName", "doRunToLocation", "Lcom/intellij/xdebugger/XSourcePosition;", "VmBreakpointLocation", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nJavaScriptLineBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptLineBreakpointManager.kt\ncom/intellij/javascript/debugger/JavaScriptLineBreakpointManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n774#2:454\n865#2:455\n1755#2,3:456\n866#2:459\n1368#2:460\n1454#2,2:461\n1557#2:463\n1628#2,3:464\n1456#2,3:467\n1557#2:470\n1628#2,3:471\n*S KotlinDebug\n*F\n+ 1 JavaScriptLineBreakpointManager.kt\ncom/intellij/javascript/debugger/JavaScriptLineBreakpointManager\n*L\n197#1:454\n197#1:455\n199#1:456,3\n197#1:459\n221#1:460\n221#1:461,2\n237#1:463\n237#1:464,3\n221#1:467,3\n325#1:470\n325#1:471,3\n*E\n"})
public class JavaScriptLineBreakpointManager
extends JSLineBreakpointManagerBase {
    @NotNull
    private final ConcurrentList<Breakpoint> anyFirstLineBreakpoints;

    public JavaScriptLineBreakpointManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(debugProcess);
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.anyFirstLineBreakpoints = concurrentList;
    }

    @Override
    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        return this.anyFirstLineBreakpoints.contains((Object)breakpoint);
    }

    @Override
    protected void unregisterAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        this.anyFirstLineBreakpoints.remove((Object)breakpoint);
    }

    public final void setAnyFirstLineBreakpoint(@NotNull Vm vm, @NotNull String regExp, @Nullable String condition) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)regExp, (String)"regExp");
        BreakpointManager breakpointManager = vm.getBreakpointManager();
        JavaScriptDebugProcessKt.getLOG().assertTrue(breakpointManager.getRegExpBreakpointSupported());
        BreakpointManager.SetBreakpointResult setBreakpointResult = BreakpointManager.setBreakpoint$default((BreakpointManager)breakpointManager, (BreakpointTarget)((BreakpointTarget)new ScriptRegExpBreakpointTarget(regExp)), (int)0, (int)0, null, (String)condition, (int)0, (int)36, null);
        if (setBreakpointResult instanceof BreakpointManager.BreakpointCreated) {
            this.anyFirstLineBreakpoints.add((Object)((BreakpointManager.BreakpointCreated)setBreakpointResult).getBreakpoint());
        }
    }

    public static /* synthetic */ void setAnyFirstLineBreakpoint$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, Vm vm, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAnyFirstLineBreakpoint");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        javaScriptLineBreakpointManager.setAnyFirstLineBreakpoint(vm, string, string2);
    }

    public final void setMeteorAnyClientScriptBreakpointIfNeeded(@NotNull Vm vm, @NotNull String regExp) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)regExp, (String)"regExp");
        for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            Intrinsics.checkNotNull((Object)breakpointTarget, (String)"null cannot be cast to non-null type org.jetbrains.debugger.ScriptRegExpBreakpointTarget");
            if (!Intrinsics.areEqual((Object)((ScriptRegExpBreakpointTarget)breakpointTarget).toString(), (Object)regExp)) continue;
            return;
        }
        JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this, vm, regExp, null, 4, null);
    }

    private final boolean isUseScriptIdTarget(Location location) {
        block8: {
            block7: {
                if (Intrinsics.areEqual((Object)location.getUrl().getScheme(), (Object)"vm") || Intrinsics.areEqual((Object)location.getUrl().getScheme(), (Object)"webpack-internal")) break block7;
                String string = location.getUrl().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\\expo\\", (boolean)false, (int)2, null)) break block8;
            }
            return true;
        }
        if (this.getDebugProcess$intellij_javascript_debugger().getScriptsCanBeReloaded()) {
            return false;
        }
        if (this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem()) {
            return true;
        }
        if (!this.anyFirstLineBreakpoints.isEmpty()) {
            String string = location.getUrl().toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            String scriptUrl = string;
            for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
                if (!(breakpoint.getTarget() instanceof ScriptRegExpBreakpointTarget)) continue;
                String string2 = breakpoint.getTarget().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                if (!JavaScriptLineBreakpointManagerKt.match(string2, scriptUrl)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> breakpoint, @NotNull BreakpointManager breakpointManager, @NotNull Location location, boolean isTemporary) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)breakpointManager, (String)"breakpointManager");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Script script = location.getScript();
        if (!isTemporary && script != null) {
            if (this.isUseScriptIdTarget(location)) {
                return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
            }
            String string = script.getUrl().toDecodedForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toDecodedForm(...)");
            if (((CharSequence)string).length() > 0) {
                return (BreakpointTarget)new BreakpointTarget.ScriptName(script);
            }
        }
        if (isTemporary && script != null) {
            return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
        }
        if (breakpointManager.getRegExpBreakpointSupported() && (location.getUrl().isInLocalFileSystem() || !((charSequence = (CharSequence)location.getUrl().getAuthority()) == null || charSequence.length() == 0))) {
            return (BreakpointTarget)new ScriptRegExpBreakpointTarget(this.createNameRegExp(location));
        }
        if (script == null) {
            return (BreakpointTarget)new BreakpointTarget.ScriptName(location.getUrl().toDecodedForm());
        }
        return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
    }

    @Override
    @Nullable
    protected Breakpoint checkDuplicates(@NotNull BreakpointTarget newTarget, @NotNull Location location, @NotNull BreakpointManager breakpointManager) {
        Breakpoint breakpoint;
        Intrinsics.checkNotNullParameter((Object)newTarget, (String)"newTarget");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)breakpointManager, (String)"breakpointManager");
        if (location.getScript() != null && newTarget instanceof ScriptRegExpBreakpointTarget && (breakpoint = this.findExisting(breakpointManager, location, (ScriptRegExpBreakpointTarget)newTarget)) != null) {
            Breakpoint it = breakpoint;
            boolean bl = false;
            return it;
        }
        return super.checkDuplicates(newTarget, location, breakpointManager);
    }

    private final Breakpoint findExisting(BreakpointManager breakpointManager, Location location, ScriptRegExpBreakpointTarget newTarget) {
        for (Breakpoint breakpoint : breakpointManager.getBreakpoints()) {
            BreakpointTarget target = breakpoint.getTarget();
            if (!(target instanceof ScriptRegExpBreakpointTarget) || this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != location.getLine() || breakpoint.getColumn() != -1 && breakpoint.getColumn() != location.getColumn() || !StringsKt.endsWith$default((String)newTarget.toString(), (String)((ScriptRegExpBreakpointTarget)target).toString(), (boolean)false, (int)2, null)) continue;
            return breakpoint;
        }
        return null;
    }

    private final String createNameRegExp(Location location) {
        boolean useCaseSensitiveUrl = this.getDebugProcess$intellij_javascript_debugger().isUrlsCaseSensitive();
        if (this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem() && location.getUrl().isInLocalFileSystem()) {
            JavaScriptDebugProcess<?> javaScriptDebugProcess = this.getDebugProcess$intellij_javascript_debugger();
            Url url = location.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"getUrl(...)");
            String filePathRegExp = javaScriptDebugProcess.createFilePathRegExp(url, false, useCaseSensitiveUrl);
            if (filePathRegExp != null) {
                return filePathRegExp;
            }
        }
        return JavaScriptLineBreakpointManagerKt.access$createUrlRegExp(location, useCaseSensitiveUrl);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<VmBreakpointLocation> sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (!this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem() || script == null) ** GOTO lbl-1000
        v0 = script.getUrl().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
        if (StringsKt.contains$default((CharSequence)v0, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isScriptInNodeModules = v1;
        sourceMapFound = null;
        v2 = ApplicationManager.getApplication().runReadAction((Computable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, sourceMapFound$lambda$1(com.intellij.javascript.debugger.JavaScriptLineBreakpointManager ), ()[Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)((JavaScriptLineBreakpointManager)this));
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"runReadAction(...)");
        for (XBreakpoint breakpoint : (XBreakpoint[])v2) {
            if (!(breakpoint instanceof XLineBreakpoint) || ((XLineBreakpoint)breakpoint).getSourcePosition() == null) continue;
            if (isScriptInNodeModules) {
                v3 = breakpointLocation.getFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPath(...)");
                if (!StringsKt.contains$default((CharSequence)v3, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) continue;
            }
            sourceMappedLocationFound = Ref.create((Object)false);
            $this$filter$iv = JavaScriptLineBreakpointManager.getActualLocations$default(this, (XLineBreakpoint)breakpoint, vm, map, script, scriptUrl, sourceMappedLocationFound, false, 64, null);
            $i$f$filter = false;
            var16_16 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block10: {
                    actualLocation = (Location)element$iv$iv;
                    $i$a$-filter-JavaScriptLineBreakpointManager$sourceMapFound$actualLocations$1 = false;
                    newTarget = this.createTarget((XLineBreakpoint)breakpoint, vm.getBreakpointManager(), actualLocation, false);
                    $this$any$iv = vm.getBreakpointManager().getBreakpoints();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (Breakpoint)element$iv;
                            $i$a$-any-JavaScriptLineBreakpointManager$sourceMapFound$actualLocations$1$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getTarget(), (Object)newTarget)) continue;
                            v4 = true;
                            break block10;
                        }
                        v4 = false;
                    }
                }
                if (!(v4 == false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            actualLocations = (List)destination$iv$iv;
            if (!(((Collection)actualLocations).isEmpty() == false) || !((Boolean)sourceMappedLocationFound.get()).booleanValue() && !this.getVmBreakpoints(vm, (XLineBreakpoint)breakpoint).isEmpty()) continue;
            if (sourceMapFound == null) {
                sourceMapFound = (List)new SmartList();
            }
            sourceMapFound.add(new VmBreakpointLocation((XLineBreakpoint)breakpoint, actualLocations));
        }
        v5 = sourceMapFound;
        if (v5 == null) {
            v5 = CollectionsKt.emptyList();
        }
        return v5;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getActualLocations(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Vm vm, @Nullable SourceMap map, @Nullable Script script, @Nullable Url scriptUrl, @Nullable Ref<Boolean> outSourceMappedLocationFound, boolean keepEmptySourceMappedLocation) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Project project = this.getDebugProcess$intellij_javascript_debugger().getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<SourceInfo> positionsInLine = PsiVisitorKt.getPositionsInLine(breakpoint, project);
        Iterable $this$flatMap$iv = positionsInLine;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            List<Location> rawLocationsFromExactPosition;
            SourceInfo it = (SourceInfo)element$iv$iv;
            boolean bl = false;
            List rawLocations = SourceMapHelperKt.getRawLocations(this.getDebugProcess$intellij_javascript_debugger(), vm, it.getFile(), it.getLine(), map, script, scriptUrl, it.getColumn());
            if (rawLocations.size() > 1 && it.getColumn() == -1 && !((Collection)(rawLocationsFromExactPosition = this.findRawLocationsFromExactPosition(it, vm, map, script, scriptUrl))).isEmpty()) {
                rawLocations = rawLocationsFromExactPosition;
            }
            if (outSourceMappedLocationFound != null && !((Collection)rawLocations).isEmpty()) {
                outSourceMappedLocationFound.set((Object)true);
            }
            if (keepEmptySourceMappedLocation && rawLocations.isEmpty()) {
                Url originalUrl = it.getUrl();
                if (originalUrl != null) {
                    list = CollectionsKt.listOf((Object)new Location(originalUrl, it.getLine(), it.getColumn()));
                } else if (it.getFile() instanceof VmScriptFile) {
                    VirtualFile virtualFile = it.getFile();
                    Intrinsics.checkNotNull((Object)virtualFile, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.scripts.VmScriptFile");
                    list = CollectionsKt.listOf((Object)new Location(((VmScriptFile)virtualFile).getScript(), it.getLine(), it.getColumn()));
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.getDebugProcess$intellij_javascript_debugger().getFinder().getRemoteUrls(it.getFile());
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void url;
                        Url url2 = (Url)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(new Location((Url)url, it.getLine(), it.getColumn()));
                    }
                    list = (List)destination$iv$iv2;
                }
            } else {
                list = rawLocations;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getActualLocations$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, XLineBreakpoint xLineBreakpoint, Vm vm, SourceMap sourceMap, Script script, Url url, Ref ref, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getActualLocations");
        }
        if ((n & 4) != 0) {
            sourceMap = null;
        }
        if ((n & 8) != 0) {
            script = null;
        }
        if ((n & 0x10) != 0) {
            url = null;
        }
        if ((n & 0x20) != 0) {
            ref = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return javaScriptLineBreakpointManager.getActualLocations(xLineBreakpoint, vm, sourceMap, script, url, (Ref<Boolean>)ref, bl);
    }

    private final List<Location> findRawLocationsFromExactPosition(SourceInfo position, Vm vm, SourceMap map, Script script, Url scriptUrl) {
        List<Location> list;
        Integer firstVarColumn2;
        Integer n = firstVarColumn2 = PsiVisitorKt.computeInNBRA(() -> JavaScriptLineBreakpointManager.findRawLocationsFromExactPosition$lambda$6(position, this));
        int n2 = -1;
        if (n == null || n != n2) {
            JavaScriptDebugProcess<?> javaScriptDebugProcess = this.getDebugProcess$intellij_javascript_debugger();
            VirtualFile virtualFile = position.getFile();
            int n3 = position.getLine();
            Intrinsics.checkNotNull((Object)firstVarColumn2);
            list = SourceMapHelperKt.getRawLocations(javaScriptDebugProcess, vm, virtualFile, n3, map, script, scriptUrl, firstVarColumn2);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findTopFirstLineBreakpoints(@NotNull SuspendContext<?> context, @NotNull String scriptName) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        CallFrame callFrame = context.getTopFrame();
        int breakLine = callFrame != null ? callFrame.getLine() : 0;
        for (Breakpoint breakpoint : context.getVm().getBreakpointManager().getBreakpoints()) {
            Script script;
            if (this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != 0 && breakpoint.getLine() != breakLine) continue;
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            BreakpointTarget breakpointTarget2 = breakpointTarget;
            boolean bl = breakpointTarget2 instanceof ScriptRegExpBreakpointTarget ? JavaScriptLineBreakpointManagerKt.match(((ScriptRegExpBreakpointTarget)breakpointTarget).toString(), scriptName) : (breakpointTarget2 instanceof BreakpointTarget.ScriptName ? Intrinsics.areEqual((Object)scriptName, (Object)((BreakpointTarget.ScriptName)breakpointTarget).toString()) : (breakpointTarget2 instanceof BreakpointTarget.ScriptId ? Intrinsics.areEqual((Object)scriptName, (Object)(script = ((BreakpointTarget.ScriptId)breakpointTarget).script).getUrl().trimParameters().toExternalForm()) || Intrinsics.areEqual((Object)scriptName, (Object)script.getUrl().trimParameters().toDecodedForm()) : false));
            if (!bl) continue;
            List list = this.getVmToIdeBreakpoints().get(breakpoint);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Breakpoint> doRunToLocation(@NotNull XSourcePosition position, @NotNull Vm vm) {
        List list;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        List locations = SourceMapHelperKt.getRawLocations$default(this.getDebugProcess$intellij_javascript_debugger(), vm, position, null, null, null, 56, null);
        if (locations.isEmpty()) {
            DebuggableFileFinder debuggableFileFinder = this.getDebugProcess$intellij_javascript_debugger().getFinder().getDelegate();
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            if (debuggableFileFinder.isOnlySourceMappedBreakpoints(virtualFile)) {
                Object[] objectArray = new Object[]{position};
                String string = JSDebuggerBundle.message("javascript.debugger.notification.error.cannot.run.to.location", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                this.getDebugProcess$intellij_javascript_debugger().getSession().reportError(message);
                JavaScriptDebugProcessKt.getLOG().warn(message);
                return CollectionsKt.emptyList();
            }
        }
        Function1 resultToBreakpoint = JavaScriptLineBreakpointManager::doRunToLocation$lambda$7;
        if (locations.isEmpty()) {
            JSCachingFileFinder jSCachingFileFinder = this.getDebugProcess$intellij_javascript_debugger().getFinder();
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            List<Url> urls = jSCachingFileFinder.getRemoteUrls(virtualFile);
            SourceInfo sourceInfo = position instanceof SourceInfo ? (SourceInfo)position : null;
            Location location = new Location((Url)CollectionsKt.first(urls), position.getLine(), sourceInfo != null ? sourceInfo.getColumn() : -1);
            list = CollectionsKt.listOfNotNull((Object)resultToBreakpoint.invoke((Object)this.doSetBreakpoint(vm, null, location, true)));
        } else {
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = locations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Location location = (Location)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.doSetBreakpoint(vm, null, (Location)it, true));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(resultToBreakpoint.invoke(item$iv$iv));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final XBreakpoint[] sourceMapFound$lambda$1(JavaScriptLineBreakpointManager this$0) {
        return XDebuggerManager.getInstance((Project)this$0.getDebugProcess$intellij_javascript_debugger().getSession().getProject()).getBreakpointManager().getAllBreakpoints();
    }

    private static final Integer findRawLocationsFromExactPosition$lambda$6(SourceInfo $position, JavaScriptLineBreakpointManager this$0) {
        Ref.IntRef result = new Ref.IntRef();
        result.element = -1;
        PsiVisitors.visit((XSourcePosition)((XSourcePosition)$position), (Project)this$0.getDebugProcess$intellij_javascript_debugger().getSession().getProject(), null, (PsiVisitors.Visitor)new LineVisitor(this$0, result){
            final /* synthetic */ JavaScriptLineBreakpointManager this$0;
            final /* synthetic */ Ref.IntRef $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void visitJSElement(JSElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof JSVarStatement) {
                    Document document;
                    JSVariable[] jSVariableArray = ((JSVarStatement)node).getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
                    JSVariable[] variables = jSVariableArray;
                    if (!(variables.length == 0) && (document = PsiDocumentManager.getInstance((Project)this.this$0.getDebugProcess$intellij_javascript_debugger().getSession().getProject()).getDocument(((JSVarStatement)node).getContainingFile())) != null) {
                        int offset = variables[0].getTextRange().getStartOffset();
                        this.$result.element = offset - DocumentUtil.getLineStartOffset((int)offset, (Document)document);
                    }
                }
                this.isStopped = true;
            }
        });
        return result.element;
    }

    private static final Breakpoint doRunToLocation$lambda$7(BreakpointManager.SetBreakpointResult result) {
        Breakpoint breakpoint;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        BreakpointManager.SetBreakpointResult setBreakpointResult = result;
        if (setBreakpointResult instanceof BreakpointManager.BreakpointCreated) {
            breakpoint = ((BreakpointManager.BreakpointCreated)result).getBreakpoint();
        } else if (setBreakpointResult instanceof BreakpointManager.BreakpointExist) {
            breakpoint = ((BreakpointManager.BreakpointExist)result).getExistingBreakpoint();
        } else {
            throw new AssertionError(result.getClass());
        }
        return breakpoint;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "actualLocations", "", "Lorg/jetbrains/debugger/Location;", "<init>", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;Ljava/util/List;)V", "getBreakpoint", "()Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getActualLocations", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.debugger"})
    public static final class VmBreakpointLocation {
        @NotNull
        private final XLineBreakpoint<?> breakpoint;
        @NotNull
        private final List<Location> actualLocations;

        public VmBreakpointLocation(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter(actualLocations, (String)"actualLocations");
            this.breakpoint = breakpoint;
            this.actualLocations = actualLocations;
        }

        @NotNull
        public final XLineBreakpoint<?> getBreakpoint() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> getActualLocations() {
            return this.actualLocations;
        }

        @NotNull
        public final XLineBreakpoint<?> component1() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> component2() {
            return this.actualLocations;
        }

        @NotNull
        public final VmBreakpointLocation copy(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter(actualLocations, (String)"actualLocations");
            return new VmBreakpointLocation(breakpoint, actualLocations);
        }

        public static /* synthetic */ VmBreakpointLocation copy$default(VmBreakpointLocation vmBreakpointLocation, XLineBreakpoint xLineBreakpoint, List list, int n, Object object) {
            if ((n & 1) != 0) {
                xLineBreakpoint = vmBreakpointLocation.breakpoint;
            }
            if ((n & 2) != 0) {
                list = vmBreakpointLocation.actualLocations;
            }
            return vmBreakpointLocation.copy(xLineBreakpoint, list);
        }

        @NotNull
        public String toString() {
            return "VmBreakpointLocation(breakpoint=" + this.breakpoint + ", actualLocations=" + this.actualLocations + ")";
        }

        public int hashCode() {
            int result = this.breakpoint.hashCode();
            result = result * 31 + ((Object)this.actualLocations).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VmBreakpointLocation)) {
                return false;
            }
            VmBreakpointLocation vmBreakpointLocation = (VmBreakpointLocation)other;
            if (!Intrinsics.areEqual(this.breakpoint, vmBreakpointLocation.breakpoint)) {
                return false;
            }
            return Intrinsics.areEqual(this.actualLocations, vmBreakpointLocation.actualLocations);
        }
    }
}

