/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CssIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssSimpleNamedStubElementType;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssCustomPropertySelfReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssDeclarationImpl
extends CssNamedStubElement<CssNamedStub<CssDeclaration>>
implements CssDeclaration {
    private volatile CssPropertyDescriptor myCachedDescriptor;
    private volatile long myDescriptorModCount = -1L;

    public CssDeclarationImpl(CssNamedStub<CssDeclaration> stub, CssSimpleNamedStubElementType type) {
        super(stub, type);
    }

    public CssDeclarationImpl(ASTNode node) {
        super(node);
    }

    public String getName() {
        return this.getPropertyName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement element;
        if (name == null) {
            CssDeclarationImpl.$$$reportNull$$$0(0);
        }
        if ((element = this.getPropertyNameElement()) != null) {
            if (this.isCustomProperty() && !((String)name).startsWith("--")) {
                name = "--" + (String)name;
            }
            CssPsiUtil.replaceToken(element, (String)name);
        }
        return this;
    }

    @Override
    @NotNull
    public String getPropertyName() {
        CssNamedStub stub = (CssNamedStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                CssDeclarationImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        PsiElement _firstChild = this.getPropertyNameElement();
        if (_firstChild != null) {
            String name = _firstChild.getText();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '\\') continue;
                b.append(c);
            }
            String string = b.toString();
            if (string == null) {
                CssDeclarationImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    @Override
    @Nullable
    public PsiElement getPropertyNameElement() {
        ASTNode firstIdentifier = (ASTNode)this.findChildByType(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_HASH}));
        return firstIdentifier != null ? firstIdentifier.getPsi() : null;
    }

    @Override
    @Nullable
    public CssTermList getValue() {
        return (CssTermList)this.findChildByType(CssElementTypes.CSS_TERM_LIST);
    }

    @Override
    @NotNull
    public TextRange getTrimmedValueTextRange() {
        TextRange textRange = CssPsiUtil.getValueTextRange(this);
        if (textRange == null) {
            CssDeclarationImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getValueTextRange() {
        TextRange textRange = CssPsiUtil.getValueTextRange(this);
        if (textRange == null) {
            CssDeclarationImpl.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Override
    public boolean isShorthandProperty() {
        CssPropertyDescriptor descriptor = this.getDescriptor();
        return descriptor != null && descriptor.isShorthandValue();
    }

    @Override
    public boolean isCustomProperty() {
        return StringUtil.startsWith((CharSequence)this.getPropertyName(), (CharSequence)"--");
    }

    @Override
    public String @NotNull [] expandShorthandProperty() {
        CssPropertyDescriptor descriptor = this.getDescriptor();
        String[] stringArray = descriptor == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : descriptor.expand(this);
        if (stringArray == null) {
            CssDeclarationImpl.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    public String[] getShorthandValue(@NotNull String propertyName) {
        PsiElement[] values;
        if (propertyName == null) {
            CssDeclarationImpl.$$$reportNull$$$0(6);
        }
        if ((values = this.getShorthandPsiValue(propertyName)) == null) {
            return null;
        }
        if (values.length == 1 || values.length == 2 && values[0].getText().equals(values[1].getText())) {
            PsiElement term;
            if ("background-size".equalsIgnoreCase(propertyName)) {
                return new String[]{values[0].getText() + " " + values[0].getText()};
            }
            if ("background-position".equalsIgnoreCase(propertyName) && (term = values[0]) instanceof CssTerm && ((CssTerm)term).getTermType() != CssTermTypes.IDENT) {
                return new String[]{values[0].getText() + " " + values[0].getText()};
            }
        }
        String[] result = ArrayUtil.newStringArray((int)values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getText();
        }
        return result;
    }

    @Override
    public PsiElement @Nullable [] getShorthandPsiValue(@NotNull String propertyName) {
        if (propertyName == null) {
            CssDeclarationImpl.$$$reportNull$$$0(7);
        }
        if (!this.isShorthandProperty()) {
            return null;
        }
        CssPropertyDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        String[] propertyNames = this.expandShorthandProperty();
        if (!Arrays.asList(propertyNames).contains(propertyName)) {
            return null;
        }
        return descriptor.getShorthandPsiValue(this, propertyName);
    }

    @Override
    public boolean isImportant() {
        return CssPsiUtil.findToken(this, TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IMPORTANT})) != null;
    }

    @Override
    public boolean isEqualTo(Object object) {
        if (!(object instanceof CssDeclarationImpl)) {
            return false;
        }
        CssDeclarationImpl declaration = (CssDeclarationImpl)object;
        CssTermList value = this.getValue();
        CssTermList declarationValue = declaration.getValue();
        return this.getPropertyName().equalsIgnoreCase(declaration.getPropertyName()) && value != null && declarationValue != null && value.getText().equals(declarationValue.getText());
    }

    @Override
    public int equalityHashCode() {
        return 31 * StringUtil.toLowerCase((String)this.getPropertyName()).hashCode() + CssPsiUtil.hashCodeForElement(this.getValue());
    }

    @Override
    public void setValue(String propertyValue) throws IncorrectOperationException {
        Language language = CssPsiUtil.getStylesheetLanguage(this);
        CssTermList newValue = CssElementFactory.getInstance(this.getProject()).createPropertyValue(propertyValue, language);
        CssTermList oldValue = this.getValue();
        if (oldValue != null) {
            oldValue.replace(newValue);
        }
    }

    @Override
    @Deprecated
    @Nullable
    public CssPropertyDescriptor getDescriptor() {
        PsiManagerEx manager = this.getManager();
        if (manager == null) {
            return null;
        }
        long curModCount = manager.getModificationTracker().getModificationCount();
        if (this.myDescriptorModCount != curModCount) {
            this.myCachedDescriptor = CssDescriptorsUtil.getPropertyDescriptor(this.getPropertyName(), this);
            this.myDescriptorModCount = curModCount;
        }
        return this.myCachedDescriptor;
    }

    @Override
    public boolean isHack() {
        String text = this.getText().trim();
        if (CssUtil.isHackPropertyName(text)) {
            return true;
        }
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)this);
        return nextVisibleLeaf instanceof PsiComment && ((PsiComment)nextVisibleLeaf).getTokenType() == CssElementTypes.CSS_HACK;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssDeclarationImpl.$$$reportNull$$$0(8);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssDeclaration(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public Collection<? extends CssPropertyDescriptor> getDescriptors() {
        Collection<? extends CssPropertyDescriptor> collection = this.getDescriptors(this);
        if (collection == null) {
            CssDeclarationImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<? extends CssPropertyDescriptor> getDescriptors(@NotNull PsiElement context) {
        if (context == null) {
            CssDeclarationImpl.$$$reportNull$$$0(10);
        }
        Collection<? extends CssPropertyDescriptor> collection = CssDescriptorsUtil.getPropertyDescriptors(this.getPropertyName(), context);
        if (collection == null) {
            CssDeclarationImpl.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.isCustomProperty() ? CssIcons.Custom_property : null;
    }

    public ItemPresentation getPresentation() {
        return new CssNamedItemPresentation(this, StringUtil.trimStart((String)this.getName(), (String)"--"));
    }

    public PsiReference getReference() {
        PsiElement element;
        if (this.isCustomProperty() && (element = this.getPropertyNameElement()) != null) {
            int startOffset = this.getTextOffset() - this.getTextRange().getStartOffset();
            return new CssCustomPropertySelfReference(this, TextRange.from((int)startOffset, (int)this.getName().length()));
        }
        return super.getReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssDeclarationImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssDeclarationImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedValueTextRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "expandShorthandProperty";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShorthandValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getShorthandPsiValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 9, 11 -> new IllegalStateException(string);
        };
    }
}

